/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jetbrains.annotations.NotNull;

class PausableExecutor
implements Executor {
    private final ExecutorService singleThreadExecutor = Executors.newSingleThreadExecutor();
    private volatile boolean paused = false;

    PausableExecutor() {
    }

    @Override
    public void execute(@NotNull Runnable command) {
        this.singleThreadExecutor.execute(() -> {
            this.waitTillExecutionIsAllowed();
            command.run();
        });
    }

    private void waitTillExecutionIsAllowed() {
        while (this.paused) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("I was interrupted", e);
            }
        }
    }

    public void pause() {
        this.paused = true;
    }

    public void unpause() {
        this.paused = false;
    }

    public void shutdownNow() {
        this.singleThreadExecutor.shutdownNow();
    }
}

