/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.recovery;

import java.util.List;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.GridLongList;
import org.apache.ignite.plugin.PluginConfiguration;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.internal.processors.cache.database.IgniteSnapshotUpdateOperationsTest;
import org.gridgain.grid.persistentstore.SnapshotChainMode;
import org.gridgain.grid.persistentstore.SnapshotInfo;
import org.gridgain.grid.persistentstore.SnapshotOperationType;
import org.gridgain.grid.persistentstore.SnapshotUpdateOperationParams;
import org.junit.Test;

public class GridPITRSnapshotUpdateOperationsTest
extends IgniteSnapshotUpdateOperationsTest {
    @Override
    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        GridGainConfiguration configuration = (GridGainConfiguration)cfg.getPluginConfigurations()[0];
        configuration.setSnapshotConfiguration(configuration.getSnapshotConfiguration().setPointInTimeRecoveryEnabled(true));
        return cfg;
    }

    @Override
    protected void doTest0(IgniteEx ex, GridGain gg, SnapshotOperationType operation) throws IgniteCheckedException {
        PluginConfiguration[] configurations = ex.configuration().getPluginConfigurations();
        GridGainConfiguration ggCfg = null;
        for (PluginConfiguration configuration : configurations) {
            if (!(configuration instanceof GridGainConfiguration)) continue;
            ggCfg = (GridGainConfiguration)configuration;
            break;
        }
        GridPITRSnapshotUpdateOperationsTest.assertNotNull(ggCfg);
        GridPITRSnapshotUpdateOperationsTest.assertTrue((boolean)ggCfg.getSnapshotConfiguration().isPointInTimeRecoveryEnabled());
        this.createSnapshotChain(ex, gg.snapshot(), 1);
    }

    @Override
    public void testThatRemovingLastSnapshotDoesntForceFullSnapshot() throws Exception {
    }

    @Override
    public void testSinglePartitionCopyRestrictions() throws Exception {
        super.testSinglePartitionCopyRestrictions();
        IgniteEx grid = this.grid(0);
        GridGain gg = (GridGain)grid.plugin("GridGain");
        List infos = gg.snapshot().list();
        GridPITRSnapshotUpdateOperationsTest.assertTrue((!infos.isEmpty() ? 1 : 0) != 0);
        GridPITRSnapshotUpdateOperationsTest.assertTrue((boolean)((SnapshotInfo)infos.get(0)).fullSnapshot());
        try {
            gg.snapshot().copySnapshot(((SnapshotInfo)infos.get(0)).snapshotId(), this.moveDir, false, new SnapshotUpdateOperationParams(SnapshotChainMode.SINGLE, false, true, null), null).get();
            GridPITRSnapshotUpdateOperationsTest.fail((String)"'Single partition copy' should fail when there wal should be moved.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testUpdateOperationWithPITR() throws Exception {
        IgniteEx ex = this.startCluster();
        this.load((Ignite)ex);
        GridGain gg = (GridGain)ex.plugin("GridGain");
        GridLongList chain = this.createSnapshotChain(ex, gg.snapshot(), 10);
        long last = chain.get(chain.size() - 1);
        try {
            gg.snapshot().moveSnapshot(last, this.moveDir, true, new SnapshotUpdateOperationParams(SnapshotChainMode.SINGLE), null).get();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            gg.snapshot().deleteSnapshot(last, new SnapshotUpdateOperationParams(SnapshotChainMode.SINGLE), null).get();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            gg.snapshot().copySnapshot(last, this.moveDir, new SnapshotUpdateOperationParams(SnapshotChainMode.SINGLE), null).get();
        }
        catch (Exception exception) {
            // empty catch block
        }
        gg.snapshot().copySnapshot(last, this.moveDir, true, new SnapshotUpdateOperationParams(SnapshotChainMode.SINGLE), null).get();
    }
}

