/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.recovery;

import java.util.ArrayList;
import java.util.Map;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.GridGainImpl;
import org.gridgain.grid.internal.processors.cache.database.GridSnapshotEx;
import org.gridgain.grid.internal.processors.cache.database.RecoveryParams;
import org.gridgain.grid.internal.processors.cache.database.recovery.GridPointInTimeRecoveryAbstractTest;
import org.gridgain.grid.internal.processors.cache.database.snapshot.ConsistentCutMeta;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetadataV2;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotOperationInfo;
import org.junit.Test;

@WithSystemProperty(key="GG_EXCHANGELESS_POINT_IN_TIME_RECOVERY", value="true")
public class GridExchangelessPointInTimeRecoveryLocalTest
extends GridPointInTimeRecoveryAbstractTest {
    @Override
    protected CacheConfiguration[] prepareCachesConfiguration() {
        CacheConfiguration ccfg = new CacheConfiguration("default");
        ccfg.setCacheMode(CacheMode.PARTITIONED);
        ccfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32));
        ccfg.setBackups(2);
        return new CacheConfiguration[]{ccfg};
    }

    @Test
    public void testCreatingExchangelessSnapshotWithPitrEnabled() throws Exception {
        int nodes = 1;
        this.startGrids(nodes);
        IgniteEx igClient = this.startGrid(nodes);
        igClient.cluster().state(ClusterState.ACTIVE);
        this.awaitPartitionMapExchange();
        AffinityTopologyVersion initialTopVer = this.grid(0).context().cache().context().exchange().readyAffinityVersion();
        GridGain gg = (GridGain)igClient.plugin("GridGain");
        GridSnapshotEx snp = (GridSnapshotEx)gg.snapshot();
        SnapshotFuture snpFut = snp.createFullSnapshot(null, "Full snapshot.");
        snpFut.get();
        AffinityTopologyVersion topVer = this.grid(0).context().cache().context().exchange().readyAffinityVersion();
        GridExchangelessPointInTimeRecoveryLocalTest.assertEquals((String)"Creating full snasphot triggered PME.", (Object)initialTopVer, (Object)topVer);
        long snpId = snpFut.snapshotOperation().snapshotId();
        GridGainImpl gg0 = (GridGainImpl)this.grid(0).plugin("GridGain");
        GridCacheSnapshotManager snapMgr = (GridCacheSnapshotManager)gg0.provider().databaseManager();
        SnapshotMetadataV2 snpMeta = null;
        for (SnapshotMetadataV2 meta : snapMgr.snapshotSpi().localSnapshots(true)) {
            if (meta.id() != snpId) continue;
            snpMeta = meta;
            break;
        }
        GridExchangelessPointInTimeRecoveryLocalTest.assertNotNull((String)("Could not find snapshot metadata [snpId=" + snpId + ']'), (Object)snpMeta);
        GridExchangelessPointInTimeRecoveryLocalTest.assertTrue((String)("Found PME based snapshot instead of exchangeless one [meta=" + snpMeta + ']'), (boolean)snpMeta.exchangelessSnapshot());
        GridExchangelessPointInTimeRecoveryLocalTest.assertNotNull((String)("Snapshot metadata does not contain consistent cut meta information [meta=" + snpMeta + ']'), (Object)snpMeta.consistentCutMetas());
        Map cutMetas = snpMeta.consistentCutMetas();
        GridExchangelessPointInTimeRecoveryLocalTest.assertEquals((String)("Unexpected number of consistent cut metas [cutMeta=" + cutMetas + ']'), (int)1, (int)cutMetas.size());
        ConsistentCutMeta cutMeta = (ConsistentCutMeta)cutMetas.values().iterator().next();
        GridExchangelessPointInTimeRecoveryLocalTest.assertNotNull((String)("Consistent cut meta does not contain fuzzy border pointer [cutMeta=" + cutMeta + ']'), (Object)cutMeta.fuzzyBorderStartPtr());
        GridExchangelessPointInTimeRecoveryLocalTest.assertNotNull((String)("Consistent cut meta does not contain cut pointer [cutMeta=" + cutMeta + ']'), (Object)cutMeta.cutPtr());
        GridExchangelessPointInTimeRecoveryLocalTest.assertTrue((String)("Inconsistent cut pointers [fuzzyBorderPtr=" + cutMeta.fuzzyBorderStartPtr() + ", cutPtr=" + cutMeta.cutPtr() + ']'), (((FileWALPointer)cutMeta.cutPtr()).compareTo((FileWALPointer)cutMeta.fuzzyBorderStartPtr()) > 0 ? 1 : 0) != 0);
        GridExchangelessPointInTimeRecoveryLocalTest.assertTrue((String)("Inconsistent cut pointer timestamp [cutPtr=" + cutMeta.cutPtr() + ", timestamp=" + cutMeta.cutPtrTime() + ']'), (cutMeta.cutPtrTime() > 0L && cutMeta.cutPtrTime() >= cutMeta.consistentCutId() ? 1 : 0) != 0);
    }

    @Test
    public void testRestoreFromExchangelessSnapshotToCutTime() throws Exception {
        int nodes = 1;
        this.startGrids(nodes);
        IgniteEx igClient = this.startClient(nodes);
        igClient.cluster().state(ClusterState.ACTIVE);
        this.awaitPartitionMapExchange();
        long initPointInTime = U.currentTimeMillis();
        GridGain gg = (GridGain)igClient.plugin("GridGain");
        GridSnapshotEx snp = (GridSnapshotEx)gg.snapshot();
        SnapshotFuture snpFut = snp.createFullSnapshot(null, "Full snapshot.");
        snpFut.get();
        GridGainImpl gg0 = (GridGainImpl)this.grid(0).plugin("GridGain");
        GridCacheSnapshotManager snapMgr = (GridCacheSnapshotManager)gg0.provider().databaseManager();
        ArrayList<SnapshotMetadataV2> snaps = new ArrayList<SnapshotMetadataV2>();
        for (SnapshotMetadataV2 meta : snapMgr.snapshotSpi().localSnapshots(true)) {
            snaps.add(meta);
        }
        GridExchangelessPointInTimeRecoveryLocalTest.assertEquals((String)"Unexpected number of snapshots.", (int)2, (int)snaps.size());
        SnapshotFuture restoreFut = snp.recoveryTo(new RecoveryParams(initPointInTime));
        SnapshotOperationInfo restoreOp = restoreFut.snapshotOperation();
        GridExchangelessPointInTimeRecoveryLocalTest.assertEquals((String)"Unexpected snapshot id.", (long)((SnapshotMetadataV2)snaps.get(0)).id(), (long)restoreOp.snapshotId());
        restoreFut.get();
        ConsistentCutMeta cutMeta = (ConsistentCutMeta)((SnapshotMetadataV2)snaps.get(1)).consistentCutMetas().values().iterator().next();
        initPointInTime = cutMeta.cutPtrTime() - 1L;
        restoreFut = snp.recoveryTo(new RecoveryParams(initPointInTime));
        restoreOp = restoreFut.snapshotOperation();
        GridExchangelessPointInTimeRecoveryLocalTest.assertEquals((String)"Unexpected snapshot id.", (long)((SnapshotMetadataV2)snaps.get(0)).id(), (long)restoreOp.snapshotId());
        restoreFut.get();
        initPointInTime = U.currentTimeMillis();
        restoreFut = snp.recoveryTo(new RecoveryParams(initPointInTime));
        restoreOp = restoreFut.snapshotOperation();
        GridExchangelessPointInTimeRecoveryLocalTest.assertEquals((String)"Unexpected snapshot id.", (long)((SnapshotMetadataV2)snaps.get(1)).id(), (long)restoreOp.snapshotId());
        restoreFut.get();
    }
}

