/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.processors.cache.database.AbstractSnapshotTest;
import org.gridgain.grid.internal.processors.cache.database.GridSnapshotEx;
import org.gridgain.grid.persistentstore.SnapshotSecurityLevel;
import org.junit.Assert;
import org.junit.Test;

public class SnapshotSecurityLevelFeaturePropertyTest
extends AbstractSnapshotTest {
    protected void beforeTestsStarted() throws Exception {
        this.stopAllGrids();
        this.cleanSnapshotDirs();
    }

    @Override
    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanSnapshotDirs();
    }

    @Test
    @WithSystemProperty(key="IGNITE_DISTRIBUTED_META_STORAGE_FEATURE", value="true")
    public void test1() throws Exception {
        System.setProperty("GG_SNAPSHOT_SECURITY_LEVEL", SnapshotSecurityLevel.REQUIRE.name());
        System.setProperty("GG_SNAPSHOT_SECURITY_FEATURE", "true");
        try {
            IgniteEx ig = this.startGrids(4);
            ig.cluster().active(true);
            this.stopGrid(3);
        }
        finally {
            System.clearProperty("GG_SNAPSHOT_SECURITY_LEVEL");
            System.clearProperty("GG_SNAPSHOT_SECURITY_FEATURE");
        }
        IgniteEx ig3 = this.startGrid(3);
        SnapshotSecurityLevel level = this.getSnapshot(ig3).getSecurityLevel();
        Assert.assertEquals((Object)SnapshotSecurityLevel.DISABLED, (Object)level);
    }

    @Test
    @WithSystemProperty(key="IGNITE_DISTRIBUTED_META_STORAGE_FEATURE", value="true")
    public void test2() throws Exception {
        IgniteEx ig = this.startGrids(4);
        ig.cluster().active(true);
        try {
            this.changeSecurityLevel(ig, SnapshotSecurityLevel.REQUIRE);
            SnapshotSecurityLevelFeaturePropertyTest.fail();
        }
        catch (IgniteCheckedException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Can't change security level to "));
        }
    }

    protected void changeSecurityLevel(IgniteEx ignite, SnapshotSecurityLevel level) throws IgniteCheckedException {
        this.getSnapshot(ignite).updateSecurityLevel(level);
    }

    protected GridSnapshotEx getSnapshot(IgniteEx igniteEx) {
        GridGain gg = (GridGain)igniteEx.plugin("GridGain");
        GridSnapshotEx snapshot = (GridSnapshotEx)gg.snapshot();
        assert (snapshot != null);
        return snapshot;
    }
}

