/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import javax.cache.configuration.CompleteConfiguration;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.BinaryConfiguration;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotInfo;
import org.gridgain.grid.persistentstore.SnapshotInfoEx;
import org.jetbrains.annotations.NotNull;
import org.junit.Test;

public class SnapshotInfoAfterManySnapshotsMoved
extends GridCommonAbstractTest {
    private static final TcpDiscoveryIpFinder ipFinder = new TcpDiscoveryVmIpFinder(true);
    private static final int ENTRIES_COUNT = 300;
    private static final int CACHES_COUNT = 10;
    private static final int SNAPSHOTS_COUNT = 10;
    private static final String CACHE_NAME_BASE = "cache";
    private File moveDir;

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        TcpDiscoverySpi discoverySpi = (TcpDiscoverySpi)cfg.getDiscoverySpi();
        discoverySpi.setIpFinder(ipFinder);
        BinaryConfiguration bCfg = new BinaryConfiguration();
        bCfg.setCompactFooter(false);
        cfg.setBinaryConfiguration(bCfg);
        GridGainConfiguration ggCfg = new GridGainConfiguration();
        ggCfg.setSnapshotConfiguration(new SnapshotConfiguration());
        cfg.setPluginConfigurations(new PluginConfiguration[]{ggCfg});
        DataStorageConfiguration memCfg = new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setMaxSize(0xC800000L).setPersistenceEnabled(true)).setWalMode(WALMode.LOG_ONLY);
        cfg.setDataStorageConfiguration(memCfg);
        cfg.setConsistentId((Serializable)((Object)gridName));
        return cfg;
    }

    @Test
    public void testMoveSnapshotAndRestore() throws Exception {
        this.startGrids(3);
        IgniteEx ignite = this.grid(0);
        ignite.active(true);
        this.awaitPartitionMapExchange();
        CacheConfiguration ccfg = new CacheConfiguration().setAtomicityMode(CacheAtomicityMode.ATOMIC).setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32));
        ArrayList<CacheConfiguration> configurations = new ArrayList<CacheConfiguration>();
        for (int i = 0; i < 10; ++i) {
            configurations.add(new CacheConfiguration((CompleteConfiguration)ccfg).setName(CACHE_NAME_BASE + i));
        }
        ignite.createCaches(configurations);
        ThreadLocalRandom r = ThreadLocalRandom.current();
        for (int i = 0; i < 300; ++i) {
            ignite.cache(CACHE_NAME_BASE + r.nextInt(0, 10)).put((Object)i, (Object)i);
        }
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        HashMap<Long, String> snapshotIdToCacheName = new HashMap<Long, String>();
        for (int i = 0; i < 10; ++i) {
            String cacheName = CACHE_NAME_BASE + r.nextInt(0, 10);
            SnapshotFuture fut = gg.snapshot().createFullSnapshot(Collections.singleton(cacheName), null);
            fut.get();
            snapshotIdToCacheName.put(fut.snapshotOperation().snapshotId(), cacheName);
        }
        List snapshots = gg.snapshot().list();
        SnapshotInfoAfterManySnapshotsMoved.assertEquals((int)10, (int)snapshots.size());
        for (int i = 0; i < 10; ++i) {
            gg.snapshot().forceMoveSnapshot(((SnapshotInfo)snapshots.get(i)).snapshotId(), this.moveDir, null).get();
        }
        List movedSnapshots = gg.snapshot().listSnapshots(Collections.singleton(this.moveDir));
        SnapshotInfoAfterManySnapshotsMoved.assertEquals((int)10, (int)movedSnapshots.size());
        for (int i = 0; i < 5; ++i) {
            long snapshotId = ((SnapshotInfo)movedSnapshots.get(r.nextInt(0, 10))).snapshotId();
            SnapshotInfoEx snapshot = gg.snapshot().snapshot(snapshotId, Collections.singleton(this.moveDir));
            SnapshotInfoAfterManySnapshotsMoved.assertEquals((long)snapshot.snapshotId(), (long)snapshotId);
            SnapshotInfoAfterManySnapshotsMoved.assertEquals((String)((String)snapshotIdToCacheName.get(snapshotId)), (String)((String)snapshot.cacheNames().iterator().next()));
        }
    }

    protected void beforeTest() throws Exception {
        this.stopAllGrids();
        this.deleteWorkFiles();
        this.moveDir = this.createOrCleanMoveDir();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.deleteWorkFiles();
        U.delete((File)this.moveDir);
    }

    @NotNull
    private File createOrCleanMoveDir() throws IgniteCheckedException {
        File moveDir = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"move_test", (boolean)false);
        U.delete((File)moveDir);
        moveDir.mkdirs();
        return moveDir;
    }

    private void deleteWorkFiles() throws Exception {
        this.cleanPersistenceDir();
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"snapshot", (boolean)false));
    }
}

