/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.cache.expiry.AccessedExpiryPolicy;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheTtlManager;
import org.apache.ignite.internal.util.lang.GridAbsPredicate;
import org.apache.ignite.internal.util.lang.GridAbsPredicateX;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.junit.Test;

public class IgniteSnapshotReplicatedExpiredCacheTest
extends GridCommonAbstractTest {
    private static final String SMALL_EXPIRED_TEST = "smallExpiredTest";
    private static final String LARGE_EXPIRED_TEST = "largeExpiredTest";
    private static final String OPERATION_EXPIRED_TEST = "operationExpiredTest";
    private static final int ENTITIES_COUNT = 100;
    private static final int LARGE_EXPIRED_SECONDS = 100;
    private static final int SMALL_EXPIRED_SECONDS = 1;

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        cfg.setConsistentId((Serializable)((Object)(gridName + UUID.randomUUID())));
        cfg.setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setMaxSize(0x10000000L).setPersistenceEnabled(true)));
        GridGainConfiguration ggCfg = new GridGainConfiguration();
        ggCfg.setSnapshotConfiguration(new SnapshotConfiguration());
        cfg.setPluginConfigurations(new PluginConfiguration[]{ggCfg});
        return cfg;
    }

    protected void beforeTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
        this.clearSnapshotNodeDir(Collections.singleton("snapshot"));
    }

    @Test
    public void shouldRestoreCorrectlyWhenTtlWorkerHasntTriggeredOnOneNodeYet() throws Exception {
        IgniteEx ignite0 = this.startGrid(0);
        IgniteEx ignite1 = this.startGrid(1);
        IgniteEx ignite2 = this.startGrid(2);
        ignite0.cluster().active(true);
        IgniteCache fastExpired1Crd = ignite0.getOrCreateCache(this.expiredCacheConfig(SMALL_EXPIRED_TEST, 1));
        IgniteCache longExpired1Crd = ignite0.getOrCreateCache(this.expiredCacheConfig(LARGE_EXPIRED_TEST, 100));
        IgniteCache operationExpired1Crd = ignite0.getOrCreateCache(this.cacheConfig(OPERATION_EXPIRED_TEST));
        IgniteCache operationSmallExpired1Crd = operationExpired1Crd.withExpiryPolicy((ExpiryPolicy)AccessedExpiryPolicy.factoryOf((Duration)new Duration(TimeUnit.SECONDS, 1L)).create());
        IgniteCache operationLargeExpired1Crd = operationExpired1Crd.withExpiryPolicy((ExpiryPolicy)AccessedExpiryPolicy.factoryOf((Duration)new Duration(TimeUnit.SECONDS, 100L)).create());
        GridCacheTtlManager crdTtlMgr = this.ttlManager(ignite0, SMALL_EXPIRED_TEST);
        this.unregisterTtlWorkerFor(ignite0, crdTtlMgr);
        this.unregisterTtlWorkerFor(ignite0, this.ttlManager(ignite0, OPERATION_EXPIRED_TEST));
        for (int i = 0; i < 100; ++i) {
            fastExpired1Crd.put((Object)i, (Object)i);
            longExpired1Crd.put((Object)i, (Object)i);
            if (i < 50) {
                operationSmallExpired1Crd.put((Object)i, (Object)i);
                continue;
            }
            operationLargeExpired1Crd.put((Object)i, (Object)i);
        }
        final GridCacheTtlManager node1TtlMgr = this.ttlManager(ignite1, SMALL_EXPIRED_TEST);
        GridTestUtils.waitForCondition((GridAbsPredicate)new GridAbsPredicateX(){

            public boolean applyx() throws IgniteCheckedException {
                return node1TtlMgr.pendingSize() == 0L;
            }
        }, (long)10000L);
        IgniteSnapshotReplicatedExpiredCacheTest.assertTrue((boolean)crdTtlMgr.hasPendingEntries(false));
        GridGain gg = (GridGain)ignite0.plugin("GridGain");
        SnapshotFuture fullSnapshot = gg.snapshot().createFullSnapshot(null, null);
        long snapshotId = fullSnapshot.snapshotOperation().snapshotId();
        fullSnapshot.get();
        this.stopAllGrids();
        this.cleanPersistenceDir();
        ignite0 = this.startGrid(0);
        ignite1 = this.startGrid(1);
        ignite2 = this.startGrid(2);
        ignite0.cluster().active(true);
        gg = (GridGain)ignite0.plugin("GridGain");
        gg.snapshot().restoreSnapshot(snapshotId, null, null).get();
        this.awaitPartitionMapExchange();
        this.assertExpiredCachesLocally((IgniteCache<Integer, Integer>)ignite0.cache(SMALL_EXPIRED_TEST), (IgniteCache<Integer, Integer>)ignite0.cache(LARGE_EXPIRED_TEST), (IgniteCache<Integer, Integer>)ignite0.cache(OPERATION_EXPIRED_TEST));
        this.assertExpiredCachesLocally((IgniteCache<Integer, Integer>)ignite1.cache(SMALL_EXPIRED_TEST), (IgniteCache<Integer, Integer>)ignite1.cache(LARGE_EXPIRED_TEST), (IgniteCache<Integer, Integer>)ignite1.cache(OPERATION_EXPIRED_TEST));
        this.assertExpiredCachesLocally((IgniteCache<Integer, Integer>)ignite2.cache(SMALL_EXPIRED_TEST), (IgniteCache<Integer, Integer>)ignite2.cache(LARGE_EXPIRED_TEST), (IgniteCache<Integer, Integer>)ignite2.cache(OPERATION_EXPIRED_TEST));
    }

    @Test
    public void shouldRestoreIncrementalSnapCorrectlyWhenTtlWorkerHasntTriggeredOnOneNodeYet() throws Exception {
        IgniteEx ignite0 = this.startGrid(0);
        IgniteEx ignite1 = this.startGrid(1);
        IgniteEx ignite2 = this.startGrid(2);
        ignite0.cluster().active(true);
        IgniteCache fastExpired1Crd = ignite0.getOrCreateCache(this.expiredCacheConfig(SMALL_EXPIRED_TEST, 1));
        IgniteCache longExpired1Crd = ignite0.getOrCreateCache(this.expiredCacheConfig(LARGE_EXPIRED_TEST, 100));
        IgniteCache operationExpired1Crd = ignite0.getOrCreateCache(this.cacheConfig(OPERATION_EXPIRED_TEST));
        IgniteCache operationSmallExpired1Crd = operationExpired1Crd.withExpiryPolicy((ExpiryPolicy)AccessedExpiryPolicy.factoryOf((Duration)new Duration(TimeUnit.SECONDS, 1L)).create());
        IgniteCache operationLargeExpired1Crd = operationExpired1Crd.withExpiryPolicy((ExpiryPolicy)AccessedExpiryPolicy.factoryOf((Duration)new Duration(TimeUnit.SECONDS, 100L)).create());
        GridCacheTtlManager crdTtlManager = this.ttlManager(ignite0, SMALL_EXPIRED_TEST);
        this.unregisterTtlWorkerFor(ignite0, crdTtlManager);
        this.unregisterTtlWorkerFor(ignite0, this.ttlManager(ignite0, OPERATION_EXPIRED_TEST));
        GridGain gg = (GridGain)ignite0.plugin("GridGain");
        gg.snapshot().createFullSnapshot(null, null).get();
        for (int i = 0; i < 100; ++i) {
            fastExpired1Crd.put((Object)i, (Object)i);
            longExpired1Crd.put((Object)i, (Object)i);
            if (i < 50) {
                operationSmallExpired1Crd.put((Object)i, (Object)i);
                continue;
            }
            operationLargeExpired1Crd.put((Object)i, (Object)i);
        }
        final GridCacheTtlManager node1TtlMgr = this.ttlManager(ignite1, SMALL_EXPIRED_TEST);
        GridTestUtils.waitForCondition((GridAbsPredicate)new GridAbsPredicateX(){

            public boolean applyx() throws IgniteCheckedException {
                return node1TtlMgr.pendingSize() == 0L;
            }
        }, (long)10000L);
        IgniteSnapshotReplicatedExpiredCacheTest.assertTrue((boolean)crdTtlManager.hasPendingEntries(false));
        SnapshotFuture snapshot = gg.snapshot().createSnapshot(null, null);
        long snapshotId = snapshot.snapshotOperation().snapshotId();
        snapshot.get();
        this.stopAllGrids();
        this.cleanPersistenceDir();
        ignite0 = this.startGrid(0);
        ignite1 = this.startGrid(1);
        ignite2 = this.startGrid(2);
        ignite0.cluster().active(true);
        gg = (GridGain)ignite0.plugin("GridGain");
        gg.snapshot().restoreSnapshot(snapshotId, null, null).get();
        this.awaitPartitionMapExchange();
        this.assertExpiredCachesLocally((IgniteCache<Integer, Integer>)ignite0.cache(SMALL_EXPIRED_TEST), (IgniteCache<Integer, Integer>)ignite0.cache(LARGE_EXPIRED_TEST), (IgniteCache<Integer, Integer>)ignite0.cache(OPERATION_EXPIRED_TEST));
        this.assertExpiredCachesLocally((IgniteCache<Integer, Integer>)ignite1.cache(SMALL_EXPIRED_TEST), (IgniteCache<Integer, Integer>)ignite1.cache(LARGE_EXPIRED_TEST), (IgniteCache<Integer, Integer>)ignite1.cache(OPERATION_EXPIRED_TEST));
        this.assertExpiredCachesLocally((IgniteCache<Integer, Integer>)ignite2.cache(SMALL_EXPIRED_TEST), (IgniteCache<Integer, Integer>)ignite2.cache(LARGE_EXPIRED_TEST), (IgniteCache<Integer, Integer>)ignite2.cache(OPERATION_EXPIRED_TEST));
    }

    private void clearSnapshotNodeDir(Set<String> strings) throws IgniteCheckedException {
        for (String snapDir : strings) {
            U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)snapDir, (boolean)false));
        }
    }

    private void assertExpiredCachesLocally(IgniteCache<Integer, Integer> smallExpired, IgniteCache<Integer, Integer> largeExpired, IgniteCache<Integer, Integer> operatorExpired) {
        for (int i = 0; i < 100; ++i) {
            IgniteSnapshotReplicatedExpiredCacheTest.assertNull((Object)smallExpired.localPeek((Object)i, new CachePeekMode[0]));
            IgniteSnapshotReplicatedExpiredCacheTest.assertEquals((Object)i, (Object)largeExpired.localPeek((Object)i, new CachePeekMode[0]));
            if (i < 50) {
                IgniteSnapshotReplicatedExpiredCacheTest.assertNull((Object)operatorExpired.localPeek((Object)i, new CachePeekMode[0]));
                continue;
            }
            IgniteSnapshotReplicatedExpiredCacheTest.assertEquals((Object)i, (Object)operatorExpired.localPeek((Object)i, new CachePeekMode[0]));
        }
    }

    private GridCacheTtlManager ttlManager(IgniteEx ignite, String cacheName) {
        return ((GridCacheContext)ignite.context().cache().cacheGroup(CU.cacheId((String)cacheName)).caches().get(0)).ttl();
    }

    private void unregisterTtlWorkerFor(IgniteEx ignite, GridCacheTtlManager ttlManager) {
        ignite.context().cache().context().ttl().unregister(ttlManager);
    }

    protected CacheConfiguration<Integer, Integer> expiredCacheConfig(String cacheName, int expiredSeconds) {
        CacheConfiguration<Integer, Integer> ccfg = this.cacheConfig(cacheName);
        ccfg.setExpiryPolicyFactory(AccessedExpiryPolicy.factoryOf((Duration)new Duration(TimeUnit.SECONDS, (long)expiredSeconds)));
        return ccfg;
    }

    protected CacheConfiguration<Integer, Integer> cacheConfig(String cacheName) {
        CacheConfiguration ccfg = new CacheConfiguration();
        ccfg.setName(cacheName);
        ccfg.setCacheMode(CacheMode.REPLICATED);
        ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 4));
        return ccfg;
    }
}

