/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.BinaryConfiguration;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.persistentstore.GridSnapshot;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotProgress;
import org.gridgain.grid.persistentstore.SnapshotStatus;
import org.gridgain.grid.persistentstore.SnapshotUpdateOperationParams;
import org.jetbrains.annotations.NotNull;
import org.junit.Test;

public class IgniteSnapshotOperationProgressTest
extends GridCommonAbstractTest {
    private static final TcpDiscoveryIpFinder ipFinder = new TcpDiscoveryVmIpFinder(true);
    public static final int ENTRIES_COUNT = 100000;
    public static final String CACHE_NAME = "cache1";
    public static final String CACHE_2_NAME = "cache2";
    public static final String CACHE_2_GROUP_NAME = "Group2";

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        TcpDiscoverySpi discoverySpi = (TcpDiscoverySpi)cfg.getDiscoverySpi();
        discoverySpi.setIpFinder(ipFinder);
        DataStorageConfiguration memCfg = new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setMaxSize(0xC800000L).setPersistenceEnabled(true)).setWalMode(WALMode.LOG_ONLY);
        cfg.setDataStorageConfiguration(memCfg);
        BinaryConfiguration bCfg = new BinaryConfiguration();
        bCfg.setCompactFooter(false);
        cfg.setBinaryConfiguration(bCfg);
        CacheConfiguration ccfg1 = new CacheConfiguration();
        ccfg1.setName(CACHE_NAME);
        ccfg1.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        ccfg1.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg1.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32));
        ccfg1.setIndexedTypes(new Class[]{Integer.class, Integer.class});
        CacheConfiguration ccfg2 = new CacheConfiguration();
        ccfg2.setName(CACHE_2_NAME);
        ccfg2.setGroupName(CACHE_2_GROUP_NAME);
        ccfg2.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        ccfg2.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg2.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32));
        ccfg2.setIndexedTypes(new Class[]{Integer.class, TestValue.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg1, ccfg2});
        GridGainConfiguration ggCfg = new GridGainConfiguration();
        SnapshotConfiguration ggDbCfg = new SnapshotConfiguration();
        ggDbCfg.setSnapshotProgressThrottlingInterval(-1L);
        ggCfg.setSnapshotConfiguration(ggDbCfg);
        cfg.setPluginConfigurations(new PluginConfiguration[]{ggCfg});
        cfg.setConsistentId((Serializable)((Object)gridName));
        return cfg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSnapshotCheckRestoreAndMoveProgress() throws Exception {
        Ignite ignite = this.startGridsMultiThreaded(1);
        this.load(ignite);
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        GridSnapshot sn = gg.snapshot();
        SnapshotFuture snapshot = sn.createFullSnapshot(null, null);
        this.checkProgress(snapshot, sn, 0.0, 1.0, 2);
        SnapshotFuture check = sn.checkSnapshot(snapshot.snapshotOperation().snapshotId(), null, false, null);
        this.checkProgress(check, sn, 0.0, 1.0, 1);
        SnapshotFuture restore = sn.restoreSnapshot(snapshot.snapshotOperation().snapshotId(), null, null);
        this.checkProgress(restore, sn, 0.0, 1.0, 3);
        File dir = this.createOrCleanMoveDir();
        try {
            SnapshotFuture move = sn.moveSnapshot(snapshot.snapshotOperation().snapshotId(), dir, null);
            this.checkProgress(move, sn, 0.0, 1.0, 2);
        }
        finally {
            U.delete((File)dir);
        }
    }

    @Test
    public void testDeleteProgress() throws Exception {
        Ignite ignite = this.startGridsMultiThreaded(2);
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        for (int j = 0; j < 4; ++j) {
            IgniteCache cache = ignite.getOrCreateCache("cache-" + j);
            for (int i = 0; i < 1024; ++i) {
                cache.put((Object)i, (Object)i);
            }
        }
        SnapshotFuture snapshot = gg.snapshot().createFullSnapshot(null, null);
        snapshot.get();
        SnapshotFuture delete = gg.snapshot().deleteSnapshot(snapshot.snapshotOperation().snapshotId(), (SnapshotUpdateOperationParams)null, null);
        this.checkProgress(delete, gg.snapshot(), 0.0, 1.0, 1);
    }

    private void checkProgress(SnapshotFuture fut, GridSnapshot sn, double from, double to, int expectedCompletedPhases) throws InterruptedException {
        fut.initFuture().get();
        ArrayList<Map> progresses = new ArrayList<Map>();
        while (true) {
            SnapshotStatus status;
            if ((status = sn.ongoingSnapshotOperation()) == null) break;
            Map progress = status.progress();
            IgniteSnapshotOperationProgressTest.assertNotNull((Object)progress);
            progresses.add(progress);
            Thread.sleep(1L);
        }
        fut.get();
        HashMap previousProgress = new HashMap();
        for (Map progress : progresses) {
            for (Map.Entry entry : progress.entrySet()) {
                double curProgress = ((SnapshotProgress)entry.getValue()).getProgress();
                IgniteSnapshotOperationProgressTest.assertTrue((curProgress <= 1.0 && curProgress >= 0.0 ? 1 : 0) != 0);
            }
            for (Map.Entry entry : progress.entrySet()) {
                UUID nodeId = (UUID)entry.getKey();
                SnapshotProgress curNodeProgress = (SnapshotProgress)entry.getValue();
                ArrayList<SnapshotProgress> prgrss = (ArrayList<SnapshotProgress>)previousProgress.get(nodeId);
                if (prgrss == null) {
                    prgrss = new ArrayList<SnapshotProgress>();
                    previousProgress.put(nodeId, prgrss);
                    prgrss.add(curNodeProgress);
                    continue;
                }
                SnapshotProgress last = (SnapshotProgress)prgrss.get(prgrss.size() - 1);
                if (last.compareTo(curNodeProgress) > 0) {
                    IgniteSnapshotOperationProgressTest.fail((String)("nodeId=" + nodeId + ", last = " + last + ", current = " + curNodeProgress));
                    continue;
                }
                if (last.compareTo(curNodeProgress) >= 0) continue;
                prgrss.add(curNodeProgress);
            }
        }
        double step = (to - from) / 5.0;
        SnapshotProgress toProgress = new SnapshotProgress(new Double(to * 1000.0).longValue(), new Double(1000.0).longValue(), to, 0L);
        SnapshotProgress fromProgress = new SnapshotProgress(new Double(from * 1000.0).longValue(), new Double(1000.0).longValue(), from, 0L);
        for (List progress : previousProgress.values()) {
            int compeletedPhases = 0;
            double curr = from + step;
            SnapshotProgress currProgress = new SnapshotProgress(new Double(curr * 1000.0).longValue(), new Double(1000.0).longValue(), to, 0L);
            IgniteSnapshotOperationProgressTest.assertTrue((progress.size() > 5 ? 1 : 0) != 0);
            IgniteSnapshotOperationProgressTest.assertTrue((((SnapshotProgress)progress.get(progress.size() - 1)).compareTo(toProgress) <= 0 ? 1 : 0) != 0);
            IgniteSnapshotOperationProgressTest.assertTrue((String)("first = " + progress.get(0) + ", from = " + from + ", to =" + to), (((SnapshotProgress)progress.get(0)).compareTo(fromProgress) >= 0 && ((SnapshotProgress)progress.get(0)).compareTo(currProgress) <= 0 ? 1 : 0) != 0);
            for (SnapshotProgress p : progress) {
                if (p.getProcessed() == p.getTotal()) {
                    ++compeletedPhases;
                }
                if (p.compareTo(currProgress) <= 0) continue;
                currProgress = new SnapshotProgress(new Double((curr += step) * 1000.0).longValue(), new Double(1000.0).longValue(), to, 0L);
                IgniteSnapshotOperationProgressTest.assertTrue((String)("p = " + p + ", curr =" + curr), (p.compareTo(currProgress) <= 0 ? 1 : 0) != 0);
            }
            IgniteSnapshotOperationProgressTest.assertTrue((String)S.toString((String)"Unexpected completed phase message", (String)"compeletedPhases", (Object)compeletedPhases, (String)"expectedCompletedPhases", (Object)expectedCompletedPhases), (compeletedPhases <= expectedCompletedPhases ? 1 : 0) != 0);
        }
    }

    @NotNull
    private File createOrCleanMoveDir() throws IgniteCheckedException {
        File moveDir = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"move_test", (boolean)false);
        U.delete((File)moveDir);
        moveDir.mkdirs();
        return moveDir;
    }

    protected boolean checkTopology() {
        return false;
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stopAllGrids();
        this.deleteWorkFiles();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.deleteWorkFiles();
    }

    private void load(final Ignite ig) throws IgniteCheckedException {
        IgniteInternalFuture f1 = GridTestUtils.runAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                try (IgniteDataStreamer ldr = ig.dataStreamer(IgniteSnapshotOperationProgressTest.CACHE_NAME);){
                    HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
                    for (int i = 0; i < 100000; ++i) {
                        map.put(i, i);
                    }
                    ldr.addData(map);
                }
            }
        });
        IgniteInternalFuture f2 = GridTestUtils.runAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                try (IgniteDataStreamer ldr = ig.dataStreamer(IgniteSnapshotOperationProgressTest.CACHE_2_NAME);){
                    HashMap<Integer, TestValue> map = new HashMap<Integer, TestValue>();
                    for (int i = 0; i < 100000; ++i) {
                        map.put(i, new TestValue(i, i));
                    }
                    ldr.addData(map);
                }
            }
        });
        f1.get();
        f2.get();
    }

    private Set<String> snapshotDir() {
        return Collections.singleton("snapshot");
    }

    private void deleteWorkFiles() throws Exception {
        this.cleanPersistenceDir();
        for (String snapDir : this.snapshotDir()) {
            U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)snapDir, (boolean)false));
        }
    }

    private static class TestValue
    implements Serializable {
        @QuerySqlField(index=true, descending=true)
        private final int v1;
        @QuerySqlField(index=true)
        private final int v2;

        private TestValue(int v1, int v2) {
            this.v1 = v1;
            this.v2 = v2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestValue value = (TestValue)o;
            return this.v1 == value.v1 && this.v2 == value.v2;
        }

        public int hashCode() {
            int result = this.v1;
            result = 31 * result + this.v2;
            return result;
        }

        public String toString() {
            return S.toString(TestValue.class, (Object)this);
        }
    }
}

