/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.util.Collections;
import java.util.Random;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.PartitionLossPolicy;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.testframework.GridTestUtils;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.processors.cache.database.AbstractSnapshotTest;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.junit.Test;

public class IgniteDbSnapshotWithPartitionLossTest
extends AbstractSnapshotTest {
    public static final String CACHE_WITH_LOST_PARTITION = "cacheWithLostPartition";

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        IgniteEx ign = this.startGrids(3);
        ign.cluster().baselineAutoAdjustEnabled(false);
        ign.cluster().state(ClusterState.ACTIVE);
        IgniteCache cache = ign.createCache(new CacheConfiguration(CACHE_WITH_LOST_PARTITION).setBackups(0).setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setPartitionLossPolicy(PartitionLossPolicy.READ_ONLY_SAFE));
        Random random = new Random(((Object)((Object)this)).getClass().hashCode());
        random.ints(1000L).forEach(i -> cache.put((Object)i, (Object)String.valueOf(i)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSnapshotCreationShouldFailWhenThereArePartitionLoss() throws Exception {
        IgniteEx ign;
        try {
            this.stopGrid(2);
            ign = this.grid(0);
            IgniteCache cache = ign.getOrCreateCache(CACHE_WITH_LOST_PARTITION);
            IgniteDbSnapshotWithPartitionLossTest.assertFalse((String)"Expected lost partitions after one node left cluster", (boolean)cache.lostPartitions().isEmpty());
            GridGain gg = (GridGain)ign.plugin("GridGain");
            try {
                SnapshotFuture snapFut = gg.snapshot().createFullSnapshot(Collections.singleton(CACHE_WITH_LOST_PARTITION), null);
                snapFut.get();
                IgniteDbSnapshotWithPartitionLossTest.fail((String)"Expected error during snapshot creation.");
            }
            catch (Exception e) {
                GridTestUtils.assertContains((IgniteLogger)log, (String)e.getMessage(), (String)"The partition loss policy doesn't allow to create snapshot for caches with lost partitions");
            }
        }
        finally {
            ign = this.startGrid(2);
            ign.resetLostPartitions(Collections.singleton(CACHE_WITH_LOST_PARTITION));
        }
    }
}

