/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.gridgain.grid.internal.processors.cache.database.IgniteDbSnapshotSameTopologyTest;
import org.jetbrains.annotations.NotNull;

public class IgniteDbSnapshotSameTopologyTestWithStartedCacheByDdl
extends IgniteDbSnapshotSameTopologyTest {
    public static final String SQL_CACHE_NAME = "123";

    @Override
    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.ensureCachesCreated();
    }

    private void createCacheViaSql(IgniteCache<Object, Object> cache) {
        ((Ignite)cache.unwrap(Ignite.class)).addCacheConfiguration(new CacheConfiguration("sqlcache").setAtomicityMode(CacheAtomicityMode.ATOMIC).setCacheMode(CacheMode.REPLICATED).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 8)));
        cache.query(new SqlFieldsQuery("CREATE TABLE PUBLIC.city (id LONG PRIMARY KEY, name VARCHAR) WITH \"template=sqlcache,CACHE_NAME=123\"")).getAll();
    }

    @Override
    protected void beforeTest() throws Exception {
        super.beforeTest();
        IgniteDbSnapshotSameTopologyTestWithStartedCacheByDdl.assertNotNull((Object)ignite.cache(SQL_CACHE_NAME));
        IgniteDbSnapshotSameTopologyTestWithStartedCacheByDdl.loadWithIntsAsync((Ignite)ignite, SQL_CACHE_NAME, 0, 1).get();
    }

    @Override
    @NotNull
    protected String getOrCreateDefaultCacheName(Ignite ig) {
        this.ensureCachesCreated();
        return SQL_CACHE_NAME;
    }

    @Override
    protected int getExpectedCacheCountDuringTest() {
        return super.getExpectedCacheCountDuringTest() + 1;
    }

    @Override
    @NotNull
    protected List<String> getAllCacheNames() {
        ArrayList<String> res = new ArrayList<String>(super.getAllCacheNames());
        res.add(SQL_CACHE_NAME);
        return res;
    }

    @Override
    protected void ensureCachesCreated() {
        super.ensureCachesCreated();
        if (ignite.cache(SQL_CACHE_NAME) == null) {
            this.createCacheViaSql((IgniteCache<Object, Object>)ignite.cache("cache1"));
        }
    }

    @Override
    public void testSimpleSnapshotCreation() throws Exception {
        IgniteDbSnapshotSameTopologyTestWithStartedCacheByDdl.assertTrue((boolean)ignite.context().cache().cacheDescriptor(SQL_CACHE_NAME).sql());
        super.testSimpleSnapshotCreation();
        IgniteDbSnapshotSameTopologyTestWithStartedCacheByDdl.assertTrue((boolean)ignite.context().cache().cacheDescriptor(SQL_CACHE_NAME).sql());
    }
}

