/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.File;
import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.Ignite;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.TestRecordingCommunicationSpi;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.processors.cache.database.AbstractSnapshotTest;
import org.gridgain.grid.internal.processors.cache.database.SnapshotOperationStage;
import org.gridgain.grid.internal.processors.cache.database.messages.SnapshotOperationStageFinishedMessage;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotStatus;
import org.junit.Test;

public class IgniteDbSnapshotPhysicalTest
extends AbstractSnapshotTest {
    protected static IgniteEx ignite;
    protected static IgniteEx dummyNode;
    protected static IgniteEx ignite2;
    protected static GridGain gg;

    protected void beforeTest() throws Exception {
        this.stopAllGrids();
        this.cleanSnapshotDirs();
        dummyNode = this.startGrid("dummy");
        ignite = this.startGrid(0);
        ignite2 = this.startGrid(1);
        dummyNode.active(true);
        gg = (GridGain)ignite.plugin("GridGain");
        this.load((Ignite)ignite);
        this.startGrid("client");
        IgniteDbSnapshotPhysicalTest.assertTrue((boolean)ignite.cluster().active());
    }

    @Override
    protected void afterTest() throws Exception {
        SnapshotStatus op = gg.snapshot().ongoingSnapshotOperation();
        if (op != null) {
            gg.snapshot().cancelSnapshotOperation(op.operationId(), "afterTest").get();
        }
        this.clearSnapshotNodeDir(this.snapshotFolders());
    }

    @Test
    @WithSystemProperty(key="recording-communication-spi", value="true")
    public void testIndexBinShouldBeCopiedAtTheSecondStage() throws Exception {
        SnapshotFuture snapshot = gg.snapshot().createFullSnapshot(null, null);
        snapshot.get();
        ignite.cache("cache1").destroy();
        CountDownLatch msgLocked = new CountDownLatch(1);
        CountDownLatch restoreFinished = new CountDownLatch(1);
        ((TestRecordingCommunicationSpi)ignite.configuration().getCommunicationSpi()).blockMessages((IgniteBiPredicate & Serializable)(node, msg) -> {
            if (msg instanceof SnapshotOperationStageFinishedMessage && node.id().equals(dummyNode.localNode().id()) && ((SnapshotOperationStageFinishedMessage)msg).stage() == SnapshotOperationStage.SECOND) {
                msgLocked.countDown();
                return true;
            }
            return false;
        });
        GridTestUtils.runAsync(() -> {
            gg.snapshot().restoreSnapshot(snapshot.snapshotOperation().snapshotId(), null, null).get();
            restoreFinished.countDown();
        });
        msgLocked.await();
        boolean indexBinPresented = false;
        for (ClusterNode node2 : ignite.cluster().nodes()) {
            String cachesDir = U.defaultWorkDirectory() + "/db/" + U.maskForFileName((CharSequence)node2.consistentId().toString()) + "/cache-" + "cache1";
            if (!new File(cachesDir + "/index.bin").exists()) continue;
            indexBinPresented = true;
            break;
        }
        IgniteDbSnapshotPhysicalTest.assertTrue((String)"Index.bin should be copied at restore.", (boolean)indexBinPresented);
        ((TestRecordingCommunicationSpi)ignite.configuration().getCommunicationSpi()).stopBlock();
        IgniteDbSnapshotPhysicalTest.assertTrue((boolean)restoreFinished.await(this.getTestTimeout(), TimeUnit.MILLISECONDS));
    }

    protected long getTestTimeout() {
        return 60000L;
    }
}

