/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import org.apache.ignite.IgniteAtomicSequence;
import org.apache.ignite.internal.IgniteEx;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.processors.cache.database.AbstractSnapshotTest;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.junit.Ignore;
import org.junit.Test;

public class IgniteDbSnapshotDataStructuresAfterRestartTest
extends AbstractSnapshotTest {
    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.stopAllGrids();
        this.cleanSnapshotDirs();
    }

    @Override
    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
        this.cleanSnapshotDirs();
    }

    @Test
    public void testRestoreSequencesWithRestart() throws Exception {
        IgniteEx ignite = this.startGrid(0);
        ignite.cluster().active(true);
        long size = ignite.configuration().getAtomicConfiguration().getAtomicSequenceReserveSize();
        String seq1 = "seq1";
        String seq2 = "seq2";
        IgniteAtomicSequence sequence1 = ignite.atomicSequence(seq1, 0L, true);
        IgniteAtomicSequence sequence2 = ignite.atomicSequence(seq2, 1L, true);
        int i = 0;
        while ((long)i < size) {
            sequence1.incrementAndGet();
            sequence2.addAndGet(10L);
            ++i;
        }
        long seq1state = sequence1.get();
        long seq2state = sequence2.get();
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        SnapshotFuture snapshotFuture = gg.snapshot().createFullSnapshot(null, null);
        snapshotFuture.get();
        int i2 = 0;
        while ((long)i2 < 5L * size) {
            sequence1.incrementAndGet();
            sequence2.addAndGet(10L);
            ++i2;
        }
        IgniteDbSnapshotDataStructuresAfterRestartTest.assertTrue((sequence1.get() != seq1state ? 1 : 0) != 0);
        IgniteDbSnapshotDataStructuresAfterRestartTest.assertTrue((sequence2.get() != seq2state ? 1 : 0) != 0);
        this.stopAllGrids();
        ignite = this.startGrid(0);
        ignite.cluster().active(true);
        this.awaitPartitionMapExchange();
        gg = (GridGain)ignite.plugin("GridGain");
        gg.snapshot().restoreSnapshot(snapshotFuture.snapshotOperation().snapshotId(), null, null).get();
        sequence1 = ignite.atomicSequence(seq1, 0L, false);
        sequence2 = ignite.atomicSequence(seq2, 1L, false);
        IgniteDbSnapshotDataStructuresAfterRestartTest.assertTrue((sequence1.get() < seq1state + 5L * size ? 1 : 0) != 0);
        IgniteDbSnapshotDataStructuresAfterRestartTest.assertTrue((sequence2.get() < seq2state + 5L * size * 10L ? 1 : 0) != 0);
    }

    @Test
    public void testRestoreSequencesWithRestartAndCleanupSameConsId() throws Exception {
        this.checkRestoreSequencesWithRestartAndCleanup(true);
    }

    @Test
    @Ignore(value="https://ggsystems.atlassian.net/browse/GG-14611")
    public void testRestoreSequencesWithRestartAndCleanupDifferentConsId() throws Exception {
        this.checkRestoreSequencesWithRestartAndCleanup(false);
    }

    private void checkRestoreSequencesWithRestartAndCleanup(boolean sameConsId) throws Exception {
        IgniteEx ignite = this.startGrid(0);
        ignite.active(true);
        long size = ignite.configuration().getAtomicConfiguration().getAtomicSequenceReserveSize();
        String seq1 = "seq1";
        String seq2 = "seq2";
        IgniteAtomicSequence sequence1 = ignite.atomicSequence(seq1, 0L, true);
        IgniteAtomicSequence sequence2 = ignite.atomicSequence(seq2, 1L, true);
        int i = 0;
        while ((long)i < size) {
            sequence1.incrementAndGet();
            sequence2.addAndGet(10L);
            ++i;
        }
        long seq1state = sequence1.get();
        long seq2state = sequence2.get();
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        SnapshotFuture snapshotFuture = gg.snapshot().createFullSnapshot(null, null);
        snapshotFuture.get();
        int i2 = 0;
        while ((long)i2 < 5L * size) {
            sequence1.incrementAndGet();
            sequence2.addAndGet(10L);
            ++i2;
        }
        IgniteDbSnapshotDataStructuresAfterRestartTest.assertTrue((sequence1.get() != seq1state ? 1 : 0) != 0);
        IgniteDbSnapshotDataStructuresAfterRestartTest.assertTrue((sequence2.get() != seq2state ? 1 : 0) != 0);
        this.stopAllGrids();
        this.cleanPersistenceDir();
        ignite = this.startGrid(sameConsId ? 0 : 1);
        ignite.active(true);
        this.awaitPartitionMapExchange();
        gg = (GridGain)ignite.plugin("GridGain");
        gg.snapshot().restoreSnapshot(snapshotFuture.snapshotOperation().snapshotId(), null, null).get();
        sequence1 = ignite.atomicSequence(seq1, 0L, false);
        sequence2 = ignite.atomicSequence(seq2, 1L, false);
        IgniteDbSnapshotDataStructuresAfterRestartTest.assertTrue((sequence1.get() < seq1state + 5L * size ? 1 : 0) != 0);
        IgniteDbSnapshotDataStructuresAfterRestartTest.assertTrue((sequence2.get() < seq2state + 5L * size * 10L ? 1 : 0) != 0);
    }
}

