/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.persistence.partstate.GroupPartitionId;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiClosure;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.processors.cache.database.AbstractSnapshotTest;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.internal.processors.cache.database.snapshot.DatabaseSnapshotSpi;
import org.gridgain.grid.internal.processors.cache.database.snapshot.FutureTaskQueue;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.Snapshot;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotEncryptionOptions;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetadataV2;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationContext;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOutputStream;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotSession;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.FsSnapshotPath;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath;
import org.gridgain.grid.persistentstore.MessageDigestFactory;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotSecurityLevel;
import org.gridgain.grid.persistentstore.SnapshotStatus;
import org.gridgain.grid.persistentstore.snapshot.file.FileDatabaseSnapshotSpi;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

public class IgniteDbSnapshotConcurrentCheckpointTest
extends GridCommonAbstractTest {
    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        DataStorageConfiguration memCfg = new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setMaxSize(0x6400000L).setPersistenceEnabled(true)).setWalMode(WALMode.LOG_ONLY);
        cfg.setDataStorageConfiguration(memCfg);
        GridGainConfiguration ggCfg = new GridGainConfiguration();
        SnapshotConfiguration ggDbCfg = new SnapshotConfiguration();
        GridCacheSnapshotManager.TEST_SNAPSHOT_SPI.set(new TestSnapshotSpiWrapper((DatabaseSnapshotSpi)new FileDatabaseSnapshotSpi()));
        ggCfg.setSnapshotConfiguration(ggDbCfg);
        cfg.setPluginConfigurations(new PluginConfiguration[]{ggCfg});
        cfg.setConsistentId((Serializable)((Object)gridName));
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
        this.clearSnapshotNodeDir(Collections.singleton("snapshot"));
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
        this.clearSnapshotNodeDir(Collections.singleton("snapshot"));
    }

    protected void clearSnapshotNodeDir(Set<String> strings) throws IgniteCheckedException {
        for (String snapDir : strings) {
            U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)snapDir, (boolean)false));
        }
    }

    @Test
    public void testCaseWhenCheckpointHappensDuringSnapshot() throws Exception {
        SnapshotFuture fut;
        String first = "first";
        this.startGrids(1).active(true);
        this.awaitPartitionMapExchange();
        IgniteEx ignite = this.ignite(0);
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        CacheConfiguration cacheCfg = new CacheConfiguration();
        cacheCfg.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 1));
        cacheCfg.setName(first);
        IgniteCache cache = ignite.getOrCreateCache(cacheCfg);
        int entriesCnt = 10000;
        AbstractSnapshotTest.loadWithIntsAsync((Ignite)ignite, cacheCfg.getName(), 0, 1, entriesCnt).get();
        while (true) {
            Runtime.getRuntime().gc();
            this.forceCheckpoint();
            fut = gg.snapshot().createFullSnapshot(Collections.singleton(first), null);
            fut.initFuture().get();
            AbstractSnapshotTest.loadWithIntsAsync((Ignite)ignite, cacheCfg.getName(), 10, 1).get();
            this.forceCheckpoint();
            SnapshotStatus ongoingSnapshotOperation = gg.snapshot().ongoingSnapshotOperation();
            if (ongoingSnapshotOperation != null && ongoingSnapshotOperation.getStageNum() <= 1) break;
            fut.get();
        }
        fut.get();
        int newEntriesCnt = entriesCnt + 1000;
        AbstractSnapshotTest.loadWithIntsAsync((Ignite)ignite, cacheCfg.getName(), 0, 1, newEntriesCnt).get();
        fut = gg.snapshot().createSnapshot(Collections.singleton(first), null);
        fut.get();
        cache.destroy();
        gg.snapshot().restoreSnapshot(fut.snapshotOperation().snapshotId(), null, null).get();
        cache = this.ignite(0).cache(first);
        for (int i = 0; i < newEntriesCnt; ++i) {
            IgniteDbSnapshotConcurrentCheckpointTest.assertEquals((int)i, (int)((Integer)cache.get((Object)i)));
        }
    }

    private static class TestSnapshotSessionWrapper
    implements SnapshotSession {
        private final SnapshotSession delegate;

        private TestSnapshotSessionWrapper(SnapshotSession delegate) {
            this.delegate = delegate;
        }

        public SnapshotOutputStream getOrOpenForFile(int grpId, int partId) throws IgniteCheckedException {
            U.sleep((long)10L);
            return this.delegate.getOrOpenForFile(grpId, partId);
        }

        public SnapshotEncryptionOptions snapshotEncryptionOptions() {
            return this.delegate.snapshotEncryptionOptions();
        }

        public void writeMetadata(ByteBuffer metadata) throws IgniteCheckedException {
            this.delegate.writeMetadata(metadata);
        }

        public void cancel() {
            this.delegate.cancel();
        }

        public void close() throws IgniteException {
            this.delegate.close();
        }

        public Runnable onPartitionFinished(GroupPartitionId groupPartitionId) throws IgniteCheckedException {
            return this.delegate.onPartitionFinished(groupPartitionId);
        }

        public void writeRegistry(ByteBuffer registry) throws IgniteCheckedException {
            this.delegate.writeRegistry(registry);
        }
    }

    protected static class TestSnapshotSpiWrapper
    implements DatabaseSnapshotSpi {
        @IgniteInstanceResource
        private Ignite ignite;
        @LoggerResource
        private IgniteLogger log;
        private final DatabaseSnapshotSpi delegate;

        protected TestSnapshotSpiWrapper(DatabaseSnapshotSpi delegate) {
            this.delegate = delegate;
        }

        public File snapshotWorkingDirectory() {
            return null;
        }

        public void start() throws IgniteCheckedException {
            if (this.delegate instanceof FileDatabaseSnapshotSpi) {
                try {
                    Field igniteField = FileDatabaseSnapshotSpi.class.getDeclaredField("ignite");
                    igniteField.setAccessible(true);
                    igniteField.set(this.delegate, this.ignite);
                    Field logField = FileDatabaseSnapshotSpi.class.getDeclaredField("log");
                    logField.setAccessible(true);
                    logField.set(this.delegate, this.log);
                }
                catch (Exception e) {
                    throw new IgniteCheckedException((Throwable)e);
                }
            }
            this.delegate.start();
        }

        public void stop() throws IgniteCheckedException {
            this.delegate.stop();
        }

        public SnapshotSession sessionForSnapshotCreation(long id, boolean fullSnapshot, File storePath, CompressionOption compression, int compressionLevel, FutureTaskQueue<GroupPartitionId> futureTaskProcessor, SnapshotOperationContext snapshotOperationContext, @Nullable MessageDigestFactory msgDigestFactory, @Nullable SnapshotEncryptionOptions encryptionOptions) throws IgniteCheckedException {
            return new TestSnapshotSessionWrapper(this.delegate.sessionForSnapshotCreation(id, fullSnapshot, storePath, compression, compressionLevel, futureTaskProcessor, snapshotOperationContext, msgDigestFactory, encryptionOptions));
        }

        public void copySinglePartition(long snapshotId, int grpId, int partId, SnapshotPath path, SnapshotOperationContext context) throws IgniteCheckedException {
            this.delegate.copySinglePartition(snapshotId, grpId, partId, path, context);
        }

        public Iterable<SnapshotMetadataV2> localSnapshots(boolean sort) throws IgniteCheckedException {
            return this.delegate.localSnapshots(sort);
        }

        public Iterable<SnapshotMetadataV2> listRemoteSnapshots(SnapshotPath searchPath) throws IgniteCheckedException {
            return this.delegate.listRemoteSnapshots(searchPath);
        }

        public Snapshot snapshot(long id, Collection<SnapshotPath> optSearchPath, IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c, boolean ignoreMissedClasses, @Nullable SnapshotSecurityLevel securityLevel, boolean needDecryptKeys) {
            return this.delegate.snapshot(id, optSearchPath, c, ignoreMissedClasses, securityLevel, needDecryptKeys);
        }

        public void deleteSnapshot(long id, SnapshotOperationContext context) throws IgniteCheckedException {
            this.delegate.deleteSnapshot(id, context);
        }

        public boolean isCopyRequired(long snapshotId, SnapshotPath pathToMove) throws IgniteCheckedException {
            return this.delegate.isCopyRequired(snapshotId, pathToMove);
        }

        public void startCopy(long snapshotId, SnapshotPath path) throws IgniteCheckedException {
            this.delegate.startCopy(snapshotId, path);
        }

        public void copySnapshotEntirely(long snapshotId, SnapshotPath path, SnapshotOperationContext ctx, ExecutorService taskExecutor) throws IgniteCheckedException {
            this.delegate.copySnapshotEntirely(snapshotId, path, ctx, taskExecutor);
        }

        public void copyMetadata(long snapshotId, SnapshotPath path, SnapshotOperationContext context) throws IgniteCheckedException {
            this.delegate.copyMetadata(snapshotId, path, context);
        }

        public void copyDigestRegistry(long snapshotId, SnapshotPath path, SnapshotOperationContext context) throws IgniteCheckedException {
            this.delegate.copyDigestRegistry(snapshotId, path, context);
        }

        public void copyWalSegments(long snapshotId, Collection<File> segments, SnapshotPath path, SnapshotOperationContext context) throws IgniteCheckedException {
            this.delegate.copyWalSegments(snapshotId, segments, path, context);
        }

        public void finishCopy(long snapshotId, SnapshotPath path) throws IgniteCheckedException {
            this.delegate.finishCopy(snapshotId, path);
        }

        public <T extends SnapshotPath> T findSnapshotDir(T path, long id) {
            return (T)this.delegate.findSnapshotDir(path, id);
        }

        public <T extends SnapshotPath> T generateSnapshotFolderPath(T path, long id) {
            return (T)this.delegate.findSnapshotDir(path, id);
        }

        public FsSnapshotPath findLocalCurNodeSnapshotDir(long id) {
            return this.delegate.findLocalCurNodeSnapshotDir(id);
        }

        public FsSnapshotPath generateCurNodeSnapshotFolderPath(long id) {
            return this.delegate.generateCurNodeSnapshotFolderPath(id);
        }

        public <T extends SnapshotPath> T generateCurNodeSnapshotFolderPathWithLabel(T snapshotBaseFolder, long id, String label) {
            return (T)this.delegate.generateCurNodeSnapshotFolderPathWithLabel(snapshotBaseFolder, id, label);
        }

        public <T extends SnapshotPath> T findCurNodeSnapshotDir(T path, long id) {
            return (T)this.delegate.findCurNodeSnapshotDir(path, id);
        }

        @Nullable
        public SnapshotMetadataV2 nextLocalSnapshot(long id) {
            return this.delegate.nextLocalSnapshot(id);
        }

        public Map<Long, Long> remoteSnapshotWalSizes(@Nullable SnapshotPath searchPath) {
            return this.delegate.remoteSnapshotWalSizes(searchPath);
        }

        public long remoteSnapshotWalSizes(@Nullable SnapshotPath searchPath, long snapshotId) {
            return this.delegate.remoteSnapshotWalSizes(searchPath, snapshotId);
        }
    }
}

