/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.failure.FailureHandler;
import org.apache.ignite.failure.StopNodeFailureHandler;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.TestRecordingCommunicationSpi;
import org.apache.ignite.internal.processors.cache.persistence.partstate.GroupPartitionId;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.internal.processors.cache.database.snapshot.FutureTaskQueue;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotEncryptionOptions;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationContext;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotSession;
import org.gridgain.grid.persistentstore.MessageDigestFactory;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.snapshot.file.FileDatabaseSnapshotSpi;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

public class IgniteDbBaselineTopologySnapshotWithoutExchangeTest
extends GridCommonAbstractTest {
    private static final String ATOMIC_CACHE_NAME = "test-atomic-cache";

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        String cId = "consistentId-" + igniteInstanceName;
        return super.getConfiguration(igniteInstanceName).setConsistentId((Serializable)((Object)cId)).setCommunicationSpi((CommunicationSpi)new TestRecordingCommunicationSpi()).setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration("default").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 16)).setBackups(2), new CacheConfiguration(ATOMIC_CACHE_NAME).setAtomicityMode(CacheAtomicityMode.ATOMIC).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 16)).setBackups(2)}).setPluginConfigurations(new PluginConfiguration[]{new GridGainConfiguration().setSnapshotConfiguration(new SnapshotConfiguration().setSnapshotsPath(this.snapshotsDir().getPath()))}).setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true))).setFailureHandler((FailureHandler)new StopNodeFailureHandler());
    }

    protected void beforeTest() throws Exception {
        this.cleanPersistenceDir();
        U.delete((File)this.snapshotsDir());
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
        U.delete((File)this.snapshotsDir());
    }

    private File snapshotsDir() throws IgniteCheckedException {
        return U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"snapshots", (boolean)false);
    }

    @Test
    public void testStateChangeWhileSnapshotInProgress() throws Exception {
        CountDownLatch startLatch = new CountDownLatch(1);
        CountDownLatch finishLatch = new CountDownLatch(1);
        GridCacheSnapshotManager.TEST_SNAPSHOT_SPI.set(new TestSnapshotSpi(startLatch, finishLatch));
        IgniteEx ignite = this.startGrid(0);
        ignite.cluster().baselineAutoAdjustEnabled(false);
        ignite.cluster().active(true);
        this.startGrid(1);
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        SnapshotFuture snapFut = gg.snapshot().createFullSnapshot(null, "test-exchangeless-snapshot");
        startLatch.await();
        ignite.cluster().setBaselineTopology(ignite.cluster().nodes());
        IgniteDbBaselineTopologySnapshotWithoutExchangeTest.assertEquals((String)"The new baseline was not set.", (int)2, (int)ignite.cluster().currentBaselineTopology().size());
        finishLatch.countDown();
        snapFut.get();
        ignite.cluster().setBaselineTopology(ignite.cluster().nodes());
        IgniteDbBaselineTopologySnapshotWithoutExchangeTest.assertEquals((int)1, (int)gg.snapshot().list().size());
        SnapshotFuture checkFut = gg.snapshot().checkSnapshot(snapFut.snapshotOperation().snapshotId(), Collections.singleton(this.snapshotsDir()), false, null);
        List issues = (List)checkFut.get();
        issues.forEach(i -> log.error(i.toString()));
        IgniteDbBaselineTopologySnapshotWithoutExchangeTest.assertTrue((String)"Snapshot check failed.", (boolean)((List)checkFut.get()).isEmpty());
    }

    private static class TestSnapshotSpi
    extends FileDatabaseSnapshotSpi {
        private final CountDownLatch snapshotStartLatch;
        private final CountDownLatch snapshotFinishLatch;

        public TestSnapshotSpi(CountDownLatch snapshotStartLatch, CountDownLatch snapshotFinishLatch) {
            this.snapshotStartLatch = snapshotStartLatch;
            this.snapshotFinishLatch = snapshotFinishLatch;
        }

        public SnapshotSession sessionForSnapshotCreation(long id, boolean fullSnapshot, File storePath, CompressionOption compression, int compressionLevel, FutureTaskQueue<GroupPartitionId> futTaskQueue, SnapshotOperationContext snapshotOperationCtx, @Nullable MessageDigestFactory msgDigestFactory, @Nullable SnapshotEncryptionOptions encryptionOptions) throws IgniteCheckedException {
            this.snapshotStartLatch.countDown();
            try {
                this.snapshotFinishLatch.await();
            }
            catch (InterruptedException ex) {
                throw new IgniteCheckedException((Throwable)ex);
            }
            return super.sessionForSnapshotCreation(id, fullSnapshot, storePath, compression, compressionLevel, futTaskQueue, snapshotOperationCtx, msgDigestFactory, encryptionOptions);
        }
    }
}

