/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.transactions.TransactionException;

public class HashMapBackedCache<K, V> {
    private HashMap<K, V> hashMap;
    private IgniteCache<K, V> igniteCache;

    public HashMapBackedCache(IgniteCache<K, V> igniteCache) {
        this.igniteCache = igniteCache;
        this.hashMap = new HashMap();
    }

    public void put(K key, V val) throws TransactionException {
        this.igniteCache.put(key, val);
        this.hashMap.put(key, val);
    }

    public V get(K key) throws TransactionException {
        return (V)this.igniteCache.get(key);
    }

    public IgniteCache<K, V> getIgniteCache() {
        return this.igniteCache;
    }

    public HashMap<K, V> getSlice() {
        return this.hashMap;
    }

    public void setSlice(HashMap<K, V> hashMap) {
        this.hashMap = new HashMap<K, V>(hashMap);
    }

    public Map<K, T2<V, V>> check() {
        return this.checkSlice(this.getSlice());
    }

    public Map<K, T2<V, V>> checkSlice(Map<K, V> slice) {
        HashMap<K, T2> miss = new HashMap<K, T2>();
        for (Map.Entry<K, V> entry : slice.entrySet()) {
            Object actl;
            K key = entry.getKey();
            V exp = entry.getValue();
            if (Objects.equals(exp, actl = this.igniteCache.get(key))) continue;
            miss.put(key, new T2(exp, actl));
        }
        return miss;
    }
}

