/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.managers.communication.GridIoMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicSingleUpdateRequest;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointListener;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.ListeningTestLogger;
import org.apache.ignite.testframework.LogListener;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.persistentstore.SnapshotChainMode;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotUpdateOperationParams;
import org.jetbrains.annotations.NotNull;
import org.junit.Test;

public class CreateSnapshotWithConcurrentPartitionsInitTest
extends GridCommonAbstractTest {
    private static final int NODES_COUNT = 4;
    private static final int TEST_KEY = 1;
    private static final int TEST_VAL = 1;
    private volatile boolean blockForNode0;
    private volatile UUID someBackupId;
    private final CountDownLatch atomicUpdateLatch = new CountDownLatch(1);
    private final CountDownLatch snapshotlatch = new CountDownLatch(1);
    private LogListener partValidationFailedLsnr = LogListener.matches((String)"Partition states validation has failed for group").build();
    private final ListeningTestLogger testLog = new ListeningTestLogger(this.log(), new LogListener[]{this.partValidationFailedLsnr});

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        String cId = "consistentId-" + igniteInstanceName;
        String dir = new File(this.snapshotsDir(), cId).getPath();
        return super.getConfiguration(igniteInstanceName).setConsistentId((Serializable)((Object)cId)).setCommunicationSpi((CommunicationSpi)new TestCommunicationSpi()).setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration("default").setAtomicityMode(CacheAtomicityMode.ATOMIC).setCacheMode(CacheMode.REPLICATED).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 8))}).setPluginConfigurations(new PluginConfiguration[]{new GridGainConfiguration().setSnapshotConfiguration(new SnapshotConfiguration().setSnapshotsPath(this.snapshotsDir().getPath()))}).setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true))).setGridLogger((IgniteLogger)this.testLog);
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stopAllGrids();
        this.cleanIgniteWorkDir();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanIgniteWorkDir();
        super.afterTest();
    }

    private void cleanIgniteWorkDir() throws Exception {
        this.cleanPersistenceDir();
        U.delete((File)this.snapshotsDir());
        U.delete((File)this.getMoveDir());
    }

    private File snapshotsDir() throws IgniteCheckedException {
        return U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"snapshots", (boolean)false);
    }

    private File getMoveDir() throws IgniteCheckedException {
        return U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"move_test", (boolean)true);
    }

    @NotNull
    private File getMoveDirWithCreate() throws IgniteCheckedException {
        File moveDir = this.getMoveDir();
        moveDir.mkdirs();
        return moveDir;
    }

    @Test
    public void test() throws Exception {
        IgniteEx ignite = this.startGrids(4);
        ignite.cluster().state(ClusterState.ACTIVE);
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        ArrayList affinityNodes = new ArrayList(ignite.affinity("default").mapKeyToPrimaryAndBackups((Object)1));
        this.someBackupId = ((ClusterNode)affinityNodes.get(1)).id();
        ((GridCacheDatabaseSharedManager)ignite.context().cache().context().database()).addCheckpointListener((CheckpointListener)new LatchReleaseCheckpointListener(this.atomicUpdateLatch));
        IgniteCache cache = ignite.getOrCreateCache("default");
        this.awaitPartitionMapExchange();
        this.blockForNode0 = true;
        AtomicLong snapshotId = new AtomicLong();
        IgniteInternalFuture futSnapshot = GridTestUtils.runAsync(() -> {
            try {
                this.snapshotlatch.await();
            }
            catch (InterruptedException e) {
                throw new IgniteException((Throwable)e);
            }
            SnapshotFuture fut = gg.snapshot().createFullSnapshot(Collections.singleton("default"), null);
            snapshotId.set(fut.snapshotOperation().snapshotId());
            fut.get();
        });
        IgniteInternalFuture futPut = GridTestUtils.runAsync(() -> cache.put((Object)1, (Object)1));
        futSnapshot.get();
        futPut.get();
        this.blockForNode0 = false;
        SnapshotUpdateOperationParams parameters = new SnapshotUpdateOperationParams(SnapshotChainMode.SINGLE, true, true, null);
        File moveDir = this.getMoveDirWithCreate();
        gg.snapshot().copySnapshot(snapshotId.get(), moveDir, true, parameters, null).get();
        this.stopAllGrids();
        this.cleanPersistenceDir();
        ignite = this.startGrids(4);
        ignite.cluster().state(ClusterState.ACTIVE);
        GridGain ggN = (GridGain)ignite.plugin("GridGain");
        ggN.snapshot().checkSnapshot(snapshotId.get(), Collections.singleton(moveDir), false, null).get();
        ggN.snapshot().restoreSnapshot(snapshotId.get(), Collections.singleton(moveDir), Collections.singleton("default"), null).get();
        for (int i = 0; i < 4; ++i) {
            CreateSnapshotWithConcurrentPartitionsInitTest.assertEquals((Object)1, (Object)this.grid(i).getOrCreateCache("default").get((Object)1));
        }
        CreateSnapshotWithConcurrentPartitionsInitTest.assertFalse((boolean)this.partValidationFailedLsnr.check());
    }

    private class LatchReleaseCheckpointListener
    implements CheckpointListener {
        private final CountDownLatch latch;

        private LatchReleaseCheckpointListener(CountDownLatch latch) {
            this.latch = latch;
        }

        public void onMarkCheckpointBegin(CheckpointListener.Context ctx) {
        }

        public void onCheckpointBegin(CheckpointListener.Context ctx) {
            this.latch.countDown();
            log.info("Test: checkpoint happened, releasing latch [nodeId=" + CreateSnapshotWithConcurrentPartitionsInitTest.this.someBackupId + "]");
        }

        public void beforeCheckpointBegin(CheckpointListener.Context ctx) {
        }
    }

    private class TestCommunicationSpi
    extends TcpCommunicationSpi {
        private TestCommunicationSpi() {
        }

        public void sendMessage(ClusterNode node, Message msg) throws IgniteSpiException {
            this.sendMessage(node, msg, null);
        }

        public void sendMessage(ClusterNode node, Message msg, IgniteInClosure<IgniteException> ackC) {
            Message msg0;
            if (msg instanceof GridIoMessage && (msg0 = ((GridIoMessage)msg).message()) instanceof GridDhtAtomicSingleUpdateRequest && CreateSnapshotWithConcurrentPartitionsInitTest.this.blockForNode0 && node.id().equals(CreateSnapshotWithConcurrentPartitionsInitTest.this.someBackupId)) {
                try {
                    log.info("Test: blocking atomic update on node [nodeId=" + CreateSnapshotWithConcurrentPartitionsInitTest.this.someBackupId + "]");
                    CreateSnapshotWithConcurrentPartitionsInitTest.this.snapshotlatch.countDown();
                    CreateSnapshotWithConcurrentPartitionsInitTest.this.atomicUpdateLatch.await();
                }
                catch (InterruptedException e) {
                    throw new IgniteException((Throwable)e);
                }
            }
            super.sendMessage(node, msg, ackC);
        }
    }
}

