/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.persistentstore.snapshot.file.remote.wal;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import org.apache.ignite.internal.processors.cache.persistence.file.AbstractFileIO;

class ReadOnlyFileIO
extends AbstractFileIO {
    private final InputStream inputStream;
    private final long size;
    private long totalBytesRead = 0L;
    private final byte[] arr = new byte[131072];

    public ReadOnlyFileIO(InputStream inputStream, long size) throws IOException {
        this.inputStream = new BufferedInputStream(inputStream);
        this.size = size;
    }

    public int getFileSystemBlockSize() {
        return -1;
    }

    public long getSparseSize() {
        return -1L;
    }

    public int punchHole(long position, int len) {
        throw new UnsupportedOperationException();
    }

    public long position() throws IOException {
        return this.totalBytesRead;
    }

    public void position(long newPosition) throws IOException {
        if (newPosition == this.totalBytesRead) {
            return;
        }
        if (newPosition < this.totalBytesRead) {
            throw new UnsupportedOperationException("Seeking backwards is not supported.");
        }
        long bytesRemaining = newPosition - this.totalBytesRead;
        this.inputStream.skip(bytesRemaining);
    }

    public int read(ByteBuffer dstBuf) throws IOException {
        int bytesRead = this.inputStream.read(this.arr, 0, Math.min(dstBuf.remaining(), this.arr.length));
        if (bytesRead == -1) {
            return -1;
        }
        dstBuf.put(this.arr, 0, bytesRead);
        this.totalBytesRead += (long)bytesRead;
        return bytesRead;
    }

    public int read(ByteBuffer dstBuf, long position) throws IOException {
        throw new UnsupportedOperationException();
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public int write(ByteBuffer srcBuf) throws IOException {
        throw new UnsupportedOperationException();
    }

    public int write(ByteBuffer srcBuf, long position) throws IOException {
        throw new UnsupportedOperationException();
    }

    public int write(byte[] buf, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void force() throws IOException {
        this.force(false);
    }

    public void force(boolean withMetadata) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long size() throws IOException {
        return this.size;
    }

    public void clear() throws IOException {
        throw new UnsupportedOperationException();
    }

    public MappedByteBuffer map(int sizeBytes) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void close() throws IOException {
        this.inputStream.close();
    }
}

