/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.persistentstore.snapshot.file.remote.wal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWriteAheadLogManager;
import org.apache.ignite.internal.processors.cache.persistence.wal.io.SegmentFileInputFactory;
import org.apache.ignite.internal.processors.cache.persistence.wal.io.SimpleSegmentFileInputFactory;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath;
import org.gridgain.grid.persistentstore.snapshot.file.remote.wal.SnapshotPathDescriptor;
import org.jetbrains.annotations.NotNull;

public class DescriptorFactory {
    private final IgniteLogger log;
    private final SegmentFileInputFactory segmentFileInputFactory = new SimpleSegmentFileInputFactory();

    public DescriptorFactory(IgniteLogger log) {
        this.log = log;
    }

    @NotNull
    public List<SnapshotPathDescriptor> createDescriptors(SnapshotPath path) {
        if (path == null) {
            return Collections.emptyList();
        }
        if (path.isFile()) {
            return Collections.singletonList(this.createSnapshotPathDescriptor(path));
        }
        if (!path.isDirectory()) {
            return Collections.emptyList();
        }
        TreeSet<SnapshotPathDescriptor> descriptors = new TreeSet<SnapshotPathDescriptor>();
        for (SnapshotPath childPath : path.getEntries()) {
            if (!childPath.isFile()) continue;
            this.addSnapshotPathDescriptor(childPath, descriptors);
        }
        return new ArrayList<SnapshotPathDescriptor>(descriptors);
    }

    private void addSnapshotPathDescriptor(SnapshotPath file, Collection<SnapshotPathDescriptor> descriptors) {
        SnapshotPathDescriptor descriptor = this.createSnapshotPathDescriptor(file);
        if (descriptor != null) {
            descriptors.add(descriptor);
        }
    }

    private SnapshotPathDescriptor createSnapshotPathDescriptor(SnapshotPath file) {
        if (!file.exists() || file.length() < 29L) {
            return null;
        }
        String fileName = file.getName();
        if (!FileWriteAheadLogManager.WAL_NAME_PATTERN.matcher(fileName).matches() && !FileWriteAheadLogManager.WAL_SEGMENT_FILE_COMPACTED_PATTERN.matcher(fileName).matches()) {
            return null;
        }
        return this.createDescriptor(file);
    }

    /*
     * Exception decompiling
     */
    private SnapshotPathDescriptor createDescriptor(SnapshotPath file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

