/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.persistentstore.snapshot.file.remote;

import com.jcraft.jsch.SftpException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.impl.StandardFileSystemManager;
import org.apache.commons.vfs2.provider.sftp.SftpFileObject;
import org.apache.ignite.IgniteException;
import org.gridgain.grid.internal.persistentstore.snapshot.file.remote.sftp.SafeSftpFileObject;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath;
import org.gridgain.grid.persistentstore.snapshot.file.remote.SnapshotPathFactory;
import org.gridgain.grid.persistentstore.snapshot.file.remote.VFS2Consumer;
import org.gridgain.grid.persistentstore.snapshot.file.remote.VFS2Function;
import org.gridgain.grid.persistentstore.snapshot.file.remote.VFS2IOExceptionConsumer;
import org.jetbrains.annotations.Nullable;

public class VFS2SnapshotPath
implements SnapshotPath {
    private static final String EXISTS_ERROR_TEXT = "File/Directory already exists";
    private final StandardFileSystemManager manager;
    private final String publicURIString;
    private final SftpFileObject fileObject;

    public VFS2SnapshotPath(StandardFileSystemManager manager, FileObject fileObject) {
        this.manager = manager;
        this.publicURIString = fileObject.getPublicURIString();
        try {
            this.fileObject = fileObject instanceof SafeSftpFileObject ? (SafeSftpFileObject)fileObject : SafeSftpFileObject.resolve(fileObject);
        }
        catch (FileSystemException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    FileObject getFileObject() {
        return this.fileObject;
    }

    private <T> T executeFunction(VFS2Function<FileObject, T> function) {
        try {
            return function.apply((FileObject)this.fileObject);
        }
        catch (FileSystemException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    private void executeConsumer(VFS2Consumer<FileObject> consumer) {
        try {
            consumer.accept((FileObject)this.fileObject);
        }
        catch (FileSystemException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    private void executeIOExceptionConsumer(VFS2IOExceptionConsumer<FileObject> consumer) throws IOException {
        try {
            consumer.accept((FileObject)this.fileObject);
        }
        catch (FileSystemException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    public long length() {
        return this.executeFunction(fileObject -> fileObject.getContent().getSize());
    }

    public boolean exists() {
        return this.executeFunction(FileObject::exists);
    }

    public boolean delete() {
        return this.executeFunction(FileObject::deleteAll) > 0;
    }

    public void deleteIfEmpty() {
        this.executeFunction(FileObject::delete);
    }

    public void createNewFile() {
        this.executeConsumer(FileObject::createFile);
    }

    public SnapshotPath getParent() {
        return this.executeFunction(fileObject -> {
            FileObject parent = fileObject.getParent();
            if (parent == null) {
                return null;
            }
            return new VFS2SnapshotPath(this.manager, parent);
        });
    }

    public boolean createDirectories() {
        try {
            this.fileObject.createFolder();
            return true;
        }
        catch (FileSystemException e) {
            if (e.getCause().getClass() == SftpException.class && EXISTS_ERROR_TEXT.equals(e.getCause().getMessage())) {
                return false;
            }
            throw new IgniteException((Throwable)e);
        }
    }

    public SnapshotPath resolve(String name) {
        return this.executeFunction(fileObject -> new VFS2SnapshotPath(this.manager, fileObject.resolveFile(name)));
    }

    @Nullable
    public SnapshotPath resolveRegularOrCompressed(String name) {
        return this.executeFunction(fileObject -> {
            for (CompressionOption opt : CompressionOption.values()) {
                SftpFileObject file = SafeSftpFileObject.resolve(fileObject.resolveFile(name + opt.fileExtension()));
                if (!file.exists() || !file.isFile()) continue;
                return new VFS2SnapshotPath(this.manager, (FileObject)file);
            }
            return null;
        });
    }

    public boolean isFile() {
        return this.executeFunction(FileObject::isFile);
    }

    public boolean isDirectory() {
        return this.executeFunction(FileObject::isFolder);
    }

    public boolean isEmptyDirectory() {
        return this.executeFunction(fileObject -> {
            if (!fileObject.isFolder()) {
                return false;
            }
            FileObject[] children = fileObject.getChildren();
            return children == null || children.length == 0;
        });
    }

    public SnapshotPath resolveSibling(String fileName) {
        return this.getParent().resolve(fileName);
    }

    public OutputStream outputStream() {
        return this.executeFunction(fileObject -> fileObject.getContent().getOutputStream());
    }

    public InputStream inputStream() {
        return this.executeFunction(fileObject -> fileObject.getContent().getInputStream());
    }

    public String getName() {
        return this.executeFunction(fileObject -> fileObject.getName().getBaseName());
    }

    public String getAbsolutePath() {
        return this.publicURIString;
    }

    public Collection<SnapshotPath> getEntries() {
        return this.executeFunction(fileObject -> {
            if (!fileObject.isFolder()) {
                return Collections.emptyList();
            }
            FileObject[] children = fileObject.getChildren();
            if (children == null) {
                return Collections.emptyList();
            }
            return Arrays.stream(children).map(child -> new VFS2SnapshotPath(this.manager, (FileObject)child)).collect(Collectors.toList());
        });
    }

    public void sync() {
    }

    public void copyFrom(Path srcFile) throws IOException {
        this.executeIOExceptionConsumer(fileObject -> {
            FileObject parent = fileObject.getParent();
            SftpFileObject tmpFile = SafeSftpFileObject.resolve(parent.resolveFile(this.getName() + ".tmp"));
            FileObject from = SnapshotPathFactory.getManager().toFileObject(srcFile.toFile());
            if (from instanceof SftpFileObject) {
                from = SafeSftpFileObject.resolve(from);
            }
            tmpFile.copyFrom(from, Selectors.SELECT_SELF);
            tmpFile.moveTo(fileObject);
        });
    }

    public String toString() {
        return this.publicURIString;
    }
}

