/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.database.snapshot;

import java.util.concurrent.TimeUnit;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.UserCommandExceptions;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.internal.GridGainImpl;
import org.gridgain.grid.internal.processors.cache.database.GridSnapshotEx;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.SnapshotScheduleProcessor;

public class VisorSnapshots {
    public static final String PERSISTANCE_NOT_CONFIGURED = "Persistence is not configured";
    public static final String GG_SNAPSHOTS_NOT_CONFIGURED = "GridGain snapshots are not configured";
    public static final String EVERY_15_MINS = "15mins";
    public static final String EVERY_30_MINS = "30mins";
    public static final String HOURLY = "hourly";
    public static final String DAILY = "daily";
    public static final String WEEKLY = "weekly";

    private static boolean snapshotsNotConfigured(GridGainConfiguration ggCfg) {
        return ggCfg == null || ggCfg.getSnapshotConfiguration() == null;
    }

    public static GridSnapshotEx snapshot(Ignite ignite) {
        if (!GridCacheUtils.isPersistenceEnabled((IgniteConfiguration)ignite.configuration())) {
            throw UserCommandExceptions.invalidUserCommandException((String)PERSISTANCE_NOT_CONFIGURED, (DiscoverySpi)ignite.configuration().getDiscoverySpi());
        }
        VisorSnapshots.checkClusterState(ignite);
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        GridSnapshotEx snapshot = (GridSnapshotEx)gg.snapshot();
        if (snapshot == null || VisorSnapshots.snapshotsNotConfigured(gg.configuration())) {
            throw UserCommandExceptions.invalidUserCommandException((String)GG_SNAPSHOTS_NOT_CONFIGURED, (DiscoverySpi)ignite.configuration().getDiscoverySpi());
        }
        return snapshot;
    }

    public static SnapshotScheduleProcessor scheduler(Ignite ignite) {
        VisorSnapshots.checkClusterState(ignite);
        GridGainImpl gg = (GridGainImpl)ignite.plugin("GridGain");
        SnapshotScheduleProcessor scheduler = (SnapshotScheduleProcessor)gg.provider().getSnapshotScheduler();
        if (scheduler == null || VisorSnapshots.snapshotsNotConfigured(gg.configuration())) {
            throw UserCommandExceptions.invalidUserCommandException((String)GG_SNAPSHOTS_NOT_CONFIGURED, (DiscoverySpi)ignite.configuration().getDiscoverySpi());
        }
        return scheduler;
    }

    public static String toCron(String s) {
        switch (s.toLowerCase()) {
            case "15mins": {
                return "0,15,30,45 * * * *";
            }
            case "30mins": {
                return "0,30 * * * *";
            }
            case "hourly": {
                return "0 */1 * * *";
            }
            case "daily": {
                return "0 0 * * *";
            }
            case "weekly": {
                return "0 0 * * 0";
            }
        }
        return s;
    }

    public static String fromCron(String s) {
        if (F.isEmpty((String)s)) {
            return "Never";
        }
        switch (s.toLowerCase()) {
            case "*/15 * * * *": {
                return EVERY_15_MINS;
            }
            case "*/30 * * * *": {
                return EVERY_30_MINS;
            }
            case "0 */1 * * *": {
                return HOURLY;
            }
            case "0 0 * * *": {
                return DAILY;
            }
            case "0 0 * * 0": {
                return WEEKLY;
            }
        }
        return s;
    }

    private static long parseTtl(String ttl) {
        return Long.parseLong(ttl.substring(0, ttl.length() - 1));
    }

    public static long timeToMilliseconds(String t) {
        if (t.endsWith("d")) {
            return TimeUnit.DAYS.toMillis(VisorSnapshots.parseTtl(t));
        }
        if (t.endsWith("h")) {
            return TimeUnit.HOURS.toMillis(VisorSnapshots.parseTtl(t));
        }
        if (t.endsWith("m")) {
            return TimeUnit.MINUTES.toMillis(VisorSnapshots.parseTtl(t));
        }
        return Long.parseLong(t);
    }

    public static String millisecondsToTime(long millis) {
        long res = TimeUnit.MILLISECONDS.toDays(millis);
        if (TimeUnit.DAYS.toMillis(res) == millis) {
            return res + " days";
        }
        res = TimeUnit.MILLISECONDS.toHours(millis);
        if (TimeUnit.HOURS.toMillis(res) == millis) {
            return res + " hours";
        }
        res = TimeUnit.MILLISECONDS.toMinutes(millis);
        if (TimeUnit.MINUTES.toMillis(res) == millis) {
            return res + " minutes";
        }
        res = TimeUnit.MILLISECONDS.toSeconds(millis);
        if (TimeUnit.SECONDS.toMillis(res) == millis) {
            return res + " seconds";
        }
        return millis + " milliseconds";
    }

    private static void checkClusterState(Ignite ignite) throws IgniteException {
        if (ignite.cluster().state() == ClusterState.INACTIVE) {
            throw UserCommandExceptions.invalidUserCommandException((String)"Can not perform the operation because the cluster is inactive.", (DiscoverySpi)ignite.configuration().getDiscoverySpi());
        }
    }
}

