/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.database.snapshot;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCommonParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCreateParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.SnapshotSchedule;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.SnapshotScheduleV2;
import org.gridgain.grid.persistentstore.SnapshotCreateParams;
import org.gridgain.grid.persistentstore.SnapshotOperationType;
import org.jetbrains.annotations.Nullable;

public class VisorSnapshotSchedule
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    public static final int DFLT_KEEP = 1;
    private String id;
    private String name;
    private SnapshotOperationType opType;
    private String fullSnapshotFreq;
    private String incSnapshotFreq;
    private Set<String> cacheNames;
    private long ttl;
    private String dest;
    private String keyAlias;
    private boolean enabled;
    private SnapshotCommonParameters snapshotCommonParameters;
    private SnapshotCreateParameters snapshotCreateParameters;
    private int forOldest;
    private int forLatest;
    @Nullable
    private String execAfter;
    private int keepCount = 1;

    public VisorSnapshotSchedule() {
    }

    private VisorSnapshotSchedule(String id, String name, SnapshotOperationType opType, String fullSnapshotFreq, String incSnapshotFreq, Set<String> cacheNames, long ttl, String dest, boolean enabled, SnapshotCommonParameters snapshotCommonParameters, SnapshotCreateParameters snapshotCreateParameters, String keyAlias, int forOldest, int forLatest, @Nullable String execAfter, int keepCount) {
        assert (name != null);
        assert (opType == SnapshotOperationType.CREATE || opType == SnapshotOperationType.DELETE || opType == SnapshotOperationType.MOVE || opType == SnapshotOperationType.CHECK || opType == null);
        this.id = id;
        this.name = name;
        this.opType = opType;
        this.fullSnapshotFreq = fullSnapshotFreq;
        this.incSnapshotFreq = incSnapshotFreq;
        this.cacheNames = cacheNames;
        this.ttl = ttl;
        this.dest = dest;
        this.enabled = enabled;
        this.snapshotCommonParameters = snapshotCommonParameters;
        this.snapshotCreateParameters = snapshotCreateParameters;
        this.keyAlias = keyAlias;
        this.forOldest = forOldest;
        this.forLatest = forLatest;
        this.execAfter = execAfter;
        this.keepCount = keepCount;
    }

    public VisorSnapshotSchedule(String id, String name, String fullSnapshotFreq, String incSnapshotFreq, Set<String> cacheNames, boolean enabled) {
        this(id, name, SnapshotOperationType.CREATE, fullSnapshotFreq, incSnapshotFreq, cacheNames, -1L, null, enabled, null, null, null, -1, -1, null, 1);
    }

    public VisorSnapshotSchedule(String id, String name, long ttl, boolean enabled) {
        this(id, name, SnapshotOperationType.DELETE, "hourly", null, null, ttl, null, enabled, null, null, null, -1, -1, null, 1);
    }

    public VisorSnapshotSchedule(String id, String name, long ttl, String dest, boolean enabled, String keyAlias) {
        this(id, name, SnapshotOperationType.MOVE, "hourly", null, null, ttl, dest, enabled, null, null, keyAlias, -1, -1, null, 1);
    }

    public VisorSnapshotSchedule(String name) {
        this(null, name, null, null, null, null, -1L, null, true, null, null, null, -1, -1, null, 1);
    }

    public VisorSnapshotSchedule(String name, boolean enabled) {
        this(null, name, null, null, null, null, -1L, null, enabled, null, null, null, -1, -1, null, 1);
    }

    public VisorSnapshotSchedule(SnapshotSchedule schedule) {
        this(schedule.getId(), schedule.getName(), schedule.getOperationType(), schedule.getFullSnapshotFrequency(), schedule.getIncrementalSnapshotFrequency(), schedule.getCacheNames(), schedule.getTtl(), schedule.getDestination(), schedule.isEnabled(), schedule.getSnapshotCommonParameters(), schedule.getSnapshotCreateParameters(), null, -1, -1, null, 1);
    }

    public VisorSnapshotSchedule(SnapshotScheduleV2 schedule) {
        this(schedule.getId(), schedule.getName(), schedule.getOperationType(), schedule.getFullSnapshotFrequency(), schedule.getIncrementalSnapshotFrequency(), schedule.getCacheNames(), schedule.getTtl(), schedule.getDestination(), schedule.isEnabled(), schedule.getSnapshotCommonParameters(), schedule.getSnapshotCreateParameters(), schedule.getKeyAlias(), schedule.forOldest(), schedule.forLatest(), schedule.execAfter(), schedule.keepCount());
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SnapshotOperationType getOperationType() {
        return this.opType;
    }

    public void setOperationType(SnapshotOperationType opType) {
        this.opType = opType;
    }

    public String getFullSnapshotFrequency() {
        return this.fullSnapshotFreq;
    }

    public void setFullSnapshotFrequency(String fullSnapshotFreq) {
        this.fullSnapshotFreq = fullSnapshotFreq;
    }

    public String getIncrementalSnapshotFrequency() {
        return this.incSnapshotFreq;
    }

    public void setIncrementalSnapshotFrequency(String incSnapshotFreq) {
        this.incSnapshotFreq = incSnapshotFreq;
    }

    public Set<String> getCacheNames() {
        return this.cacheNames;
    }

    public void setCacheNames(Set<String> cacheNames) {
        this.cacheNames = cacheNames;
    }

    public long getTtl() {
        return this.ttl;
    }

    public void setTtl(Long ttl) {
        this.ttl = ttl;
    }

    public String getDestination() {
        return this.dest;
    }

    public void setDestination(String dest) {
        this.dest = dest;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public void setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public SnapshotCommonParameters getSnapshotCommonParameters() {
        return this.snapshotCommonParameters;
    }

    public void setSnapshotCommonParameters(SnapshotCommonParameters snapshotCommonParameters) {
        this.snapshotCommonParameters = snapshotCommonParameters;
    }

    public SnapshotCreateParameters getSnapshotCreateParameters() {
        return this.snapshotCreateParameters;
    }

    public SnapshotCreateParams getSnapshotCreateParams() {
        return SnapshotCreateParameters.convertSnapshotCreateParameters((SnapshotCreateParameters)this.snapshotCreateParameters);
    }

    public void setSnapshotCreateParameters(SnapshotCreateParameters snapshotCreateParameters) {
        this.snapshotCreateParameters = snapshotCreateParameters;
    }

    public void setSnapshotCreateParams(SnapshotCreateParams snapshotCreateParams) {
        this.snapshotCreateParameters = SnapshotCreateParameters.convertSnapshotCreateParams((SnapshotCreateParams)snapshotCreateParams);
    }

    public int forOldest() {
        return this.forOldest;
    }

    public void forOldest(int forOldest) {
        this.forOldest = forOldest;
    }

    public int forLatest() {
        return this.forLatest;
    }

    public void forLatest(int forLatest) {
        this.forLatest = forLatest;
    }

    @Nullable
    public String execAfter() {
        return this.execAfter;
    }

    public void execAfter(@Nullable String execAfter) {
        this.execAfter = execAfter;
    }

    public int keepCount() {
        return this.keepCount;
    }

    public void keepCount(int keepCount) {
        this.keepCount = keepCount;
    }

    public byte getProtocolVersion() {
        return 6;
    }

    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeCutString((DataOutput)out, (String)this.id);
        U.writeCutString((DataOutput)out, (String)this.name);
        U.writeEnum((DataOutput)out, (Enum)this.opType);
        U.writeCutString((DataOutput)out, (String)this.fullSnapshotFreq);
        U.writeCutString((DataOutput)out, (String)this.incSnapshotFreq);
        U.writeCollection((ObjectOutput)out, this.cacheNames);
        out.writeLong(this.ttl);
        U.writeCutString((DataOutput)out, (String)this.dest);
        out.writeBoolean(this.enabled);
        out.writeObject(this.snapshotCommonParameters);
        out.writeObject(this.snapshotCreateParameters);
        U.writeCutString((DataOutput)out, (String)this.keyAlias);
        out.writeInt(this.forOldest);
        out.writeInt(this.forLatest);
        U.writeCutString((DataOutput)out, (String)this.execAfter);
        out.writeInt(this.keepCount);
    }

    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = U.readString((DataInput)in);
        this.name = U.readString((DataInput)in);
        this.opType = SnapshotOperationType.fromOrdinal((int)in.readByte());
        this.fullSnapshotFreq = U.readString((DataInput)in);
        this.incSnapshotFreq = U.readString((DataInput)in);
        this.cacheNames = U.readSet((ObjectInput)in);
        this.ttl = in.readLong();
        this.dest = U.readString((DataInput)in);
        this.enabled = in.readBoolean();
        if (protoVer > 1) {
            this.snapshotCommonParameters = (SnapshotCommonParameters)in.readObject();
            this.snapshotCreateParameters = (SnapshotCreateParameters)in.readObject();
        }
        if (protoVer > 2) {
            this.keyAlias = U.readString((DataInput)in);
        }
        if (protoVer > 3) {
            this.forOldest = in.readInt();
            this.forLatest = in.readInt();
        }
        if (protoVer > 4) {
            this.execAfter = U.readString((DataInput)in);
        }
        if (protoVer > 5) {
            this.keepCount = in.readInt();
        }
    }

    public String toString() {
        return S.toString(VisorSnapshotSchedule.class, (Object)((Object)this));
    }
}

