/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.database.snapshot;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorServerNodeTask;
import org.gridgain.grid.internal.processors.cache.database.GridSnapshotEx;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCommonParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCreateParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotInfoEssential;
import org.gridgain.grid.internal.visor.database.snapshot.VisorSnapshotInfo;
import org.gridgain.grid.internal.visor.database.snapshot.VisorSnapshots;
import org.gridgain.grid.persistentstore.SnapshotInfo;
import org.gridgain.grid.persistentstore.SnapshotOperationType;

@GridInternal
public class VisorListSnapshotsTask
extends VisorServerNodeTask<VisorSnapshotInfo, List<VisorSnapshotInfo>> {
    private static final long serialVersionUID = 0L;
    private static final Comparator<VisorSnapshotInfo> SNAPSHOTS_COMPARATOR = Comparator.comparingLong(VisorSnapshotInfo::getSnapshotId);

    protected VisorListSnapshotsJob job(VisorSnapshotInfo arg) {
        return new VisorListSnapshotsJob(arg, this.debug);
    }

    private static class VisorListSnapshotsJob
    extends VisorJob<VisorSnapshotInfo, List<VisorSnapshotInfo>> {
        private static final long serialVersionUID = 0L;

        private VisorListSnapshotsJob(VisorSnapshotInfo arg, boolean debug) {
            super((Object)arg, debug);
        }

        protected List<VisorSnapshotInfo> run(VisorSnapshotInfo arg) throws IgniteException {
            Collection paths = F.isEmpty(arg.getPaths()) ? null : (Collection)arg.getPaths().stream().map(File::new).collect(Collectors.toList());
            GridSnapshotEx snapshot = VisorSnapshots.snapshot((Ignite)this.ignite);
            List snapshotInfos = snapshot.listSnapshots(paths);
            ArrayList<VisorSnapshotInfo> res = new ArrayList<VisorSnapshotInfo>(snapshotInfos.size());
            String clusterName = this.ignite.cluster().tag();
            for (SnapshotInfo snapshotInfo : snapshotInfos) {
                if (snapshotInfo instanceof SnapshotInfoEssential) {
                    SnapshotInfoEssential snapInfEssential = (SnapshotInfoEssential)snapshotInfo;
                    res.add(new VisorSnapshotInfo.Builder().withSnapshotId(snapInfEssential.snapshotId()).withOperationType(SnapshotOperationType.CREATE).withFullSnapshot(snapInfEssential.fullSnapshot()).withCacheNames(snapInfEssential.cacheNames()).withMessage(snapInfEssential.message()).withClusterName(clusterName).withInitiatorNode(snapInfEssential.initiatorNode()).withClusterSize(snapInfEssential.serverNodeCount()).withBaselineTopologySize(snapInfEssential.baselineTopologySize()).withSnapshotAttrs(snapInfEssential.snapshotAttributes()).withSnapshotCommonParameters(new SnapshotCommonParameters()).withSnapshotCreateParameters(new SnapshotCreateParameters(snapInfEssential.compressionOption(), snapInfEssential.compressionLevel(), 0)).withSize(snapInfEssential.size()).withWalSize(snapInfEssential.walSize()).withClusterNodeVersions(snapInfEssential.clusterNodesVersions()).build());
                    continue;
                }
                throw new AssertionError((Object)("Unexpected class was received - " + snapshotInfo.getClass().getName()));
            }
            res.sort(SNAPSHOTS_COMPARATOR);
            return res;
        }

        public String toString() {
            return S.toString(VisorListSnapshotsJob.class, (Object)((Object)this));
        }
    }
}

