/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.txdr;

import java.util.Objects;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.gridgain.grid.internal.processors.cache.database.GridSnapshotManager;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.jetbrains.annotations.NotNull;

public class ConsistentCutScheduler
extends GridWorker {
    static final String THREAD_NAME_PREFIX = "cc-scheduler";
    private final GridSnapshotManager snapshotMgr;
    private final long cutInterval;
    private volatile boolean stopped;

    ConsistentCutScheduler(String igniteInstanceName, @NotNull IgniteLogger log, @NotNull GridSnapshotManager snapshotMgr, long cutInterval) {
        super(igniteInstanceName, THREAD_NAME_PREFIX, log);
        this.snapshotMgr = Objects.requireNonNull(snapshotMgr);
        this.cutInterval = cutInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void body() throws IgniteInterruptedCheckedException {
        long lastCutFinishedTs = U.currentTimeMillis();
        if (this.cutInterval == Long.MAX_VALUE) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Consistent cut scheduler disabled");
            }
            return;
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Consistent cut scheduler started");
        }
        while (!this.stopped) {
            long millisToWait = this.cutInterval - (U.currentTimeMillis() - lastCutFinishedTs);
            if (millisToWait <= 0L) {
                SnapshotFuture fut = this.snapshotMgr.startGlobalConsistentCut();
                try {
                    fut.get();
                    continue;
                }
                catch (IgniteInterruptedException e) {
                    if (this.stopped) continue;
                    throw e;
                }
                catch (Throwable e) {
                    this.log.error("Error during creation consistent cut.", e);
                    continue;
                }
                finally {
                    lastCutFinishedTs = U.currentTimeMillis();
                    continue;
                }
            }
            U.sleep((long)millisToWait);
        }
    }

    public void shutdown() throws IgniteInterruptedCheckedException {
        this.stop(false);
    }

    public void shutdownNow() throws IgniteInterruptedCheckedException {
        this.stop(true);
    }

    private void stop(boolean cancel) throws IgniteInterruptedCheckedException {
        if (this.log.isInfoEnabled()) {
            this.log.info("Stopping consistent cut scheduler" + (cancel ? "" : " gracefully"));
        }
        this.stopped = true;
        if (cancel) {
            this.cancel();
        }
        U.join((Thread)this.runner());
        if (this.log.isInfoEnabled()) {
            this.log.info("Consistent cut scheduler stopped");
        }
    }
}

