/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot.schedule;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteScheduler;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.scheduler.SchedulerFuture;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCommonParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCreateParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.ScheduleJobWrapper;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.ScheduledSnapshotCreation;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.ScheduledSnapshotOperation;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.ScheduledSnapshotsDeletion;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.ScheduledSnapshotsMoving;
import org.gridgain.grid.internal.visor.database.snapshot.VisorSnapshots;
import org.gridgain.grid.persistentstore.SnapshotOperationType;

@Deprecated
public class SnapshotSchedule
implements Serializable {
    private static final long serialVersionUID = 0L;
    private String id;
    private String name;
    private SnapshotOperationType opType;
    private String fullSnapshotFreq;
    private transient SchedulerFuture fullSnapshotTask;
    private String incSnapshotFreq;
    private long ttl;
    private String dest;
    private Set<String> cacheNames;
    private boolean enabled = true;
    private UUID nid;
    private List<String> locSchedules = new ArrayList<String>();
    private SnapshotCommonParameters snapshotCommonParameters;
    private SnapshotCreateParameters snapshotCreateParameters;

    public SnapshotSchedule(String id, String name, SnapshotOperationType opType, String fullSnapshotFreq, String incSnapshotFreq, Set<String> cacheNames, long ttl, String dest, boolean enabled, SnapshotCommonParameters snapshotCommonParameters, SnapshotCreateParameters snapshotCreateParameters) {
        assert (name != null);
        assert (opType == SnapshotOperationType.CREATE || opType == SnapshotOperationType.DELETE || opType == SnapshotOperationType.MOVE);
        this.id = id != null ? id : UUID.randomUUID().toString();
        this.name = name;
        this.opType = opType;
        this.fullSnapshotFreq = fullSnapshotFreq;
        this.incSnapshotFreq = incSnapshotFreq;
        this.cacheNames = cacheNames;
        this.ttl = ttl;
        this.dest = dest;
        this.enabled = enabled;
        this.snapshotCommonParameters = snapshotCommonParameters;
        this.snapshotCreateParameters = snapshotCreateParameters;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public SnapshotOperationType getOperationType() {
        return this.opType;
    }

    public String getFullSnapshotFrequency() {
        return this.fullSnapshotFreq;
    }

    public boolean getFullSnapshotRunning() {
        return this.fullSnapshotTask.isRunning();
    }

    public long getFullSnapshotLastFinishTime() {
        return this.fullSnapshotTask.lastFinishTime();
    }

    public long getFullSnapshotNextExecutionTime() {
        return this.fullSnapshotTask.nextExecutionTime();
    }

    public long getFullSnapshotLastExecutionDuration() {
        return this.fullSnapshotTask.lastFinishTime() - this.fullSnapshotTask.lastStartTime();
    }

    public String getIncrementalSnapshotFrequency() {
        return this.incSnapshotFreq;
    }

    public long getTtl() {
        return this.ttl;
    }

    public String getDestination() {
        return this.dest;
    }

    public Set<String> getCacheNames() {
        return this.cacheNames;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public SnapshotCommonParameters getSnapshotCommonParameters() {
        return this.snapshotCommonParameters;
    }

    public void setSnapshotCommonParameters(SnapshotCommonParameters snapshotCommonParameters) {
        this.snapshotCommonParameters = snapshotCommonParameters;
    }

    public void setSnapshotCreateParameters(SnapshotCreateParameters snapshotCreateParameters) {
        this.snapshotCreateParameters = snapshotCreateParameters;
    }

    public SnapshotCreateParameters getSnapshotCreateParameters() {
        return this.snapshotCreateParameters;
    }

    public List<String> getLocSchedules() {
        return this.locSchedules;
    }

    public UUID getNid() {
        return this.nid;
    }

    public void setNid(UUID nid) {
        this.nid = nid;
    }

    public SnapshotSchedule copy() {
        SnapshotSchedule copy = new SnapshotSchedule(this.id, this.name, this.opType, this.fullSnapshotFreq, this.incSnapshotFreq, this.cacheNames == null ? null : new HashSet<String>(this.cacheNames), this.ttl, this.dest, this.enabled, this.snapshotCommonParameters, this.snapshotCreateParameters);
        copy.nid = this.nid;
        copy.locSchedules = new ArrayList<String>(this.locSchedules);
        copy.fullSnapshotTask = this.fullSnapshotTask;
        return copy;
    }

    private SchedulerFuture scheduleLocal(Ignite ignite, ScheduledSnapshotOperation job, String cron) {
        IgniteScheduler scheduler = ignite.scheduler();
        SchedulerFuture fut = scheduler.scheduleLocal((Callable)new ScheduleJobWrapper(ignite, job), VisorSnapshots.toCron(cron));
        fut.last();
        ConcurrentMap nl = ignite.cluster().nodeLocalMap();
        nl.put(fut.id(), fut);
        this.locSchedules.add(fut.id());
        return fut;
    }

    private void startLocal0(Ignite ignite) {
        if (this.opType == SnapshotOperationType.CREATE) {
            ScheduledSnapshotCreation parent = new ScheduledSnapshotCreation(ignite, this, true);
            this.fullSnapshotTask = this.scheduleLocal(ignite, parent, this.fullSnapshotFreq);
            if (!F.isEmpty((String)this.incSnapshotFreq)) {
                this.scheduleLocal(ignite, new ScheduledSnapshotCreation(ignite, this, false), this.incSnapshotFreq);
            }
        } else if (this.opType == SnapshotOperationType.DELETE) {
            this.scheduleLocal(ignite, new ScheduledSnapshotsDeletion(ignite, this), this.fullSnapshotFreq);
        } else if (this.opType == SnapshotOperationType.MOVE) {
            this.scheduleLocal(ignite, new ScheduledSnapshotsMoving(ignite, this), this.fullSnapshotFreq);
        }
        this.enabled = true;
    }

    public boolean startLocal(Ignite ignite) {
        UUID locNodeId = ignite.cluster().localNode().id();
        if (!locNodeId.equals(this.nid)) {
            this.nid = locNodeId;
            this.locSchedules.clear();
        }
        if (this.locSchedules.isEmpty() && this.enabled) {
            this.startLocal0(ignite);
            return true;
        }
        return false;
    }

    public boolean enable(Ignite ignite) {
        if (this.locSchedules.isEmpty() && !this.enabled) {
            this.startLocal0(ignite);
            return true;
        }
        return false;
    }

    public void cancel(Ignite ignite) {
        ConcurrentMap nl = ignite.cluster().nodeLocalMap();
        for (String locId : this.locSchedules) {
            SchedulerFuture fut = (SchedulerFuture)nl.remove(locId);
            if (fut == null) continue;
            fut.cancel();
        }
        this.locSchedules.clear();
    }

    public void disable(Ignite ignite) {
        this.cancel(ignite);
        this.enabled = false;
    }

    public String toString() {
        return S.toString(SnapshotSchedule.class, (Object)this);
    }
}

