/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.recovery;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationContext;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotProgressCalculator;
import org.jetbrains.annotations.Nullable;

public class WALPointerIntervalProgressCalculator
implements SnapshotProgressCalculator {
    public static final int DEFAULT_INTERVALS_COUNT = 100;
    private final List<Long> startWALPointersProgress = new ArrayList<Long>();
    private final List<FileWALPointer> endWALPointers = new ArrayList<FileWALPointer>();
    private final int walSegmentSize;
    private final int intervalsCount;
    private final AtomicLong totalProgress = new AtomicLong();
    private final IgniteLogger logger;
    private AtomicLongArray iteratorProgressArray;
    private volatile double step;
    private final AtomicIntegerArray percentsReportedArray;
    private final SnapshotOperationContext snapshotOperationContext;

    public WALPointerIntervalProgressCalculator(int walSegmentSize, SnapshotOperationContext snapshotOperationContext, IgniteLogger logger) {
        this(100, walSegmentSize, snapshotOperationContext, logger);
    }

    public WALPointerIntervalProgressCalculator(int intervalsCount, int walSegmentSize, SnapshotOperationContext snapshotOperationContext, IgniteLogger logger) {
        this.intervalsCount = intervalsCount;
        this.walSegmentSize = walSegmentSize;
        this.snapshotOperationContext = snapshotOperationContext;
        this.logger = logger;
        this.percentsReportedArray = new AtomicIntegerArray(intervalsCount + 1);
    }

    @Nullable
    public Integer addWALPointers(FileWALPointer start, FileWALPointer end) throws IgniteCheckedException {
        if (end == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Skip track progress, end WAL pointer is null");
            }
            return null;
        }
        if (start == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Skip track progress, start WAL pointer is null");
            }
            return null;
        }
        if (end.compareTo(start) <= 0) {
            throw new IgniteCheckedException("End WAL pointer should be greater than start.");
        }
        this.startWALPointersProgress.add(this.pointerProgress(start));
        this.endWALPointers.add(end);
        this.totalProgress.addAndGet(this.pointerProgress(end) - this.pointerProgress(start));
        return this.startWALPointersProgress.size() - 1;
    }

    public void calculateStep() throws IgniteException {
        this.iteratorProgressArray = new AtomicLongArray(this.startWALPointersProgress.size());
        this.step = (double)this.totalProgress.get() / (double)this.intervalsCount;
        if (this.totalProgress.get() != 0L && this.step == 0.0) {
            throw new IgniteException("Progress step cannot be zero, pointers you are passing are probably wrong or you need to reduce intervalsCount!");
        }
    }

    private long pointerProgress(FileWALPointer walPointer) {
        return walPointer.index() * (long)this.walSegmentSize + (long)walPointer.fileOffset();
    }

    public long progress(long amountOfWork) {
        return amountOfWork;
    }

    public long total() {
        return this.totalProgress.get();
    }

    public void reportWork(FileWALPointer walPointer, @Nullable Integer index) {
        if (index == null) {
            return;
        }
        double step0 = this.step;
        if (this.endWALPointers.get(index) == null || walPointer.compareTo(this.endWALPointers.get(index)) > 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Something is wrong here, end WAL pointer is null or " + walPointer + " is more than end pointer " + this.endWALPointers.get(index));
            }
            return;
        }
        long currentProgress = this.pointerProgress(walPointer) - this.startWALPointersProgress.get(index);
        this.iteratorProgressArray.set(index, currentProgress);
        long totalCurrentProgress = 0L;
        for (int i = 0; i < this.iteratorProgressArray.length(); ++i) {
            totalCurrentProgress += this.iteratorProgressArray.get(i);
        }
        int percentToTrack = (int)Math.round((double)totalCurrentProgress / step0);
        if (this.percentsReportedArray.compareAndSet(percentToTrack, 0, 1)) {
            this.snapshotOperationContext.reportWork(totalCurrentProgress);
        }
    }
}

