/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.messages;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.managers.discovery.DiscoveryCustomMessage;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotDiscoveryMessage;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotOperation;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridSnapshotOperationAttrs;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridSnapshotOperationEx;
import org.gridgain.grid.persistentstore.SnapshotOperationType;
import org.jetbrains.annotations.Nullable;

public class StartSnapshotOperationAckDiscoveryMessage
implements SnapshotDiscoveryMessage {
    private static final long serialVersionUID = 0L;
    private GridSnapshotOperationEx snapshotOperation;
    private IgniteUuid id = IgniteUuid.randomUuid();
    private IgniteUuid opId;
    private Exception err;
    private UUID initiatorNodeId;
    @Deprecated
    private Map<Integer, Long> lastFullSnapshotIdForCache = new HashMap<Integer, Long>();
    @Deprecated
    private Map<Integer, Long> lastSnapshotIdForCache;
    private Map<String, Resolution> resolutions;

    public StartSnapshotOperationAckDiscoveryMessage(IgniteUuid opId, GridSnapshotOperationEx snapshotOperation, Map<Integer, Long> lastSnapshotIdForCache, Map<String, Resolution> resolutions, Exception err, UUID initiatorNodeId) {
        this.opId = opId;
        this.snapshotOperation = snapshotOperation;
        this.resolutions = resolutions;
        this.err = err;
        this.initiatorNodeId = initiatorNodeId;
    }

    public IgniteUuid id() {
        return this.id;
    }

    public boolean needExchange() {
        boolean exchangeOnSnapshotCreation = this.snapshotOperation.type() == SnapshotOperationType.CREATE && !GridSnapshotOperationAttrs.exchangelessSnapshot((SnapshotOperation)this.snapshotOperation);
        return this.err == null && (exchangeOnSnapshotCreation || GridSnapshotOperationAttrs.getNeedExchangeOnStart((GridSnapshotOperationEx)this.snapshotOperation));
    }

    public boolean needAssignPartitions() {
        return false;
    }

    public IgniteUuid operationId() {
        return this.opId;
    }

    public UUID initiatorNodeId() {
        return this.initiatorNodeId;
    }

    public Exception error() {
        return this.err;
    }

    public Map<String, Resolution> resolutions() {
        return this.resolutions;
    }

    public boolean hasError() {
        return this.err != null;
    }

    public GridSnapshotOperationEx snapshotOperation() {
        return this.snapshotOperation;
    }

    @Nullable
    public DiscoveryCustomMessage ackMessage() {
        return null;
    }

    public boolean isMutable() {
        return false;
    }

    public boolean stopProcess() {
        return false;
    }

    public DiscoCache createDiscoCache(GridDiscoveryManager mgr, AffinityTopologyVersion topVer, DiscoCache discoCache) {
        return discoCache.copy(topVer, null);
    }

    public String toString() {
        return S.toString(StartSnapshotOperationAckDiscoveryMessage.class, (Object)this);
    }

    public static enum Resolution {
        FORCE_FULL,
        INCREMENTAL,
        IGNORE;

    }
}

