/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobAdapter;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteCacheSnapshotManager;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.gridgain.grid.internal.processors.cache.database.SnapshotCompatibilityJob;
import org.gridgain.grid.internal.processors.cache.database.SnapshotTaskBase;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotUtils;
import org.gridgain.grid.persistentstore.SnapshotStatus;
import org.jetbrains.annotations.Nullable;

public class GetOngoingOperationTask
extends SnapshotTaskBase<Void, SnapshotStatus> {
    private static final long serialVersionUID = 0L;
    private static final IgniteProductVersion V2_SINCE = IgniteProductVersion.fromString((String)"2.1.5");
    @IgniteInstanceResource
    private Ignite ignite;

    @Nullable
    public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, @Nullable Void arg) throws IgniteException {
        HashMap<ComputeJobAdapter, ClusterNode> jobs = new HashMap<ComputeJobAdapter, ClusterNode>();
        ClusterNode crd = SnapshotUtils.getSnapshotCrd(AffinityTopologyVersion.NONE, ((IgniteEx)this.ignite).context().cache().context());
        if (crd == null) {
            throw new IgniteException((Throwable)new IllegalStateException("No server nodes"));
        }
        if (crd.version().compareToIgnoreTimestamp(V2_SINCE) < 0) {
            jobs.put(new GetOngoingOperationJob(), crd);
        } else {
            jobs.put(new GetOngoingOperationJobV2(), crd);
        }
        return jobs;
    }

    @Nullable
    public SnapshotStatus reduce(List<ComputeJobResult> results) throws IgniteException {
        assert (results.size() == 1) : results.size();
        ComputeJobResult computeJobRes = results.get(0);
        if (computeJobRes.getException() != null) {
            throw computeJobRes.getException();
        }
        Object data0 = computeJobRes.getData();
        try {
            if (data0 instanceof byte[]) {
                data0 = new JdkMarshaller().unmarshal((byte[])data0, U.resolveClassLoader((IgniteConfiguration)this.ignite.configuration()));
            }
            return (SnapshotStatus)data0;
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Failed to deserialize job execution result", (Throwable)e);
        }
    }

    private static SnapshotStatus getOngoingOperation(Ignite ignite) {
        IgniteCacheSnapshotManager snpMgr = ((IgniteEx)ignite).context().cache().context().snapshot();
        if (!(snpMgr instanceof GridCacheSnapshotManager)) {
            return null;
        }
        GridCacheSnapshotManager snapshotMgr = (GridCacheSnapshotManager)snpMgr;
        try {
            return snapshotMgr.getOngoingOperation();
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    @GridInternal
    private static class GetOngoingOperationJobV2
    extends SnapshotCompatibilityJob {
        private static final long serialVersionUID = 0L;
        @IgniteInstanceResource
        protected Ignite ignite;

        private GetOngoingOperationJobV2() {
        }

        @Override
        public Object executeCompatible() throws IgniteException {
            return GetOngoingOperationTask.getOngoingOperation(this.ignite);
        }
    }

    @GridInternal
    private static class GetOngoingOperationJob
    extends ComputeJobAdapter {
        private static final long serialVersionUID = 0L;
        @IgniteInstanceResource
        protected Ignite ignite;

        private GetOngoingOperationJob() {
        }

        public Object execute() throws IgniteException {
            return GetOngoingOperationTask.getOngoingOperation(this.ignite);
        }
    }
}

