/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.persistentstore.snapshot.file.remote;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.commons.vfs2.provider.sftp.SftpFileObject;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotRemotePath;
import org.gridgain.grid.internal.processors.cache.database.snapshot.sftp.InmemorySftpServerRule;
import org.gridgain.grid.persistentstore.SnapshotPath;
import org.gridgain.grid.persistentstore.snapshot.file.remote.SnapshotPathFactory;
import org.gridgain.grid.persistentstore.snapshot.file.remote.VFS2SnapshotPath;
import org.jetbrains.annotations.NotNull;
import org.junit.Rule;
import org.junit.Test;

public class VFS2SnapshotPathTest
extends GridCommonAbstractTest {
    private static final String LOGIN = "login";
    private static final String PASSWORD = "password";
    private static final String FILE_NAME = "test.idx";
    private static final String FOLDER = "/folder";
    private static final String FILE_ABSOLUTE_PATH = "/folder/test.idx";
    @Rule
    public InmemorySftpServerRule sftpRule = new InmemorySftpServerRule().addUser("login", "password");

    @Test
    public void existTest() throws IOException, URISyntaxException {
        String filePath = this.getSftpFilePath();
        org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath wrapper = SnapshotPathFactory.create((SnapshotRemotePath)this.createPath(filePath), null);
        VFS2SnapshotPathTest.assertFalse((boolean)this.sftpRule.fileExists(FILE_ABSOLUTE_PATH));
        VFS2SnapshotPathTest.assertFalse((boolean)wrapper.exists());
        wrapper.createNewFile();
        VFS2SnapshotPathTest.assertTrue((boolean)this.sftpRule.fileExists(FILE_ABSOLUTE_PATH));
        VFS2SnapshotPathTest.assertTrue((boolean)wrapper.exists());
    }

    @Test
    public void getParentTest() throws IOException, URISyntaxException {
        String filePath = this.getSftpFilePath();
        org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath wrapper = SnapshotPathFactory.create((SnapshotRemotePath)this.createPath(filePath), null);
        org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath folder0 = wrapper.getParent();
        VFS2SnapshotPathTest.assertFalse((boolean)this.sftpRule.fileExists(FOLDER));
        VFS2SnapshotPathTest.assertFalse((boolean)folder0.exists());
        folder0.createDirectories();
        VFS2SnapshotPathTest.assertTrue((boolean)this.sftpRule.fileExists(FOLDER));
        VFS2SnapshotPathTest.assertTrue((boolean)folder0.exists());
    }

    @Test
    public void deleteTest() throws IOException, URISyntaxException {
        String filePath = this.getSftpFilePath();
        org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath wrapper = SnapshotPathFactory.create((SnapshotRemotePath)this.createPath(filePath), null);
        wrapper.createNewFile();
        VFS2SnapshotPathTest.assertTrue((boolean)this.sftpRule.fileExists(FILE_ABSOLUTE_PATH));
        VFS2SnapshotPathTest.assertTrue((boolean)wrapper.delete());
        VFS2SnapshotPathTest.assertFalse((boolean)this.sftpRule.fileExists(FILE_ABSOLUTE_PATH));
        VFS2SnapshotPathTest.assertTrue((boolean)this.sftpRule.fileExists(FOLDER));
    }

    @Test
    public void deleteIfEmptyTest() throws IOException, URISyntaxException {
        String filePath = this.getSftpFilePath();
        org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath wrapper = SnapshotPathFactory.create((SnapshotRemotePath)this.createPath(filePath), null);
        wrapper.createNewFile();
        VFS2SnapshotPathTest.assertTrue((boolean)this.sftpRule.fileExists(FILE_ABSOLUTE_PATH));
        wrapper.getParent().deleteIfEmpty();
        VFS2SnapshotPathTest.assertTrue((boolean)this.sftpRule.fileExists(FILE_ABSOLUTE_PATH));
        wrapper.getParent().delete();
        VFS2SnapshotPathTest.assertFalse((boolean)this.sftpRule.fileExists(FOLDER));
    }

    @Test
    public void resolveTest() throws IOException, URISyntaxException {
        String filePath = this.getSftpFilePath();
        org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath wrapper = SnapshotPathFactory.create((SnapshotRemotePath)this.createPath(filePath), null);
        wrapper.createNewFile();
        VFS2SnapshotPathTest.assertTrue((boolean)this.sftpRule.fileExists(FILE_ABSOLUTE_PATH));
        org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath resolvedFile = wrapper.getParent().resolve(FILE_NAME);
        VFS2SnapshotPathTest.assertTrue((boolean)resolvedFile.exists());
    }

    @Test
    public void writeTest() throws IOException, URISyntaxException {
        String filePath = this.getSftpFilePath();
        org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath wrapper = SnapshotPathFactory.create((SnapshotRemotePath)this.createPath(filePath), null);
        byte[] data = filePath.getBytes();
        try (OutputStream outputStream = wrapper.outputStream();){
            outputStream.write(data);
        }
        VFS2SnapshotPath anotherInstance = (VFS2SnapshotPath)SnapshotPathFactory.create((SnapshotRemotePath)this.createPath(filePath), null);
        byte[] array = anotherInstance.getFileObject().getContent().getByteArray();
        VFS2SnapshotPathTest.assertEquals((String)filePath, (String)new String(array));
    }

    @Test
    public void parentIsResolvedCorrectlyTest() throws Exception {
        String filePath = this.getSftpFilePath();
        VFS2SnapshotPath wrapper = (VFS2SnapshotPath)SnapshotPathFactory.create((SnapshotRemotePath)this.createPath(filePath), null);
        wrapper.createNewFile();
        SftpFileObject obj = (SftpFileObject)wrapper.getFileObject();
        SftpFileObject parentFileObject = (SftpFileObject)obj.getParent();
        parentFileObject.close();
        SftpFileObject anotherParentFileObject = (SftpFileObject)obj.getParent();
        VFS2SnapshotPathTest.assertSame((Object)parentFileObject, (Object)anotherParentFileObject);
        VFS2SnapshotPathTest.assertTrue((boolean)anotherParentFileObject.isAttached());
    }

    @Test
    public void isFileOrDirectoryTest() throws IOException, URISyntaxException {
        String filePath = this.getSftpFilePath();
        org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath file = SnapshotPathFactory.create((SnapshotRemotePath)this.createPath(filePath), null);
        org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath folder = file.getParent();
        VFS2SnapshotPathTest.assertFalse((boolean)file.isDirectory());
        VFS2SnapshotPathTest.assertFalse((boolean)file.isFile());
        VFS2SnapshotPathTest.assertFalse((boolean)folder.isDirectory());
        VFS2SnapshotPathTest.assertFalse((boolean)folder.isFile());
        file.createNewFile();
        VFS2SnapshotPathTest.assertFalse((boolean)file.isDirectory());
        VFS2SnapshotPathTest.assertTrue((boolean)file.isFile());
        VFS2SnapshotPathTest.assertTrue((boolean)folder.isDirectory());
        VFS2SnapshotPathTest.assertFalse((boolean)folder.isFile());
    }

    @Test
    public void isEmptyOrNotDirectoryTest() throws IOException, URISyntaxException {
        String filePath = this.getSftpFilePath();
        org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath file = SnapshotPathFactory.create((SnapshotRemotePath)this.createPath(filePath), null);
        org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath folder = file.getParent();
        VFS2SnapshotPathTest.assertFalse((boolean)folder.isEmptyDirectory());
        folder.createDirectories();
        VFS2SnapshotPathTest.assertTrue((boolean)folder.isEmptyDirectory());
        file.createNewFile();
        VFS2SnapshotPathTest.assertFalse((boolean)folder.isEmptyDirectory());
        VFS2SnapshotPathTest.assertFalse((boolean)file.isEmptyDirectory());
    }

    @Test
    public void getEntriesTest() throws IOException, URISyntaxException {
        String filePath = this.getSftpFilePath();
        org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath file = SnapshotPathFactory.create((SnapshotRemotePath)this.createPath(filePath), null);
        org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath folder = file.getParent();
        VFS2SnapshotPathTest.assertTrue((boolean)file.getEntries().isEmpty());
        VFS2SnapshotPathTest.assertTrue((boolean)folder.getEntries().isEmpty());
        file.createNewFile();
        VFS2SnapshotPathTest.assertEquals((int)1, (int)folder.getEntries().size());
        org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath firstInnerFolder = folder.resolve("innerEmptyFolder");
        firstInnerFolder.createDirectories();
        org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath secondInnerFolder = folder.resolve("innerSecondFolderWithFiles");
        secondInnerFolder.resolve("test1.tmp").createNewFile();
        secondInnerFolder.resolve("test2.tmp").createNewFile();
        VFS2SnapshotPathTest.assertEquals((int)3, (int)folder.getEntries().size());
        VFS2SnapshotPathTest.assertEqualsCollections(Arrays.asList(file.getAbsolutePath(), secondInnerFolder.getAbsolutePath(), firstInnerFolder.getAbsolutePath()), (Collection)folder.getEntries().stream().map(f -> f.getAbsolutePath()).collect(Collectors.toList()));
    }

    @NotNull
    private String getSftpFilePath() {
        return "sftp://login:password@127.0.0.1:" + this.sftpRule.getPort() + FILE_ABSOLUTE_PATH;
    }

    @NotNull
    private SnapshotRemotePath createPath(String filePath) throws URISyntaxException {
        return new SnapshotRemotePath(SnapshotPath.sftp().uri(new URI(filePath)).build());
    }
}

