/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.persistentstore.snapshot.file;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import junit.framework.TestCase;
import org.apache.ignite.IgniteCheckedException;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOutputStreamListener;
import org.gridgain.grid.persistentstore.snapshot.file.FileSnapshotOutputStream;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class FileSnapshotOutputStreamTest
extends TestCase {
    public void testClose() throws IOException, IgniteCheckedException {
        File tempFile = File.createTempFile("testClose", "FileSnapshotOutputStreamTest");
        tempFile.deleteOnExit();
        FileChannel fileChannel = FileChannel.open(tempFile.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
        FileSnapshotOutputStreamTest.assertTrue((boolean)fileChannel.isOpen());
        SnapshotOutputStreamListener mockListener = (SnapshotOutputStreamListener)Mockito.mock(SnapshotOutputStreamListener.class);
        FileSnapshotOutputStream ignored = new FileSnapshotOutputStream(fileChannel, mockListener);
        Throwable throwable = null;
        if (ignored != null) {
            if (throwable != null) {
                try {
                    ignored.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                ignored.close();
            }
        }
        FileSnapshotOutputStreamTest.assertFalse((boolean)fileChannel.isOpen());
        ((SnapshotOutputStreamListener)Mockito.verify((Object)mockListener, (VerificationMode)Mockito.times((int)1))).onClose();
    }
}

