/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.persistentstore.snapshot.file;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Paths;
import junit.framework.TestCase;
import org.apache.ignite.IgniteException;
import org.gridgain.TestUtils;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotInputStream;
import org.gridgain.grid.persistentstore.snapshot.file.FileSnapshotInputStream;

public class FileSnapshotInputStreamTest
extends TestCase {
    private static final int PAGE_SIZE = 4096;

    private ByteBuffer prepareBuf() {
        ByteBuffer buf = ByteBuffer.allocate(4096);
        buf.order(ByteOrder.nativeOrder());
        return buf;
    }

    public void testValidZipFile() {
        File validZipFile = Paths.get(TestUtils.TEST_ROOT, "snapshot/index.bin").toFile();
        try (SnapshotInputStream stream = FileSnapshotInputStream.of((File)validZipFile, (int)0, (int)4096, (String)"1", (boolean)false);){
            FileSnapshotInputStreamTest.assertTrue((boolean)stream.readNextPage(this.prepareBuf()));
        }
        catch (Exception e) {
            FileSnapshotInputStreamTest.fail((String)e.getMessage());
        }
    }

    public void testValidUncompressedFile() {
        File uncompressedFile = Paths.get(TestUtils.TEST_ROOT, "snapshot/part-1.bin").toFile();
        try (SnapshotInputStream stream = FileSnapshotInputStream.of((File)uncompressedFile, (int)0, (int)4096, (String)"1", (boolean)false);){
            FileSnapshotInputStreamTest.assertTrue((boolean)stream.readNextPage(this.prepareBuf()));
        }
        catch (Exception e) {
            FileSnapshotInputStreamTest.fail((String)e.getMessage());
        }
    }

    public void testInvalidZipFile() {
        File invalidZipFile = Paths.get(TestUtils.TEST_ROOT, "snapshot/notreallyazip").toFile();
        try {
            FileSnapshotInputStream.of((File)invalidZipFile, (int)0, (int)4096, (String)"1", (boolean)false);
            FileSnapshotInputStreamTest.fail();
        }
        catch (IgniteException igniteException) {
            // empty catch block
        }
    }

    public void testValidZipFileHasInvalidEntry() {
        File invalidZipFile = Paths.get(TestUtils.TEST_ROOT, "snapshot/validhasinvalidentry").toFile();
        try {
            FileSnapshotInputStream.of((File)invalidZipFile, (int)0, (int)4096, (String)"1", (boolean)false);
            FileSnapshotInputStreamTest.fail();
        }
        catch (IgniteException e) {
            FileSnapshotInputStreamTest.assertTrue((boolean)e.getMessage().contains("is corrupted!"));
        }
    }

    public void testNonExistentFile() {
        File invalidZipFile = Paths.get(TestUtils.TEST_ROOT, "snapshot/nonexistentfile").toFile();
        FileSnapshotInputStreamTest.assertNull((Object)FileSnapshotInputStream.of((File)invalidZipFile, (int)0, (int)4096, (String)"1", (boolean)false));
    }
}

