/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.persistentstore.snapshot.file;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.ignite.internal.encryption.AbstractEncryptionTest;
import org.apache.ignite.internal.managers.encryption.GroupKey;
import org.apache.ignite.spi.encryption.EncryptionSpi;
import org.apache.ignite.spi.encryption.keystore.KeystoreEncryptionSpi;
import org.apache.ignite.testframework.GridTestUtils;
import org.gridgain.grid.internal.io.DecryptionReadableChannel;
import org.gridgain.grid.internal.io.GridReadableByteChannel;
import org.gridgain.grid.internal.io.SnapshotReadableByteChannel;
import org.gridgain.grid.persistentstore.snapshot.file.EncryptedOutputStream;
import org.junit.Assert;
import org.junit.Test;

public class EncryptedOutputStreamTest {
    @Test
    public void testEncryptedOutputStream() throws Exception {
        int pageSize = 4096;
        EncryptionSpi spi = this.spi();
        GroupKey encryptionKey = new GroupKey(1, spi.create());
        for (int size = 10 * pageSize; size < 11 * pageSize; ++size) {
            byte[] originalPayload = new byte[size];
            ThreadLocalRandom.current().nextBytes(originalPayload);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try (EncryptedOutputStream out = new EncryptedOutputStream((OutputStream)byteArrayOutputStream, encryptionKey, spi, pageSize);){
                out.write(originalPayload);
            }
            byte[] encryptedData = byteArrayOutputStream.toByteArray();
            ByteBuffer decryptedData = ByteBuffer.allocate(size * 2);
            try (DecryptionReadableChannel snapshotReadableByteChannel = new DecryptionReadableChannel((SnapshotReadableByteChannel)new GridReadableByteChannel((InputStream)new ByteArrayInputStream(encryptedData)), encryptionKey, spi, pageSize, false);){
                while (snapshotReadableByteChannel.read(decryptedData) != -1) {
                }
            }
            Assert.assertEquals((long)size, (long)decryptedData.position());
            decryptedData.flip();
            Assert.assertEquals((Object)ByteBuffer.wrap(originalPayload), (Object)decryptedData);
        }
    }

    private EncryptionSpi spi() throws Exception {
        KeystoreEncryptionSpi encSpi = new KeystoreEncryptionSpi();
        encSpi.setKeyStorePath(AbstractEncryptionTest.KEYSTORE_PATH);
        encSpi.setKeyStorePassword("tde-password".toCharArray());
        GridTestUtils.invoke((Object)encSpi, (String)"onBeforeStart", (Object[])new Object[0]);
        encSpi.spiStart("default");
        return encSpi;
    }
}

