/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.txdr;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteEvents;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.Event;
import org.apache.ignite.events.WalSegmentArchivedEvent;
import org.apache.ignite.events.WalSegmentCompactedEvent;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.pagemem.wal.WALIterator;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.pagemem.wal.record.RolloverType;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.StorageException;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileDescriptor;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.testframework.GridTestNode;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.apache.ignite.thread.IgniteThread;
import org.gridgain.grid.internal.processors.cache.database.txdr.WalSender;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class WalSenderTest
extends GridCommonAbstractTest {
    private static final Path WAL_ARCHIVE_DIR = Paths.get(System.getProperty("java.io.tmpdir"), "_wal_" + UUID.randomUUID().toString());
    private static final Path TRANSFER_DIR = Paths.get(System.getProperty("java.io.tmpdir"), "_tf_" + UUID.randomUUID().toString());
    private PhonyEvents evts;
    private PhonyWALManager walMgr;

    public void beforeTest() throws Exception {
        this.deleteTree(TRANSFER_DIR);
        this.deleteTree(WAL_ARCHIVE_DIR);
        Files.createDirectory(TRANSFER_DIR, new FileAttribute[0]);
        Files.createDirectory(WAL_ARCHIVE_DIR, new FileAttribute[0]);
        this.evts = new PhonyEvents();
        this.walMgr = new PhonyWALManager(WAL_ARCHIVE_DIR.toFile(), this.evts);
    }

    public void afterTest() throws Exception {
        this.walMgr.close();
        this.walMgr = null;
        this.evts = null;
        this.deleteTree(TRANSFER_DIR);
        this.deleteTree(WAL_ARCHIVE_DIR);
    }

    @Test
    public void testNormalSending() throws Exception {
        WalSender walSnd = new WalSender("test-ignite", log, (IgniteWriteAheadLogManager)this.walMgr, (IgniteEvents)this.evts, WAL_ARCHIVE_DIR.toFile(), TRANSFER_DIR.toFile(), null, null, true);
        IgniteThread walSndThread = new IgniteThread((GridWorker)walSnd);
        try {
            walSndThread.start();
            Assert.assertTrue((boolean)walSnd.startSending(0L));
            walSnd.stopSending(4L).get();
            Assert.assertTrue((boolean)this.transferredSegmentsMatch(0, 1, 2, 3, 4));
            U.sleep((long)3000L);
            Assert.assertTrue((boolean)this.transferredSegmentsMatch(0, 1, 2, 3, 4));
        }
        finally {
            walSnd.cancel();
            walSndThread.join();
        }
    }

    @Test
    public void testIntermittentSending() throws Exception {
        WalSender walSnd = new WalSender("test-ignite", log, (IgniteWriteAheadLogManager)this.walMgr, (IgniteEvents)this.evts, WAL_ARCHIVE_DIR.toFile(), TRANSFER_DIR.toFile(), null, null, true);
        IgniteThread walSndThread = new IgniteThread((GridWorker)walSnd);
        try {
            walSndThread.start();
            Assert.assertTrue((boolean)walSnd.startSending(0L));
            walSnd.stopSending(2L).get();
            Assert.assertTrue((boolean)this.transferredSegmentsMatch(0, 1, 2));
            Assert.assertTrue((boolean)walSnd.startSending(5L));
            walSnd.stopSending(7L).get();
            Assert.assertTrue((boolean)this.transferredSegmentsMatch(0, 1, 2, 5, 6, 7));
            Assert.assertTrue((boolean)walSnd.startSending(9L));
            walSnd.stopSending(10L).get();
            Assert.assertTrue((boolean)this.transferredSegmentsMatch(0, 1, 2, 5, 6, 7, 9, 10));
        }
        finally {
            walSnd.cancel();
            walSndThread.join();
        }
    }

    @Test
    public void testIntermittentSendingOlderFirst() throws Exception {
        WalSender walSnd = new WalSender("test-ignite", log, (IgniteWriteAheadLogManager)this.walMgr, (IgniteEvents)this.evts, WAL_ARCHIVE_DIR.toFile(), TRANSFER_DIR.toFile(), null, null, true);
        IgniteThread walSndThread = new IgniteThread((GridWorker)walSnd);
        try {
            walSndThread.start();
            Assert.assertTrue((boolean)walSnd.startSending(5L));
            walSnd.stopSending(7L).get();
            Assert.assertTrue((boolean)this.transferredSegmentsMatch(5, 6, 7));
            Assert.assertTrue((boolean)walSnd.startSending(0L));
            walSnd.stopSending(2L).get();
            Assert.assertTrue((boolean)this.transferredSegmentsMatch(0, 1, 2, 5, 6, 7));
        }
        finally {
            walSnd.cancel();
            walSndThread.join();
        }
    }

    @Test
    public void testSegmentSentCallback() throws Exception {
        WalSender walSnd = new WalSender("test-ignite", log, (IgniteWriteAheadLogManager)this.walMgr, (IgniteEvents)this.evts, WAL_ARCHIVE_DIR.toFile(), TRANSFER_DIR.toFile(), null, null, true);
        IgniteThread walSndThread = new IgniteThread((GridWorker)walSnd);
        try {
            walSndThread.start();
            walSnd.startSending(2L);
            walSnd.stopSending(3L).get();
            walSnd.startSending(5L);
            walSnd.stopSending(6L).get();
        }
        finally {
            walSnd.cancel();
            walSndThread.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIndexInversion() throws Exception {
        WalSender walSnd = new WalSender("test-ignite", log, (IgniteWriteAheadLogManager)this.walMgr, (IgniteEvents)this.evts, WAL_ARCHIVE_DIR.toFile(), TRANSFER_DIR.toFile(), null, null, true);
        IgniteThread walSndThread = new IgniteThread((GridWorker)walSnd);
        try {
            walSndThread.start();
            U.sleep((long)5000L);
            Assert.assertTrue((boolean)walSnd.startSending(3L));
            try {
                walSnd.stopSending(1L).get();
                Assert.fail();
            }
            catch (IgniteCheckedException igniteCheckedException) {
                // empty catch block
            }
        }
        finally {
            walSnd.cancel();
            walSndThread.join();
        }
    }

    @Test
    public void testRepeatedSend() throws Exception {
        WalSender walSnd = new WalSender("test-ignite", log, (IgniteWriteAheadLogManager)this.walMgr, (IgniteEvents)this.evts, WAL_ARCHIVE_DIR.toFile(), TRANSFER_DIR.toFile(), null, null, true);
        IgniteThread walSndThread = new IgniteThread((GridWorker)walSnd);
        try {
            walSndThread.start();
            Assert.assertTrue((boolean)walSnd.startSending(0L));
            walSnd.stopSending(1L).get();
            Assert.assertTrue((boolean)this.transferredSegmentsMatch(0, 1));
            Assert.assertTrue((boolean)walSnd.startSending(0L));
            walSnd.stopSending(1L).get();
            Assert.assertTrue((boolean)this.transferredSegmentsMatch(0, 1));
        }
        finally {
            walSnd.cancel();
            walSndThread.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore(value="https://ggsystems.atlassian.net/browse/TDR-218")
    public void testFailureOnLeakedArchive() throws Exception {
        WalSender walSnd = new WalSender("test-ignite", log, (IgniteWriteAheadLogManager)this.walMgr, (IgniteEvents)this.evts, WAL_ARCHIVE_DIR.toFile(), TRANSFER_DIR.toFile(), null, null, true);
        IgniteThread walSndThread = new IgniteThread((GridWorker)walSnd);
        try {
            walSndThread.start();
            U.sleep((long)12000L);
            Assert.assertTrue((boolean)walSnd.startSending(0L));
            try {
                walSnd.stopSending(100500L).get();
                Assert.fail();
            }
            catch (IgniteCheckedException e) {
                Assert.assertTrue((boolean)X.hasCause((Throwable)e.getCause(), (Class[])new Class[]{IgniteException.class, IllegalStateException.class}));
            }
        }
        finally {
            walSnd.cancel();
            walSndThread.join();
        }
    }

    @Test
    public void testDuplicateStart() throws Exception {
        WalSender walSnd = new WalSender("test-ignite", log, (IgniteWriteAheadLogManager)this.walMgr, (IgniteEvents)this.evts, WAL_ARCHIVE_DIR.toFile(), TRANSFER_DIR.toFile(), null, null, true);
        IgniteThread walSndThread = new IgniteThread((GridWorker)walSnd);
        try {
            walSndThread.start();
            Assert.assertTrue((boolean)walSnd.startSending(0L));
            Assert.assertFalse((boolean)walSnd.startSending(0L));
            Assert.assertFalse((boolean)walSnd.startSending(1L));
            Assert.assertFalse((boolean)walSnd.startSending(85L));
        }
        finally {
            walSnd.cancel();
            walSndThread.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStopNotStarted() throws Exception {
        WalSender walSnd = new WalSender("test-ignite", log, (IgniteWriteAheadLogManager)this.walMgr, (IgniteEvents)this.evts, WAL_ARCHIVE_DIR.toFile(), TRANSFER_DIR.toFile(), null, null, true);
        IgniteThread walSndThread = new IgniteThread((GridWorker)walSnd);
        try {
            walSndThread.start();
            walSnd.stopSending(0L).get();
        }
        catch (IgniteCheckedException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IllegalStateException));
        }
        finally {
            walSnd.cancel();
            walSndThread.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDuplicateStop() throws Exception {
        WalSender walSnd = new WalSender("test-ignite", log, (IgniteWriteAheadLogManager)this.walMgr, (IgniteEvents)this.evts, WAL_ARCHIVE_DIR.toFile(), TRANSFER_DIR.toFile(), null, null, true);
        IgniteThread walSndThread = new IgniteThread((GridWorker)walSnd);
        try {
            walSndThread.start();
            Assert.assertTrue((boolean)walSnd.startSending(0L));
            walSnd.stopSending(100500L);
            try {
                walSnd.stopSending(0L).get();
            }
            catch (IgniteCheckedException e) {
                Assert.assertTrue((boolean)(e.getCause() instanceof IllegalStateException));
            }
        }
        finally {
            walSnd.cancel();
            walSndThread.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInstantStop() throws Exception {
        WalSender walSnd = new WalSender("test-ignite", log, (IgniteWriteAheadLogManager)this.walMgr, (IgniteEvents)this.evts, WAL_ARCHIVE_DIR.toFile(), TRANSFER_DIR.toFile(), null, null, true);
        IgniteThread walSndThread = new IgniteThread((GridWorker)walSnd);
        try {
            walSndThread.start();
            Assert.assertTrue((boolean)walSnd.startSending(0L));
            U.sleep((long)3000L);
            walSnd.stopSending().get();
            long n = WalSenderTest.totalFilesTransferred();
            U.sleep((long)3000L);
            Assert.assertEquals((long)n, (long)WalSenderTest.totalFilesTransferred());
        }
        finally {
            walSnd.cancel();
            walSndThread.join();
        }
    }

    private static long totalFilesTransferred() throws IOException {
        try (Stream<Path> files = Files.list(TRANSFER_DIR);){
            long l = files.count();
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDuplicateInstantStop() throws Exception {
        WalSender walSnd = new WalSender("test-ignite", log, (IgniteWriteAheadLogManager)this.walMgr, (IgniteEvents)this.evts, WAL_ARCHIVE_DIR.toFile(), TRANSFER_DIR.toFile(), null, null, true);
        IgniteThread walSndThread = new IgniteThread((GridWorker)walSnd);
        try {
            walSndThread.start();
            Assert.assertTrue((boolean)walSnd.startSending(0L));
            U.sleep((long)3000L);
            walSnd.stopSending().get();
            try {
                walSnd.stopSending().get();
                Assert.fail();
            }
            catch (IgniteCheckedException e) {
                Assert.assertTrue((boolean)(e.getCause() instanceof IllegalStateException));
            }
        }
        finally {
            walSnd.cancel();
            walSndThread.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStopFutureListenerFailure() throws Exception {
        this.afterTest();
        Files.createDirectory(TRANSFER_DIR, new FileAttribute[0]);
        Files.createDirectory(WAL_ARCHIVE_DIR, new FileAttribute[0]);
        CountDownLatch latch = new CountDownLatch(1);
        this.evts = new PhonyEvents();
        this.evts.localListen((IgnitePredicate<? extends Event>)(IgnitePredicate & Serializable)evt -> {
            boolean fail;
            try {
                fail = !latch.await(15L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                fail = true;
            }
            if (fail) {
                WalSenderTest.fail((String)"Could not wait for the count reached zero value.");
            }
            return true;
        }, new int[0]);
        this.walMgr = new PhonyWALManager(WAL_ARCHIVE_DIR.toFile(), this.evts);
        WalSender walSnd = new WalSender("test-ignite", log, (IgniteWriteAheadLogManager)this.walMgr, (IgniteEvents)this.evts, WAL_ARCHIVE_DIR.toFile(), TRANSFER_DIR.toFile(), null, null, true);
        IgniteThread walSndThread = new IgniteThread((GridWorker)walSnd);
        try {
            walSndThread.start();
            Assert.assertTrue((boolean)walSnd.startSending(0L));
            GridFutureAdapter fut = walSnd.stopSending(0L);
            fut.listen((IgniteInClosure & Serializable)f -> {
                throw new RuntimeException("This should not break the sender.");
            });
            latch.countDown();
            fut.get();
            Assert.assertTrue((boolean)walSnd.startSending(1L));
            walSnd.stopSending(1L).get();
            Assert.assertTrue((boolean)this.transferredSegmentsMatch(0, 1));
        }
        finally {
            walSnd.cancel();
            walSndThread.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore(value="https://ggsystems.atlassian.net/browse/TDR-218")
    public void testTransferDirectoryOutage() throws Exception {
        WalSender walSnd = new WalSender("test-ignite", log, (IgniteWriteAheadLogManager)this.walMgr, (IgniteEvents)this.evts, WAL_ARCHIVE_DIR.toFile(), TRANSFER_DIR.toFile(), null, null, true);
        IgniteThread walSndThread = new IgniteThread((GridWorker)walSnd);
        try {
            walSndThread.start();
            Assert.assertTrue((boolean)walSnd.startSending(0L));
            Assert.assertTrue((boolean)this.waitForFileInTransferDir(FileDescriptor.fileName((long)0L) + ".zip", 2000L));
            Path renamedTD = TRANSFER_DIR.getParent().resolve(Paths.get(TRANSFER_DIR.toFile().getName() + "_x_", new String[0]));
            try {
                Files.move(TRANSFER_DIR, renamedTD, new CopyOption[0]);
                U.sleep((long)3050L);
                Files.move(renamedTD, TRANSFER_DIR, new CopyOption[0]);
            }
            finally {
                this.deleteTree(renamedTD);
            }
            walSnd.stopSending(4L).get();
            Assert.assertTrue((boolean)this.transferredSegmentsMatch(0, 1, 2, 3, 4));
        }
        finally {
            walSnd.cancel();
            walSndThread.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSenderDeathAfterLongTransferDirectoryOutage() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.evts.localListen((IgnitePredicate<? extends Event>)(IgnitePredicate & Serializable)evt -> {
            latch.countDown();
            return true;
        }, new int[0]);
        WalSender walSnd = new WalSender("test-ignite", log, (IgniteWriteAheadLogManager)this.walMgr, (IgniteEvents)this.evts, WAL_ARCHIVE_DIR.toFile(), TRANSFER_DIR.toFile(), null, null, true);
        IgniteThread walSndThread = new IgniteThread((GridWorker)walSnd);
        try {
            walSndThread.start();
            Assert.assertTrue((boolean)walSnd.startSending(0L));
            WalSenderTest.assertTrue((boolean)latch.await(2000L, TimeUnit.MILLISECONDS));
            Path renamedTD = TRANSFER_DIR.getParent().resolve(Paths.get(TRANSFER_DIR.toFile().getName() + "_x_", new String[0]));
            try {
                Files.move(TRANSFER_DIR, renamedTD, new CopyOption[0]);
                U.sleep((long)13000L);
                Files.move(renamedTD, TRANSFER_DIR, new CopyOption[0]);
            }
            finally {
                this.deleteTree(renamedTD);
            }
            try {
                walSnd.stopSending(1L).get();
                Assert.fail();
            }
            catch (IgniteCheckedException igniteCheckedException) {
                // empty catch block
            }
            long idx = this.walMgr.lastCompactedSegment();
            walSnd.startSending(idx);
            U.sleep((long)2000L);
            Assert.assertFalse((boolean)walSndThread.isAlive());
        }
        finally {
            walSnd.cancel();
            walSndThread.join();
        }
    }

    private boolean waitForFileInTransferDir(String name, long timeout) throws IOException, InterruptedException {
        File expFile = TRANSFER_DIR.resolve(name).toFile();
        if (expFile.exists()) {
            return true;
        }
        try (WatchService ws = TRANSFER_DIR.getFileSystem().newWatchService();){
            long remained;
            TRANSFER_DIR.register(ws, StandardWatchEventKinds.ENTRY_CREATE);
            long startedAt = U.currentTimeMillis();
            while ((remained = timeout - (U.currentTimeMillis() - startedAt)) > 0L) {
                WatchKey key = ws.poll(remained, TimeUnit.MILLISECONDS);
                if (key == null) {
                    if (!expFile.exists()) continue;
                    boolean bl = true;
                    return bl;
                }
                if (key.pollEvents().stream().filter(e -> e.kind() == StandardWatchEventKinds.ENTRY_CREATE).map(WatchEvent::context).filter(c -> c instanceof Path).anyMatch(p -> ((Path)p).toFile().getName().equals(name))) {
                    boolean bl = true;
                    return bl;
                }
                Assert.assertTrue((boolean)key.reset());
            }
            boolean bl = false;
            return bl;
        }
    }

    private boolean transferredSegmentsMatch(Integer ... indices) throws IOException {
        Set exp = Arrays.stream(indices).map(i -> FileDescriptor.fileName((long)i.intValue()) + ".zip").collect(Collectors.toSet());
        try (Stream<Path> files = Files.list(TRANSFER_DIR);){
            Set act = files.map(Path::toFile).map(File::getName).collect(Collectors.toSet());
            boolean bl = act.containsAll(exp) && exp.containsAll(act);
            return bl;
        }
    }

    private void deleteTree(Path root) throws IOException {
        if (Files.exists(root, new LinkOption[0])) {
            Files.walk(root, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
    }

    private static class PhonyEvents
    implements IgniteEvents {
        private final Set<IgnitePredicate<WalSegmentArchivedEvent>> lsnrs = new LinkedHashSet<IgnitePredicate<WalSegmentArchivedEvent>>();

        private PhonyEvents() {
        }

        private synchronized void notifyListeners(WalSegmentArchivedEvent evt) {
            for (IgnitePredicate<WalSegmentArchivedEvent> lsnr : this.lsnrs) {
                lsnr.apply((Object)evt);
            }
        }

        public ClusterGroup clusterGroup() {
            throw new IgniteException("Not implemented.");
        }

        public <T extends Event> List<T> remoteQuery(IgnitePredicate<T> p, long timeout, int ... types) throws IgniteException {
            throw new IgniteException("Not implemented.");
        }

        public <T extends Event> IgniteFuture<List<T>> remoteQueryAsync(IgnitePredicate<T> p, long timeout, int ... types) throws IgniteException {
            throw new IgniteException("Not implemented.");
        }

        public <T extends Event> UUID remoteListen(@Nullable IgniteBiPredicate<UUID, T> locLsnr, @Nullable IgnitePredicate<T> rmtFilter, int ... types) throws IgniteException {
            throw new IgniteException("Not implemented.");
        }

        public <T extends Event> IgniteFuture<UUID> remoteListenAsync(@Nullable IgniteBiPredicate<UUID, T> locLsnr, @Nullable IgnitePredicate<T> rmtFilter, int ... types) throws IgniteException {
            throw new IgniteException("Not implemented.");
        }

        public <T extends Event> UUID remoteListen(int bufSize, long interval, boolean autoUnsubscribe, @Nullable IgniteBiPredicate<UUID, T> locLsnr, @Nullable IgnitePredicate<T> rmtFilter, int ... types) throws IgniteException {
            throw new IgniteException("Not implemented.");
        }

        public <T extends Event> IgniteFuture<UUID> remoteListenAsync(int bufSize, long interval, boolean autoUnsubscribe, @Nullable IgniteBiPredicate<UUID, T> locLsnr, @Nullable IgnitePredicate<T> rmtFilter, int ... types) throws IgniteException {
            throw new IgniteException("Not implemented.");
        }

        public void stopRemoteListen(UUID opId) throws IgniteException {
            throw new IgniteException("Not implemented.");
        }

        public IgniteFuture<Void> stopRemoteListenAsync(UUID opId) throws IgniteException {
            throw new IgniteException("Not implemented.");
        }

        public <T extends Event> T waitForLocal(@Nullable IgnitePredicate<T> filter, int ... types) throws IgniteException {
            throw new IgniteException("Not implemented.");
        }

        public <T extends Event> IgniteFuture<T> waitForLocalAsync(@Nullable IgnitePredicate<T> filter, int ... types) throws IgniteException {
            throw new IgniteException("Not implemented.");
        }

        public <T extends Event> Collection<T> localQuery(IgnitePredicate<T> p, int ... types) {
            throw new IgniteException("Not implemented.");
        }

        public void recordLocal(Event evt) {
            throw new IgniteException("Not implemented.");
        }

        public synchronized void localListen(IgnitePredicate<? extends Event> lsnr, int ... types) {
            this.lsnrs.add(lsnr);
        }

        public synchronized boolean stopLocalListen(IgnitePredicate<? extends Event> lsnr, int ... types) {
            this.lsnrs.remove(lsnr);
            return true;
        }

        public void enableLocal(int ... types) {
            throw new IgniteException("Not implemented.");
        }

        public void disableLocal(int ... types) {
            throw new IgniteException("Not implemented.");
        }

        public int[] enabledEvents() {
            throw new IgniteException("Not implemented.");
        }

        public boolean isEnabled(int type) {
            throw new IgniteException("Not implemented.");
        }

        public IgniteEvents withAsync() {
            throw new IgniteException("Not implemented.");
        }

        public boolean isAsync() {
            throw new IgniteException("Not implemented.");
        }

        public <R> IgniteFuture<R> future() {
            throw new IgniteException("Not implemented.");
        }
    }

    private class PhonyWALManager
    implements IgniteWriteAheadLogManager,
    AutoCloseable {
        static final int SEG_CREATION_INTERVAL_MS = 1000;
        static final int SEG_TTL_MS = 10000;
        private final File archiveDir;
        private long lastCompactedIdx = -1L;
        private long lastDeletedIdx = -1L;
        private NavigableSet<Long> reservations = new TreeSet<Long>();
        private final Thread worker;

        PhonyWALManager(final File archiveDir, final PhonyEvents evts) {
            this.archiveDir = archiveDir;
            this.worker = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        PhonyWALManager.this.cleanArchiveDir();
                        while (!this.isInterrupted()) {
                            PhonyWALManager phonyWALManager = PhonyWALManager.this;
                            synchronized (phonyWALManager) {
                                PhonyWALManager.this.lastCompactedIdx++;
                                String archiveFileName = FileDescriptor.fileName((long)PhonyWALManager.this.lastCompactedIdx) + ".zip";
                                Path archiveFile = archiveDir.toPath().resolve(archiveFileName);
                                try (FileOutputStream os = new FileOutputStream(archiveFile.toFile());){
                                    os.write(String.valueOf(PhonyWALManager.this.lastCompactedIdx).getBytes(StandardCharsets.US_ASCII));
                                    os.getChannel().force(true);
                                    os.getFD().sync();
                                }
                                evts.notifyListeners((WalSegmentArchivedEvent)new WalSegmentCompactedEvent((ClusterNode)new GridTestNode(), PhonyWALManager.this.lastCompactedIdx, archiveFile.toFile()));
                                long d = PhonyWALManager.this.lastDeletedIdx + 1L;
                                while (PhonyWALManager.this.obsolete(d) && !PhonyWALManager.this.reserved(d)) {
                                    Files.delete(archiveDir.toPath().resolve(FileDescriptor.fileName((long)d) + ".zip"));
                                    ++d;
                                    PhonyWALManager.this.lastDeletedIdx++;
                                }
                            }
                            try {
                                U.sleep((long)1000L);
                            }
                            catch (IgniteInterruptedCheckedException e) {
                                Thread.currentThread().interrupt();
                            }
                        }
                    }
                    catch (IOException e) {
                        log.error("IOException in PhonyWALManager", (Throwable)e);
                    }
                }
            };
            this.worker.start();
        }

        @Override
        public void close() {
            this.worker.interrupt();
            try {
                this.worker.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void onKernalStart(boolean active) {
        }

        private void cleanArchiveDir() {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.archiveDir.toPath());){
                for (Path p : stream) {
                    Files.delete(p);
                }
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }

        private synchronized boolean obsolete(long idx) {
            return (this.lastCompactedIdx - idx) * 1000L > 10000L;
        }

        private synchronized boolean reserve(long idx) {
            if (idx <= this.lastDeletedIdx) {
                return false;
            }
            this.reservations.add(idx);
            return true;
        }

        private synchronized void release(long idx) {
            this.reservations.remove(idx);
        }

        private synchronized boolean reserved(long idx) {
            return this.reservations.floor(idx) != null;
        }

        public boolean isAlwaysWriteFullPages() {
            throw new IgniteException("Not implemented.");
        }

        public boolean isFullSync() {
            throw new IgniteException("Not implemented.");
        }

        public int serializerVersion() {
            throw new IgniteException("Not implemented.");
        }

        public void resumeLogging(WALPointer lastWrittenPtr) {
            throw new IgniteException("Not implemented.");
        }

        public WALPointer log(WALRecord entry) {
            throw new IgniteException("Not implemented.");
        }

        public WALPointer log(WALRecord entry, RolloverType rolloverType) throws IgniteCheckedException, StorageException {
            throw new IgniteException("Not implemented.");
        }

        public WALPointer flush(WALPointer ptr, boolean explicitFsync) {
            throw new IgniteException("Not implemented.");
        }

        public WALRecord read(WALPointer ptr) throws IgniteCheckedException {
            throw new IgniteException("Not implemented.");
        }

        public WALIterator replay(WALPointer start) {
            throw new IgniteException("Not implemented.");
        }

        public WALIterator replay(WALPointer start, @Nullable IgniteBiPredicate<WALRecord.RecordType, WALPointer> recordDeserializeFilter) throws IgniteCheckedException, StorageException {
            throw new IgniteException("Not implemented.");
        }

        public boolean reserve(WALPointer start) {
            return this.reserve(this.asFileWALPointer(start).index());
        }

        public void release(WALPointer start) {
            this.release(this.asFileWALPointer(start).index());
        }

        public int truncate(@Nullable WALPointer high) {
            throw new IgniteException("Not implemented.");
        }

        public void notchLastCheckpointPtr(WALPointer ptr) {
            throw new IgniteException("Not implemented.");
        }

        public long currentSegment() {
            return 0L;
        }

        public int walArchiveSegments() {
            throw new IgniteException("Not implemented.");
        }

        public long lastArchivedSegment() {
            return -1L;
        }

        public synchronized long lastCompactedSegment() {
            return this.lastCompactedIdx;
        }

        public boolean reserved(WALPointer ptr) {
            return this.reserved(this.asFileWALPointer(ptr).index());
        }

        public int reserved(WALPointer low, WALPointer high) {
            throw new IgniteException("Not implemented.");
        }

        public boolean disabled(int grpId) {
            throw new IgniteException("Not implemented.");
        }

        public void start(GridCacheSharedContext cctx) {
            throw new IgniteException("Not implemented.");
        }

        public void stop(boolean cancel) {
            throw new IgniteException("Not implemented.");
        }

        public void onKernalStop(boolean cancel) {
            throw new IgniteException("Not implemented.");
        }

        public void onReconnected(boolean active) {
            throw new IgniteException("Not implemented.");
        }

        public void printMemoryStats() {
            throw new IgniteException("Not implemented.");
        }

        public void onDisconnected(IgniteFuture reconnectFut) {
            throw new IgniteException("Not implemented.");
        }

        public void onActivate(GridKernalContext kctx) {
            throw new IgniteException("Not implemented.");
        }

        public void onDeActivate(GridKernalContext kctx) {
            throw new IgniteException("Not implemented.");
        }

        private FileWALPointer asFileWALPointer(WALPointer ptr) {
            if (!(ptr instanceof FileWALPointer)) {
                throw new IgniteException("Unexpected WALPointer [class=" + ptr.getClass() + ']');
            }
            return (FileWALPointer)ptr;
        }

        public long segmentSize(long idx) {
            throw new IllegalStateException("Not implemented.");
        }

        public WALPointer lastWritePointer() {
            throw new IllegalStateException("Not implemented.");
        }

        public void startAutoReleaseSegments() {
            throw new IllegalStateException("Not implemented.");
        }
    }
}

