/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.txdr;

import java.io.File;
import java.io.Serializable;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileDescriptor;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.GridGainImpl;
import org.gridgain.grid.internal.processors.cache.database.txdr.AbstractReplicationTest;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCut;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCutStore;
import org.gridgain.grid.internal.processors.cache.database.txdr.TransactionalDrProcessorImpl;
import org.gridgain.grid.internal.txdr.ClusterRole;
import org.gridgain.grid.internal.txdr.GridGainTxDrConfiguration;
import org.gridgain.grid.internal.txdr.ReplicationSessionDescriptor;
import org.gridgain.grid.internal.txdr.ReplicationState;
import org.gridgain.grid.internal.txdr.TransactionalDr;
import org.gridgain.grid.internal.txdr.TransactionalDrConfiguration;
import org.gridgain.grid.internal.txdr.TransactionalDrMaster;
import org.junit.Test;

public class TxDrStopMasterTest
extends GridCommonAbstractTest {
    private static final String CACHE_NAME = "test-cache";
    private static final String TRANSFER_FOLDER_NAME = "transfer-folder";
    private static final String SNAPSHOT_MOVE_FOLDER_NAME = "snapshot-move-folder";
    private static final long CONSISTENT_CUT_INTERVAL = 2000L;
    private static final int NODES_CNT = 3;
    private static final String WAL_DIR = "wal";

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setMaxSize(0x6400000L).setPersistenceEnabled(true)).setWalMode(WALMode.LOG_ONLY).setWalSegmentSize(524288).setWalSegments(2));
        cfg.setConsistentId((Serializable)((Object)igniteInstanceName));
        GridGainTxDrConfiguration ggCfg = new GridGainTxDrConfiguration();
        ggCfg.setTxDrConfiguration(new TransactionalDrConfiguration().setTransferFolderPath(this.folder(TRANSFER_FOLDER_NAME).getAbsolutePath()).setConsistentCutInterval(2000L));
        ggCfg.setSnapshotConfiguration(new SnapshotConfiguration().setSnapshotsPath("snapshot/" + igniteInstanceName));
        cfg.setPluginConfigurations(new PluginConfiguration[]{ggCfg});
        CacheConfiguration ccfg = new CacheConfiguration(CACHE_NAME);
        ccfg.setBackups(2);
        ccfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        return cfg;
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stopAllGrids();
        this.deleteWorkFiles();
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
        this.deleteWorkFiles();
    }

    @Test
    public void testStop() throws Exception {
        this.doTestStop(true);
    }

    @Test
    public void testStopNow() throws Exception {
        this.doTestStop(false);
    }

    private void doTestStop(boolean gracefully) throws Exception {
        IgniteEx ignite = this.startGrids(3);
        ignite.cluster().active(true);
        this.assertReplicationState(ClusterRole.DISABLED, ReplicationState.STOPPED, 0L);
        GridGainImpl gg = (GridGainImpl)ignite.plugin("GridGain");
        IgniteFuture<Long> bootstrapFut = AbstractReplicationTest.bootstrapMaster((TransactionalDrMaster)gg.txDr(), this.folder(TRANSFER_FOLDER_NAME));
        long sesId = (Long)bootstrapFut.get();
        this.assertReplicationState(ClusterRole.MASTER, ReplicationState.RUNNING, sesId);
        AtomicBoolean stop = new AtomicBoolean(false);
        IgniteInternalFuture fut = GridTestUtils.runAsync(() -> TxDrStopMasterTest.lambda$doTestStop$0(stop, (Ignite)ignite), (String)"test-load");
        U.sleep((long)5000L);
        TransactionalDr dr = gg.txDr();
        if (gracefully) {
            dr.stop().get();
        } else {
            dr.stopNow().get();
        }
        stop.set(true);
        fut.get();
        this.assertReplicationState(ClusterRole.DISABLED, ReplicationState.STOPPED, 0L);
        if (gracefully) {
            this.assertWalSegmentsSent(sesId);
        }
        for (Thread thread : Thread.getAllStackTraces().keySet()) {
            if (thread.getName().startsWith("wal-sender")) {
                TxDrStopMasterTest.fail((String)"Wal sender thread has not been stopped.");
                continue;
            }
            if (!thread.getName().startsWith("cc-scheduler")) continue;
            TxDrStopMasterTest.fail((String)"Consistent cut scheduler thread has not been stopped.");
        }
    }

    private void assertWalSegmentsSent(long bootstrapSesId) throws IgniteCheckedException {
        for (int i = 0; i < 3; ++i) {
            IgniteEx ign = this.ignite(i);
            Serializable consistentId = ign.configuration().getConsistentId();
            File walDir = this.folder("transfer-folder/" + bootstrapSesId + '/' + consistentId + '/' + WAL_DIR);
            GridGainImpl gg0 = (GridGainImpl)ign.plugin("GridGain");
            ConsistentCutStore cutStore = ((TransactionalDrProcessorImpl)gg0.txDr()).consistentCutStore();
            for (Long cutId : cutStore.list()) {
                ConsistentCut cut = cutStore.restore(cutId.longValue());
                this.assertSegmentExists(walDir, cut.spawnId(), (FileWALPointer)cut.fuzzyBorderStartPtr());
                this.assertSegmentExists(walDir, cut.spawnId(), (FileWALPointer)cut.cutPtr());
            }
        }
    }

    private void assertSegmentExists(File walDir, long spawnId, FileWALPointer ptr) {
        String segFileName = FileDescriptor.fileName((long)ptr.index());
        File file = new File(new File(walDir, Long.toString(spawnId)), segFileName);
        TxDrStopMasterTest.assertTrue((boolean)file.exists());
    }

    private File folder(String path) throws IgniteCheckedException {
        return U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)path, (boolean)false);
    }

    private void deleteWorkFiles() throws Exception {
        this.cleanPersistenceDir();
        U.delete((File)this.transferFolder());
        U.delete((File)this.snapshotMoveFolder());
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"snapshot", (boolean)false));
    }

    private File transferFolder() throws IgniteCheckedException {
        return U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)TRANSFER_FOLDER_NAME, (boolean)false);
    }

    private File snapshotMoveFolder() throws IgniteCheckedException {
        return U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)SNAPSHOT_MOVE_FOLDER_NAME, (boolean)false);
    }

    private void assertReplicationState(ClusterRole role, ReplicationState state, long bootstrapSesId) {
        for (Ignite ignite : G.allGrids()) {
            GridGainImpl gg = (GridGainImpl)ignite.plugin("GridGain");
            ReplicationSessionDescriptor locState = ((TransactionalDrProcessorImpl)gg.txDr()).localState();
            TxDrStopMasterTest.assertEquals((Object)role, (Object)locState.role());
            TxDrStopMasterTest.assertEquals((Object)state, (Object)locState.state());
            TxDrStopMasterTest.assertEquals((long)bootstrapSesId, (long)locState.sessionId());
        }
    }

    private static /* synthetic */ void lambda$doTestStop$0(AtomicBoolean stop, Ignite ignite) throws Exception {
        while (!stop.get()) {
            IgniteCache cache = ignite.cache(CACHE_NAME);
            ThreadLocalRandom rnd = ThreadLocalRandom.current();
            cache.put((Object)rnd.nextInt(1000), (Object)rnd.nextInt());
            cache.put((Object)rnd.nextInt(1000), (Object)rnd.nextInt());
            try {
                U.sleep((long)100L);
            }
            catch (IgniteInterruptedCheckedException e) {
                e.printStackTrace();
            }
        }
    }
}

