/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.txdr;

import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.util.lang.GridAbsPredicate;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.GridTestUtils;
import org.gridgain.grid.internal.processors.cache.database.txdr.AbstractReplicationTest;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCut;
import org.gridgain.grid.internal.processors.cache.database.txdr.TransactionalDrProcessorImpl;
import org.gridgain.grid.internal.txdr.ClusterRole;

public class TxDrRefreshStateTest
extends AbstractReplicationTest {
    public void testUpdateStateWhileApplyingCuts() throws Exception {
        List<IgniteEx> masterCluster = this.startCluster(ClusterRole.MASTER);
        List<IgniteEx> replicaCluster = this.startCluster(ClusterRole.REPLICA);
        IgniteEx master0 = masterCluster.get(0);
        IgniteEx replica0 = replicaCluster.get(0);
        this.populateData((Ignite)this.node(ClusterRole.MASTER), "txCache");
        this.populateData((Ignite)this.node(ClusterRole.MASTER), "atomicCache");
        long bootstrapSesId = this.bootstrapMaster();
        IgniteInternalFuture loadFut = this.startTxLoad(3, ClusterRole.MASTER);
        HashSet indexes = new HashSet();
        HashSet cuts = new HashSet();
        TransactionalDrProcessorImpl txdrMaster0 = this.txdr((Ignite)master0);
        boolean awaitCreateCuts = GridTestUtils.waitForCondition(() -> {
            ConsistentCut cut;
            long cutId = txdrMaster0.localState().lastCreatedCutId();
            if (cutId <= 0L) {
                return false;
            }
            try {
                cut = txdrMaster0.consistentCutStore().restore(cutId);
            }
            catch (IgniteCheckedException e) {
                throw new RuntimeException(e);
            }
            FileWALPointer ptr = (FileWALPointer)cut.cutPtr();
            if (!indexes.contains(ptr.index())) {
                indexes.add(ptr.index());
                cuts.add(cutId);
            }
            return indexes.size() >= 4;
        }, (long)120000L);
        TxDrRefreshStateTest.assertTrue((boolean)awaitCreateCuts);
        this.stopTxLoad(loadFut);
        long lastCreatedCutId = txdrMaster0.localState().lastCreatedCutId();
        txdrMaster0.stop().get();
        TransactionalDrProcessorImpl txdrReplica0 = this.txdr((Ignite)replica0);
        txdrReplica0.bootstrap(this.snapshotFolder(), bootstrapSesId).get();
        long beforeAppliedCutId = txdrReplica0.localState().lastSuccessfullyAppliedCutId();
        TxDrRefreshStateTest.assertTrue((lastCreatedCutId > beforeAppliedCutId ? 1 : 0) != 0);
        AtomicLong lastAppliedCutId = new AtomicLong(0L);
        boolean awaited = TxDrRefreshStateTest.waitForCondition(() -> {
            long cutId = txdrReplica0.localState().lastSuccessfullyAppliedCutId();
            if (cutId > lastCreatedCutId) {
                TxDrRefreshStateTest.fail((String)String.valueOf(cutId));
            }
            if (cutId > Math.max(beforeAppliedCutId, lastAppliedCutId.get())) {
                if (lastAppliedCutId.get() == 0L) {
                    lastAppliedCutId.set(cutId);
                } else {
                    return true;
                }
            }
            return false;
        }, 120000L);
        TxDrRefreshStateTest.assertTrue((boolean)awaited);
    }

    public static boolean waitForCondition(GridAbsPredicate cond, long timeout) throws IgniteInterruptedCheckedException {
        long curTime = U.currentTimeMillis();
        long endTime = curTime + timeout;
        if (endTime < 0L) {
            endTime = Long.MAX_VALUE;
        }
        while (curTime < endTime) {
            if (cond.apply()) {
                return true;
            }
            U.sleep((long)20L);
            curTime = U.currentTimeMillis();
        }
        return false;
    }
}

