/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.txdr;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite.Ignite;
import org.apache.ignite.internal.IgniteEx;
import org.gridgain.grid.internal.processors.cache.database.txdr.AbstractReplicationTest;
import org.gridgain.grid.internal.txdr.ClusterRole;
import org.junit.Assert;
import org.junit.Test;

public class TxDrNodeSpawnTest
extends AbstractReplicationTest {
    @Override
    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.nodesCnt = 2;
    }

    @Test
    public void testNodeSpawn() throws Exception {
        List<IgniteEx> cluster0 = this.startCluster(ClusterRole.MASTER);
        List spawnIds0 = cluster0.stream().map(node -> this.txdr((Ignite)node).spawnId()).collect(Collectors.toList());
        List walDirs0 = cluster0.stream().map(node -> this.txdr((Ignite)node).walDir(this.txdr((Ignite)node).spawnId())).collect(Collectors.toList());
        this.stopCluster(ClusterRole.MASTER);
        List<IgniteEx> cluster1 = this.startCluster(ClusterRole.MASTER);
        List spawnIds1 = cluster1.stream().map(node -> this.txdr((Ignite)node).spawnId()).collect(Collectors.toList());
        List walDirs1 = cluster1.stream().map(node -> this.txdr((Ignite)node).walDir(this.txdr((Ignite)node).spawnId())).collect(Collectors.toList());
        TxDrNodeSpawnTest.assertEqualsCollections(spawnIds0, spawnIds1);
        TxDrNodeSpawnTest.assertEqualsCollections(walDirs0, walDirs1);
        this.stopCluster(ClusterRole.MASTER);
        this.deleteWorkFiles();
        List<IgniteEx> cluster2 = this.startCluster(ClusterRole.MASTER);
        List spawnIds2 = cluster2.stream().map(node -> this.txdr((Ignite)node).spawnId()).collect(Collectors.toList());
        List walDirs2 = cluster2.stream().map(node -> this.txdr((Ignite)node).walDir(this.txdr((Ignite)node).spawnId())).collect(Collectors.toList());
        for (int i = 0; i < this.nodesCnt; ++i) {
            Assert.assertNotEquals(spawnIds0.get(i), spawnIds2.get(i));
            Assert.assertNotEquals(walDirs0.get(i), walDirs2.get(i));
        }
    }
}

