/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.txdr;

import java.io.File;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.GridTestUtils;
import org.gridgain.grid.internal.processors.cache.database.txdr.AbstractReplicationTest;
import org.gridgain.grid.internal.txdr.ClusterRole;
import org.gridgain.grid.internal.txdr.ReplicationSessionDescriptor;
import org.gridgain.grid.internal.txdr.ReplicationState;
import org.junit.Test;

public class TxDrExemptReplicaTest
extends AbstractReplicationTest {
    @Override
    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.nodesCnt = 3;
        this.backupsCnt = 1;
    }

    @Test
    public void testFormerReplicaActivityAfterSwitch() throws Exception {
        int i;
        List<IgniteEx> replicaCluster = this.startCluster(ClusterRole.REPLICA);
        replicaCluster.get(0).cluster().active(true);
        U.sleep((long)3000L);
        List<IgniteEx> masterCluster = this.startCluster(ClusterRole.MASTER);
        masterCluster.get(0).cluster().active(true);
        File snapshotDir = new File(U.defaultWorkDirectory(), "snapshot");
        long bootstrapSesId = this.bootstrapMaster();
        this.assertClusterState(masterCluster, ClusterRole.MASTER, ReplicationState.RUNNING, bootstrapSesId);
        this.bootstrapReplica(bootstrapSesId);
        this.assertClusterState(replicaCluster, ClusterRole.REPLICA, ReplicationState.RUNNING, bootstrapSesId);
        IgniteCache atomicCache = masterCluster.get(0).getOrCreateCache("atomicCache");
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        for (i = 0; i < 50; ++i) {
            atomicCache.put((Object)i, (Object)rnd.nextLong());
        }
        bootstrapSesId = (Long)this.txdr(ClusterRole.MASTER).switchWithReplica().get();
        this.assertClusterState(masterCluster, ClusterRole.REPLICA, ReplicationState.RUNNING, bootstrapSesId);
        this.awakeCutsWatcher(replicaCluster);
        TxDrExemptReplicaTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> {
            for (IgniteEx ignite : replicaCluster) {
                ReplicationSessionDescriptor state = this.txdr((Ignite)ignite).localState();
                if (state.role() == ClusterRole.MASTER && state.state() == ReplicationState.RUNNING) continue;
                return false;
            }
            return true;
        }, (long)60000L));
        this.assertClusterState(replicaCluster, ClusterRole.MASTER, ReplicationState.RUNNING, bootstrapSesId);
        atomicCache = replicaCluster.get(0).getOrCreateCache("atomicCache");
        for (i = 0; i < 50; ++i) {
            atomicCache.put((Object)i, (Object)rnd.nextLong());
        }
    }

    @Test
    public void testReplicaActivityAfterStop() throws Exception {
        int i;
        List<IgniteEx> replicaCluster = this.startCluster(ClusterRole.REPLICA);
        replicaCluster.get(0).cluster().active(true);
        U.sleep((long)3000L);
        List<IgniteEx> masterCluster = this.startCluster(ClusterRole.MASTER);
        masterCluster.get(0).cluster().active(true);
        long bootstrapSesId = this.bootstrapMaster();
        this.assertClusterState(masterCluster, ClusterRole.MASTER, ReplicationState.RUNNING, bootstrapSesId);
        this.bootstrapReplica(bootstrapSesId);
        this.assertClusterState(replicaCluster, ClusterRole.REPLICA, ReplicationState.RUNNING, bootstrapSesId);
        IgniteCache atomicCache = masterCluster.get(0).getOrCreateCache("atomicCache");
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        for (i = 0; i < 50; ++i) {
            atomicCache.put((Object)i, (Object)rnd.nextLong());
        }
        this.txdr(ClusterRole.MASTER).stop().get();
        this.assertClusterState(masterCluster, ClusterRole.DISABLED, ReplicationState.STOPPED, 0L);
        this.awakeCutsWatcher(replicaCluster);
        TxDrExemptReplicaTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> ((IgniteEx)replicaCluster.get(0)).getOrCreateCache("atomicCache").size(new CachePeekMode[0]) == 50, (long)30000L));
        this.txdr(ClusterRole.REPLICA).stop().get();
        this.assertClusterState(replicaCluster, ClusterRole.DISABLED, ReplicationState.STOPPED, 0L);
        atomicCache = replicaCluster.get(0).getOrCreateCache("atomicCache");
        for (i = 0; i < 50; ++i) {
            atomicCache.put((Object)i, (Object)rnd.nextLong());
        }
    }
}

