/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.txdr;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.Ignite;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.testframework.GridTestUtils;
import org.gridgain.grid.internal.processors.cache.database.txdr.AbstractReplicationTest;
import org.gridgain.grid.internal.txdr.ClusterRole;
import org.gridgain.grid.internal.txdr.ReplicationSessionDescriptor;
import org.gridgain.grid.internal.txdr.ReplicationState;
import org.gridgain.grid.internal.txdr.TransactionalDrConfiguration;
import org.junit.Test;

public class TxDrClusterRestartTest
extends AbstractReplicationTest {
    private static final long WAIT_CONDITION_PERIOD = 180000L;
    protected IgniteInternalFuture loadFut;
    protected String[] consistentIds = new String[]{"node1", "node2"};

    @Override
    protected TransactionalDrConfiguration getTxDrConfiguration() throws Exception {
        return super.getTxDrConfiguration().setConsistentCutInterval(5000L);
    }

    @Override
    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.loadFut = null;
        this.nodesCnt = 2;
    }

    public IgniteBiTuple<List<IgniteEx>, Long> startMasterClusterAndBootstrap(String ... consistentIds) throws Exception {
        List<IgniteEx> masterCluster = this.startCluster(ClusterRole.MASTER, consistentIds);
        this.populateData((Ignite)masterCluster.get(0), "txCache");
        long bootstrapSesId = this.bootstrapMaster();
        this.assertClusterState(masterCluster, ClusterRole.MASTER, ReplicationState.RUNNING, bootstrapSesId);
        return new IgniteBiTuple(masterCluster, (Object)bootstrapSesId);
    }

    public List<IgniteEx> startReplicaClusterAndBootstrap(long bootstrapSesId, String ... consistentIds) throws Exception {
        List<IgniteEx> replicaCluster = this.startCluster(ClusterRole.REPLICA, consistentIds);
        this.bootstrapReplica(bootstrapSesId);
        this.assertClusterState(replicaCluster, ClusterRole.REPLICA, ReplicationState.RUNNING, bootstrapSesId);
        return replicaCluster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMasterClusterRestart() throws Exception {
        long bootstrapSesId = (Long)this.startMasterClusterAndBootstrap(this.consistentIds).get2();
        this.stopCluster(ClusterRole.MASTER);
        List<IgniteEx> restartedCluster = this.startCluster(ClusterRole.MASTER, this.consistentIds);
        this.assertClusterState(restartedCluster, ClusterRole.MASTER, ReplicationState.RUNNING, bootstrapSesId);
        Map<Object, ReplicationSessionDescriptor> stateAfterRestart = this.collectLocalReplicationSessions(restartedCluster);
        try {
            this.loadFut = this.startTxLoad(1, ClusterRole.MASTER);
            boolean progress = this.checkClusterProgress(stateAfterRestart, restartedCluster, (IgniteBiPredicate<ReplicationSessionDescriptor, ReplicationSessionDescriptor>)(IgniteBiPredicate & Serializable)(pd, nd) -> nd.lastSuccessfullySentWalIndex() > pd.lastSuccessfullySentWalIndex() && nd.lastCreatedCutId() > pd.lastCreatedCutId());
            TxDrClusterRestartTest.assertTrue((String)"There was no progress in 180000ms. on master cluster.", (boolean)progress);
        }
        finally {
            this.stopTxLoad(this.loadFut);
        }
    }

    @Test
    public void testMasterClusterRestartAfterStoppedReplication() throws Exception {
        List masterCluster = (List)this.startMasterClusterAndBootstrap(this.consistentIds).get1();
        try {
            this.loadFut = this.startTxLoad(1, ClusterRole.MASTER);
            this.txdr((Ignite)masterCluster.get(0)).stop().get();
        }
        finally {
            this.stopTxLoad(this.loadFut);
        }
        long sesId = this.txdr((Ignite)masterCluster.get(0)).localState().sessionId();
        this.stopCluster(ClusterRole.MASTER);
        List<IgniteEx> restartedCluster = this.startCluster(ClusterRole.MASTER, this.consistentIds);
        this.awaitPartitionMapExchange();
        this.assertClusterState(restartedCluster, ClusterRole.DISABLED, ReplicationState.STOPPED, sesId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReplicaClusterRestart() throws Exception {
        long bootstrapSesId = (Long)this.startMasterClusterAndBootstrap(this.consistentIds).get2();
        try {
            this.loadFut = this.startTxLoad(1, ClusterRole.MASTER);
            List<IgniteEx> replicaCluster = this.startReplicaClusterAndBootstrap(bootstrapSesId, this.consistentIds);
            this.stopCluster(ClusterRole.REPLICA);
            List<IgniteEx> restartedCluster = this.startCluster(ClusterRole.REPLICA, this.consistentIds);
            this.assertClusterState(restartedCluster, ClusterRole.REPLICA, ReplicationState.RUNNING, bootstrapSesId);
            this.assertClusterReadOnly(restartedCluster);
            Map<Object, ReplicationSessionDescriptor> stateAfterRestart = this.collectLocalReplicationSessions(restartedCluster);
            boolean progress = this.checkClusterProgress(stateAfterRestart, restartedCluster, (IgniteBiPredicate<ReplicationSessionDescriptor, ReplicationSessionDescriptor>)(IgniteBiPredicate & Serializable)(pd, nd) -> nd.lastSuccessfullyAppliedCutId() > pd.lastSuccessfullyAppliedCutId());
            TxDrClusterRestartTest.assertTrue((String)"There was no progress in 180000ms. on replica cluster.", (boolean)progress);
        }
        finally {
            this.stopTxLoad(this.loadFut);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMasterAndReplicaClustersRestart() throws Exception {
        long bootstrapSesId = (Long)this.startMasterClusterAndBootstrap(this.consistentIds).get2();
        this.startReplicaClusterAndBootstrap(bootstrapSesId, this.consistentIds);
        this.stopCluster(ClusterRole.MASTER);
        this.stopCluster(ClusterRole.REPLICA);
        List<IgniteEx> restartedMasterCluster = this.startCluster(ClusterRole.MASTER, this.consistentIds);
        this.assertClusterState(restartedMasterCluster, ClusterRole.MASTER, ReplicationState.RUNNING, bootstrapSesId);
        List<IgniteEx> restartedReplicaCluster = this.startCluster(ClusterRole.REPLICA, this.consistentIds);
        this.assertClusterState(restartedReplicaCluster, ClusterRole.REPLICA, ReplicationState.RUNNING, bootstrapSesId);
        this.assertClusterReadOnly(restartedReplicaCluster);
        Map<Object, ReplicationSessionDescriptor> stateAfterRestart = this.collectLocalReplicationSessions(restartedReplicaCluster);
        try {
            this.loadFut = this.startTxLoad(1, ClusterRole.MASTER);
            boolean progress = this.checkClusterProgress(stateAfterRestart, restartedReplicaCluster, (IgniteBiPredicate<ReplicationSessionDescriptor, ReplicationSessionDescriptor>)(IgniteBiPredicate & Serializable)(pd, nd) -> nd.lastSuccessfullyAppliedCutId() > pd.lastSuccessfullyAppliedCutId());
            TxDrClusterRestartTest.assertTrue((String)"There was no progress in 180000ms. on replica cluster.", (boolean)progress);
        }
        finally {
            this.stopTxLoad(this.loadFut);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReplicaClusterRestartAfterPause() throws Exception {
        long bootstrapSesId = (Long)this.startMasterClusterAndBootstrap(this.consistentIds).get2();
        try {
            this.loadFut = this.startTxLoad(1, ClusterRole.MASTER);
            List<IgniteEx> replicaCluster = this.startReplicaClusterAndBootstrap(bootstrapSesId, this.consistentIds);
            this.txdr((Ignite)replicaCluster.get(0)).pause().get();
            this.assertClusterState(replicaCluster, ClusterRole.REPLICA, ReplicationState.PAUSED, bootstrapSesId);
            this.stopCluster(ClusterRole.REPLICA);
            List<IgniteEx> restartedReplicaCluster = this.startCluster(ClusterRole.REPLICA, this.consistentIds);
            this.assertClusterState(restartedReplicaCluster, ClusterRole.REPLICA, ReplicationState.PAUSED, bootstrapSesId);
            this.assertClusterReadOnly(restartedReplicaCluster);
            Map<Object, ReplicationSessionDescriptor> stateAfterRestart = this.collectLocalReplicationSessions(restartedReplicaCluster);
            this.txdr((Ignite)restartedReplicaCluster.get(0)).resume().get();
            boolean progress = this.checkClusterProgress(stateAfterRestart, restartedReplicaCluster, (IgniteBiPredicate<ReplicationSessionDescriptor, ReplicationSessionDescriptor>)(IgniteBiPredicate & Serializable)(pd, nd) -> nd.lastSuccessfullyAppliedCutId() > pd.lastSuccessfullyAppliedCutId());
            TxDrClusterRestartTest.assertTrue((String)"There was no progress in 180000ms. on replica cluster.", (boolean)progress);
        }
        finally {
            this.stopTxLoad(this.loadFut);
        }
    }

    private boolean checkClusterProgress(Map<Object, ReplicationSessionDescriptor> origin, List<IgniteEx> cluster, IgniteBiPredicate<ReplicationSessionDescriptor, ReplicationSessionDescriptor> pred) throws IgniteInterruptedCheckedException {
        return GridTestUtils.waitForCondition(() -> {
            for (IgniteEx ignite : cluster) {
                ReplicationSessionDescriptor nd;
                ReplicationSessionDescriptor pd = (ReplicationSessionDescriptor)origin.get(ignite.cluster().localNode().consistentId());
                if (pred.apply((Object)pd, (Object)(nd = this.txdr((Ignite)ignite).localState()))) continue;
                this.awakeCutsWatcher(ignite);
                return false;
            }
            return true;
        }, (long)180000L);
    }

    protected Map<Object, ReplicationSessionDescriptor> collectLocalReplicationSessions(List<IgniteEx> cluster) {
        HashMap<Object, ReplicationSessionDescriptor> states = new HashMap<Object, ReplicationSessionDescriptor>();
        for (IgniteEx ignite : cluster) {
            ReplicationSessionDescriptor locState = this.txdr((Ignite)ignite).localState();
            states.put(ignite.cluster().localNode().consistentId(), locState);
        }
        return states;
    }
}

