/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.txdr;

import java.io.Serializable;
import java.util.Collection;
import org.apache.ignite.Ignite;
import org.apache.ignite.cluster.BaselineNode;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.testframework.GridTestUtils;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.internal.processors.cache.database.txdr.TxDrBaselineTopologyScenarios;
import org.gridgain.grid.internal.txdr.ClusterRole;
import org.gridgain.grid.internal.txdr.ReplicationState;
import org.gridgain.grid.internal.txdr.TransactionalDrMaster;
import org.junit.Test;

public class TxDrBaselineTopologyScenariosWithPITRTest
extends TxDrBaselineTopologyScenarios {
    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName, String consistentId, ClusterRole role) throws Exception {
        IgniteConfiguration igCfg = super.getConfiguration(igniteInstanceName, consistentId, role);
        GridGainConfiguration ggCfg = (GridGainConfiguration)igCfg.getPluginConfigurations()[0];
        if (role == ClusterRole.REPLICA) {
            ggCfg.getSnapshotConfiguration().setPointInTimeRecoveryEnabled(true);
        }
        return igCfg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAutoSnapshotOnBaselineChange() throws Exception {
        boolean pitrOnMasterEnabled = false;
        int newNodesCntr = 1;
        String oldProp = System.getProperty("GG_DISABLE_SNAPSHOT_ON_BASELINE_CHANGE_WITH_ENABLED_PITR");
        System.setProperty("GG_DISABLE_SNAPSHOT_ON_BASELINE_CHANGE_WITH_ENABLED_PITR", "false");
        try {
            this.masterCluster = this.startCluster(ClusterRole.MASTER);
            IgniteEx master = (IgniteEx)this.masterCluster.get(0);
            master.cluster().baselineAutoAdjustEnabled(false);
            int masterSnapshots = 0;
            master.cluster().active(true);
            GridGain ggMaster = (GridGain)master.plugin("GridGain");
            if (pitrOnMasterEnabled) {
                ++masterSnapshots;
            }
            TxDrBaselineTopologyScenariosWithPITRTest.assertEquals((int)masterSnapshots, (int)ggMaster.snapshot().list().size());
            this.populateData((Ignite)master, "txCache");
            this.populateData((Ignite)master, "atomicCache");
            this.replicaCluster = this.startCluster(ClusterRole.REPLICA);
            IgniteEx replica = (IgniteEx)this.replicaCluster.get(0);
            int replicaSnapshots = 0;
            replica.cluster().active(true);
            GridGain ggReplica = (GridGain)replica.plugin("GridGain");
            TxDrBaselineTopologyScenariosWithPITRTest.assertEquals((int)(++replicaSnapshots), (int)ggReplica.snapshot().list().size());
            long sesId = (Long)TxDrBaselineTopologyScenariosWithPITRTest.bootstrapMaster((TransactionalDrMaster)this.txdr((Ignite)master), this.snapshotFolder()).get();
            TxDrBaselineTopologyScenariosWithPITRTest.assertEquals((int)(++masterSnapshots), (int)ggMaster.snapshot().list().size());
            this.txdr((Ignite)replica).bootstrap(this.snapshotFolder(), sesId).get();
            this.startClusterNodes(ClusterRole.MASTER, newNodesCntr);
            this.startClusterNodes(ClusterRole.REPLICA, newNodesCntr);
            master.cluster().setBaselineTopology(master.cluster().forServers().nodes());
            log.info("Baseline topology changed on MASTER cluster");
            if (pitrOnMasterEnabled) {
                ++masterSnapshots;
            }
            TxDrBaselineTopologyScenariosWithPITRTest.assertEquals((int)masterSnapshots, (int)ggMaster.snapshot().list().size());
            this.assertNodesState(this.masterCluster, ClusterRole.MASTER, ReplicationState.RUNNING, sesId, "All new master-nodes must be included into the current baseline topology.", (IgniteBiPredicate<Collection<BaselineNode>, Object>)(IgniteBiPredicate & Serializable)(baseline, consistentId) -> baseline.stream().anyMatch(n -> n.consistentId().equals(consistentId)));
            this.txdr((Ignite)master).stop().get();
            long lastCreatedCutId = this.txdr((Ignite)master).localState().lastCreatedCutId();
            log.info("MASTER cluster replication stopped. [lastCreatedCutId=" + lastCreatedCutId + ']');
            boolean awaited = GridTestUtils.waitForCondition(() -> {
                Collection currBaseline = replica.cluster().currentBaselineTopology();
                for (IgniteEx ignite : this.replicaCluster) {
                    Object consistentId = ignite.cluster().localNode().consistentId();
                    if (!currBaseline.stream().noneMatch(n -> n.consistentId().equals(consistentId))) continue;
                    return false;
                }
                return true;
            }, (long)30000L);
            TxDrBaselineTopologyScenariosWithPITRTest.assertTrue((boolean)awaited);
            awaited = GridTestUtils.waitForCondition(() -> ggReplica.snapshot().ongoingSnapshotOperation() == null, (long)10000L);
            TxDrBaselineTopologyScenariosWithPITRTest.assertTrue((boolean)awaited);
            TxDrBaselineTopologyScenariosWithPITRTest.assertEquals((int)replicaSnapshots, (int)ggReplica.snapshot().list().size());
            this.txdr((Ignite)replica).stop().get();
            log.info("REPLICA cluster replication stopped.");
            this.stopClusterNodes(ClusterRole.REPLICA, 1, false);
            replica.cluster().setBaselineTopology(replica.cluster().forServers().nodes());
            log.info("Baseline topology changed on stopped REPLICA cluster");
            TxDrBaselineTopologyScenariosWithPITRTest.assertEquals((int)(++replicaSnapshots), (int)ggReplica.snapshot().list().size());
        }
        finally {
            if (oldProp != null) {
                System.setProperty("GG_DISABLE_SNAPSHOT_ON_BASELINE_CHANGE_WITH_ENABLED_PITR", oldProp);
            } else {
                System.clearProperty("GG_DISABLE_SNAPSHOT_ON_BASELINE_CHANGE_WITH_ENABLED_PITR");
            }
        }
    }
}

