/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.txdr;

import java.io.Serializable;
import java.util.List;
import org.apache.ignite.Ignite;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.gridgain.grid.internal.processors.cache.database.txdr.AbstractReplicationTest;
import org.gridgain.grid.internal.txdr.ClusterRole;
import org.junit.Test;

public class ConsistentCutTopologyTest
extends AbstractReplicationTest {
    private boolean isClientNode;

    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName, String consistentId, ClusterRole role) throws Exception {
        if (!this.isClientNode) {
            return super.getConfiguration(igniteInstanceName, consistentId, role);
        }
        IgniteConfiguration cfg = this.getConfiguration(igniteInstanceName);
        cfg.setClientMode(true);
        cfg.setConsistentId((Serializable)((Object)consistentId));
        cfg.setDiscoverySpi(this.getDiscoverySpi(role));
        return cfg;
    }

    @Test
    public void testClientNodeInTopology() throws Exception {
        List<IgniteEx> masterCluster = this.initializeMasterCluster();
        this.isClientNode = true;
        IgniteEx clientNode = this.startGrid(this.getConfiguration("test-client", "test-client", ClusterRole.MASTER));
        this.isClientNode = false;
        this.forceConsistentCut((Ignite)masterCluster.get(0));
        clientNode.close();
    }

    @Test
    public void testNodeBeyondBaselineTopology() throws Exception {
        List<IgniteEx> masterCluster = this.initializeMasterCluster();
        IgniteEx outsideBaseline = this.startGrid(this.getConfiguration("test-node-outside", "test-node-outside", ClusterRole.MASTER));
        this.forceConsistentCut((Ignite)masterCluster.get(0));
        outsideBaseline.close();
    }

    private List<IgniteEx> initializeMasterCluster() throws Exception {
        List<IgniteEx> masterCluster = this.startCluster(ClusterRole.MASTER, 3);
        this.populateData((Ignite)this.node(ClusterRole.MASTER), "txCache");
        this.populateData((Ignite)this.node(ClusterRole.MASTER), "atomicCache");
        this.bootstrapMaster();
        return masterCluster;
    }
}

