/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.txdr;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.GridTestUtils;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCut;
import org.gridgain.grid.internal.processors.cache.database.txdr.GlobalConsistentCutData;
import org.gridgain.grid.internal.processors.cache.database.txdr.TestLocalTxEngine;
import org.gridgain.grid.internal.processors.cache.database.txdr.TestNodeContext;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ConsistentCutStressTest {
    private static final int NODES = 6;
    private static final int CUT_TIMEOUT = 3000;
    private static final int WATCHDOG_TIMEOUT = 30000;
    private static ScheduledExecutorService timeoutExecutor;
    private TestNodeContext[] nodes;
    private final AtomicLong TX_ORDER_GEN = new AtomicLong(1L);
    private CountDownLatch startLatch;
    volatile boolean stopWorkerThreads;

    @BeforeClass
    public static void setUpClass() {
        timeoutExecutor = new ScheduledThreadPoolExecutor(1);
        System.setProperty("IGNITE_PENDING_TX_TRACKER_ENABLED", "true");
        U.onGridStart();
    }

    @AfterClass
    public static void tearDownClass() {
        timeoutExecutor.shutdown();
        System.clearProperty("IGNITE_PENDING_TX_TRACKER_ENABLED");
    }

    @Before
    public void setUp() throws Exception {
        this.nodes = new TestNodeContext[6];
        for (int i = 0; i < 6; ++i) {
            this.nodes[i] = new TestNodeContext(i, timeoutExecutor, new TestLocalTxEngine.ReentrantLockPolicy());
        }
        this.TX_ORDER_GEN.set(1L);
        this.startLatch = null;
    }

    @Test
    public void testSimple() throws Exception {
        int i;
        int maxTxSize = 12;
        int keyRange = 42;
        int concurrencyLevel = 5;
        int threadNum = 30;
        this.startLatch = new CountDownLatch(30);
        final ArrayList allPreparedTxs = new ArrayList(6);
        for (int i2 = 0; i2 < 6; ++i2) {
            allPreparedTxs.add(new ConcurrentHashMap());
        }
        final ArrayList allCommittedTxs = new ArrayList(6);
        for (int i3 = 0; i3 < 6; ++i3) {
            allCommittedTxs.add(new ConcurrentHashMap());
        }
        final IgniteInternalFuture futWorkers = GridTestUtils.runMultiThreadedAsync((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ThreadLocalRandom r = ThreadLocalRandom.current();
                TreeSet<Integer> txKeys = new TreeSet<Integer>();
                HashSet<TestNodeContext> txNodes = new HashSet<TestNodeContext>(6);
                ConsistentCutStressTest.this.startLatch.countDown();
                while (!ConsistentCutStressTest.this.stopWorkerThreads) {
                    GridCacheVersion tx = new GridCacheVersion(0, ConsistentCutStressTest.this.TX_ORDER_GEN.getAndIncrement(), 0, 0);
                    int txSize = r.nextInt(12);
                    for (int i = 0; i < txSize; ++i) {
                        Integer key = r.nextInt(42);
                        txKeys.add(key);
                        txNodes.add(ConsistentCutStressTest.this.nodes[key % 6]);
                    }
                    for (Integer key : txKeys) {
                        ConsistentCutStressTest.this.nodes[key % 6].txEngine().lockKey(tx, key);
                    }
                    for (TestNodeContext node : txNodes) {
                        FileWALPointer preparePtr = node.txEngine().prepareTx(tx);
                        ((Map)allPreparedTxs.get(node.nodeId())).put(tx, preparePtr);
                    }
                    for (Integer key : txKeys) {
                        ConsistentCutStressTest.this.nodes[key % 6].txEngine().writeKey(tx, key);
                    }
                    for (TestNodeContext node : txNodes) {
                        FileWALPointer committedPtr = node.txEngine().commitTx(tx);
                        ((Map)allCommittedTxs.get(node.nodeId())).put(tx, committedPtr);
                    }
                    txKeys.clear();
                    txNodes.clear();
                }
                return null;
            }
        }, (int)30, (String)"worker-thread");
        if (!this.startLatch.await(15000L, TimeUnit.MILLISECONDS)) {
            Assert.fail((String)"Cannot start worker threads.");
        }
        new ScheduledThreadPoolExecutor(1).schedule(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                futWorkers.cancel();
                return null;
            }
        }, 30000L, TimeUnit.MILLISECONDS);
        for (TestNodeContext node : this.nodes) {
            node.consistentCutContext().startTrackingTransactionsLocally();
        }
        Thread.sleep(3000L);
        for (int i4 = 0; i4 < 6; ++i4) {
            this.nodes[i4].consistentCutContext().markConsistentCutPoint();
        }
        Thread.sleep(3000L);
        this.stopWorkerThreads = true;
        futWorkers.get();
        GlobalConsistentCutData.Builder globDataBuilder = new GlobalConsistentCutData.Builder();
        for (TestNodeContext node : this.nodes) {
            globDataBuilder.merge(node.nodeUuid(), node.consistentCutContext().finishTrackingTransactionsLocally());
        }
        GlobalConsistentCutData glob = globDataBuilder.build();
        ConsistentCut[] cuts = new ConsistentCut[6];
        for (i = 0; i < 6; ++i) {
            cuts[i] = this.nodes[i].consistentCutContext().completeConsistentCutCreation(glob, null);
        }
        for (i = 0; i < 6; ++i) {
            ConsistentCut currCut = cuts[i];
            for (Map.Entry e : ((Map)allCommittedTxs.get(i)).entrySet()) {
                if (((FileWALPointer)e.getValue()).compareTo((FileWALPointer)currCut.cutPtr()) <= 0) continue;
                Assert.assertTrue((boolean)glob.globalTxs().contains(e.getKey()));
            }
            for (Map.Entry e : ((Map)allPreparedTxs.get(i)).entrySet()) {
                if (((FileWALPointer)e.getValue()).compareTo((FileWALPointer)currCut.cutPtr()) <= 0) continue;
                Assert.assertTrue((boolean)glob.globalTxs().contains(e.getKey()));
            }
        }
        for (GridCacheVersion tx : glob.globalTxs()) {
            boolean foundTxNode = false;
            for (int i5 = 0; i5 < allPreparedTxs.size(); ++i5) {
                if (!((Map)allPreparedTxs.get(i5)).containsKey(tx)) continue;
                foundTxNode = true;
                Assert.assertTrue((boolean)cuts[i5].skipTxs().contains(tx));
            }
            Assert.assertTrue((boolean)foundTxNode);
        }
    }
}

