/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot.schedule;

import org.apache.ignite.IgniteCache;
import org.apache.ignite.Ignition;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.gridgain.grid.internal.GridGainImpl;
import org.gridgain.grid.internal.processors.cache.database.AbstractSnapshotTest;
import org.gridgain.grid.persistentstore.GridSnapshot;
import org.gridgain.grid.persistentstore.RestoreSnapshotParams;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.junit.Test;

public class SnapshotStaticCacheTest
extends AbstractSnapshotTest {
    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.cleanSnapshotDirs();
    }

    @Override
    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
        this.cleanSnapshotDirs();
    }

    @Test
    public void test() {
        IgniteConfiguration serverConfiguration = new IgniteConfiguration().setIgniteInstanceName("server").setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true)));
        String cache1Name = "cache1";
        String cache2Name = "cache2";
        String cacheGroupName = "group";
        IgniteConfiguration clientConfiguration = new IgniteConfiguration().setIgniteInstanceName("client").setClientMode(true).setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration().setName(cache1Name).setGroupName(cacheGroupName), new CacheConfiguration().setName(cache2Name).setGroupName(cacheGroupName)});
        IgniteEx server = (IgniteEx)Ignition.start((IgniteConfiguration)serverConfiguration);
        server.cluster().state(ClusterState.ACTIVE);
        IgniteEx client = (IgniteEx)Ignition.start((IgniteConfiguration)clientConfiguration);
        GridGainImpl gg = (GridGainImpl)server.plugin("GridGain");
        GridSnapshot storage = gg.snapshot();
        IgniteCache cache1 = client.cache(cache1Name);
        cache1.put((Object)1, (Object)1);
        IgniteCache cache2 = client.cache(cache2Name);
        cache2.put((Object)1, (Object)1);
        SnapshotFuture snapshotFut = storage.createFullSnapshot(null, "");
        snapshotFut.get();
        long snapshotId = snapshotFut.snapshotOperation().snapshotId();
        cache1.clear();
        cache2.clear();
        SnapshotStaticCacheTest.assertNull((Object)cache1.get((Object)1));
        SnapshotStaticCacheTest.assertNull((Object)cache2.get((Object)1));
        gg.snapshot().restore(new RestoreSnapshotParams().snapshotId(snapshotId)).get();
        SnapshotStaticCacheTest.assertEquals((int)1, (int)((Integer)cache1.get((Object)1)));
        SnapshotStaticCacheTest.assertEquals((int)1, (int)((Integer)cache2.get((Object)1)));
    }
}

