/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadLocalRandom;
import javax.cache.configuration.CompleteConfiguration;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.pagemem.FullPageId;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.PageSupport;
import org.apache.ignite.internal.pagemem.store.IgnitePageStoreManager;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMemoryEx;
import org.apache.ignite.internal.processors.cache.persistence.partstate.GroupPartitionId;
import org.apache.ignite.internal.processors.cache.persistence.partstate.PagesAllocationRange;
import org.apache.ignite.internal.processors.cache.persistence.partstate.PartitionAllocationMap;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.TrackingPageIO;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.processors.cache.database.SnapshotMetricsMXBeanImpl;
import org.gridgain.grid.internal.processors.cache.database.snapshot.FullPageIdIncrementalSnapshotIterable;
import org.gridgain.grid.internal.processors.cache.database.snapshot.FullPageIdIterable;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.PageIdIterable;
import org.gridgain.grid.internal.processors.cache.database.snapshot.PagesWrittenTracker;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCreateFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

public class FullPageIdIncrementalSnapshotIterableTest
extends GridCommonAbstractTest {
    private static final PageMetaIO metaIO = (PageMetaIO)PageMetaIO.VERSIONS.latest();
    private static final PageMetaIO pageMetaIO = (PageMetaIO)PageMetaIO.VERSIONS.latest();
    public static final String FIRST_CACHE = "first";
    public static final String SECOND_CACHE = "second";
    private static final TcpDiscoveryIpFinder IP_FINDER = new TcpDiscoveryVmIpFinder(true);
    private final List<Integer> grpIds = Arrays.asList(CU.cacheId((String)"first"), CU.cacheId((String)"second"));
    private final int totalPartitions = 32;
    private final int snapshotPartitions = 10;

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        DataStorageConfiguration dbCfg = new DataStorageConfiguration();
        DataRegionConfiguration dfltReg = new DataRegionConfiguration();
        dfltReg.setMaxSize(0x8000000L);
        dfltReg.setPersistenceEnabled(true);
        dbCfg.setDefaultDataRegionConfiguration(dfltReg);
        cfg.setDataStorageConfiguration(dbCfg);
        GridGainConfiguration ggCfg = new GridGainConfiguration();
        SnapshotConfiguration ggDbCfg = new SnapshotConfiguration();
        ggCfg.setSnapshotConfiguration(ggDbCfg);
        CacheConfiguration cfgTemplate = new CacheConfiguration().setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32));
        cfg.setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration((CompleteConfiguration)cfgTemplate).setName(FIRST_CACHE), new CacheConfiguration((CompleteConfiguration)cfgTemplate).setName(SECOND_CACHE)});
        cfg.setPluginConfigurations(new PluginConfiguration[]{ggCfg});
        cfg.setDiscoverySpi((DiscoverySpi)new TcpDiscoverySpi().setIpFinder(IP_FINDER));
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        this.stopAllGrids();
        this.deleteWorkFiles();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.deleteWorkFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCommon() throws Exception {
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        IgniteEx ignite = this.startGrid(0);
        ignite.cluster().active(true);
        GridCacheSharedContext shared = ignite.context().cache().context();
        this.getDbMgr((GridCacheSharedContext<Object, Object>)shared).enableCheckpoints(false).get();
        HashMap<Integer, Long> snapshotIdMap = new HashMap<Integer, Long>();
        HashMap<Integer, Long> nextSnapshotTagMap = new HashMap<Integer, Long>();
        HashSet<FullPageId> allIds = new HashSet<FullPageId>();
        this.testSetNextSnapshotId(this.getSnapshotMgr((GridCacheSharedContext<Object, Object>)shared), 1L, shared.cacheContexts());
        PartitionAllocationMap map = this.allocatePagesAndGetPartitionAllocationMap(ignite, (GridCacheSharedContext<Object, Object>)shared, snapshotIdMap, nextSnapshotTagMap, allIds);
        FullPageIdIncrementalSnapshotIterable iter = new FullPageIdIncrementalSnapshotIterable(shared, nextSnapshotTagMap, snapshotIdMap, map);
        for (FullPageId fullPageId : allIds) {
            FullPageIdIncrementalSnapshotIterableTest.assertTrue((boolean)iter.contains(fullPageId));
        }
        this.testConsistencyOfContainsAndNextMethods(iter);
        this.doCheckpoint(this.getDbMgr((GridCacheSharedContext<Object, Object>)shared));
        this.getDbMgr((GridCacheSharedContext<Object, Object>)shared).checkpointReadLock();
        try {
            this.completeSavingAllocatedIndex((GridCacheSharedContext<Object, Object>)shared, this.memory((GridCacheSharedContext<Object, Object>)shared));
            this.testSetNextSnapshotId(this.getSnapshotMgr((GridCacheSharedContext<Object, Object>)shared), 2L, shared.cacheContexts());
            HashSet<FullPageId> markedPages = new HashSet<FullPageId>();
            for (FullPageId id : allIds) {
                if (!(rand.nextDouble() < 0.2)) continue;
                this.markDirty((PageSupport)this.memory((GridCacheSharedContext<Object, Object>)shared), markedPages, id);
            }
            for (Object cacheId0 : snapshotIdMap.keySet()) {
                snapshotIdMap.put((Integer)cacheId0, 1L);
                nextSnapshotTagMap.put((Integer)cacheId0, 3L);
            }
            PartitionAllocationMap map2 = new PartitionAllocationMap();
            FullPageIdIncrementalSnapshotIterableTest.updateAllocatedPages(map2, ((IgniteCacheProxy)ignite.cache(FIRST_CACHE)).context(), this.memory((GridCacheSharedContext<Object, Object>)shared), shared.pageStore());
            FullPageIdIncrementalSnapshotIterableTest.updateAllocatedPages(map2, ((IgniteCacheProxy)ignite.cache(SECOND_CACHE)).context(), this.memory((GridCacheSharedContext<Object, Object>)shared), shared.pageStore());
            for (Integer cacheId : this.grpIds) {
                for (int part = 0; part < 10; ++part) {
                    markedPages.add(new FullPageId(PageIdUtils.pageId((int)part, (byte)1, (int)0), cacheId.intValue()));
                }
                markedPages.add(new FullPageId(PageIdUtils.pageId((int)65535, (byte)2, (int)0), cacheId.intValue()));
            }
            FullPageIdIncrementalSnapshotIterable iterable2 = new FullPageIdIncrementalSnapshotIterable(shared, nextSnapshotTagMap, snapshotIdMap, map2);
            this.testSetNextSnapshotId(this.getSnapshotMgr((GridCacheSharedContext<Object, Object>)shared), 3L, shared.cacheContexts());
            for (FullPageId fullPageId : iterable2) {
                if (PageIdUtils.pageIndex((long)fullPageId.pageId()) != 0 && ((TrackingPageIO)TrackingPageIO.VERSIONS.latest()).trackingPageFor(fullPageId.pageId(), this.memory((GridCacheSharedContext<Object, Object>)shared).pageSize()) == fullPageId.pageId() || PageIdUtils.partId((long)fullPageId.pageId()) >= 10 && (PageIdUtils.partId((long)fullPageId.pageId()) != 65535 || PageIdUtils.pageIndex((long)fullPageId.pageId()) != 0)) continue;
                FullPageIdIncrementalSnapshotIterableTest.assertTrue((String)fullPageId.toString(), (boolean)markedPages.remove(fullPageId));
            }
            this.testConsistencyOfContainsAndNextMethods(iterable2);
            FullPageIdIncrementalSnapshotIterableTest.assertTrue((boolean)markedPages.isEmpty());
        }
        finally {
            this.getDbMgr((GridCacheSharedContext<Object, Object>)shared).checkpointReadUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testThatWeProperlyCachesTrackingPages() throws Exception {
        IgniteEx ignite = this.startGrid(0);
        ignite.active(true);
        GridCacheSharedContext shared = ignite.context().cache().context();
        this.getDbMgr((GridCacheSharedContext<Object, Object>)shared).enableCheckpoints(false).get();
        ArrayList<GridCacheContext> cacheCtxs = new ArrayList<GridCacheContext>();
        for (GridCacheContext context : shared.cacheContexts()) {
            if (!this.grpIds.contains(context.cacheId())) continue;
            cacheCtxs.add(context);
        }
        this.testSetNextSnapshotId(this.getSnapshotMgr((GridCacheSharedContext<Object, Object>)shared), 1L, cacheCtxs);
        PageMemoryEx mem = (PageMemoryEx)shared.cacheContext(CU.cacheId((String)FIRST_CACHE)).dataRegion().pageMemory();
        this.getDbMgr((GridCacheSharedContext<Object, Object>)shared).checkpointReadLock();
        try {
            long totalMemory = ignite.configuration().getDataStorageConfiguration().getDefaultDataRegionConfiguration().getMaxSize();
            long pagesToAllocate = this.calculateAllocatingPagesNumber(totalMemory, this.grpIds.size(), 10);
            for (Integer grpId : this.grpIds) {
                this.allocatePagesForCache(mem, new HashSet<FullPageId>(), grpId, 10, pagesToAllocate);
            }
        }
        finally {
            this.getDbMgr((GridCacheSharedContext<Object, Object>)shared).checkpointReadUnlock();
        }
        this.doCheckpoint(this.getDbMgr((GridCacheSharedContext<Object, Object>)shared));
        this.getDbMgr((GridCacheSharedContext<Object, Object>)shared).checkpointReadLock();
        try {
            this.completeSavingAllocatedIndex((GridCacheSharedContext<Object, Object>)shared, mem);
            this.testSetNextSnapshotId(this.getSnapshotMgr((GridCacheSharedContext<Object, Object>)shared), 2L, cacheCtxs);
            this.markDirty((PageSupport)mem, new HashSet<FullPageId>(), new FullPageId(PageIdUtils.pageId((int)0, (byte)1, (int)3), this.grpIds.get(0).intValue()));
            this.markDirty((PageSupport)mem, new HashSet<FullPageId>(), new FullPageId(PageIdUtils.pageId((int)0, (byte)1, (int)5), this.grpIds.get(1).intValue()));
            FullPageIdIncrementalSnapshotIterable iterable2 = this.getFullPageIdIterable(shared, shared.pageStore(), mem, cacheCtxs);
            long trackingPageId = PageIdUtils.pageId((int)0, (byte)1, (int)1);
            FullPageIdIncrementalSnapshotIterableTest.assertEquals((int)3, (int)PageIdUtils.pageIndex((long)iterable2.next(new FullPageId(trackingPageId, this.grpIds.get(0).intValue())).pageId()));
            FullPageIdIncrementalSnapshotIterableTest.assertEquals((int)5, (int)PageIdUtils.pageIndex((long)iterable2.next(new FullPageId(trackingPageId, this.grpIds.get(1).intValue())).pageId()));
            this.testConsistencyOfContainsAndNextMethods(iterable2);
        }
        finally {
            this.getDbMgr((GridCacheSharedContext<Object, Object>)shared).checkpointReadUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCaseWhenNextTrackingPageBetweenPageCounters() throws Exception {
        IgniteEx ignite = this.startGrid(0);
        ignite.cluster().active(true);
        GridCacheSharedContext shared = ignite.context().cache().context();
        int first = CU.cacheId((String)FIRST_CACHE);
        IgniteCache cache1 = ignite.getOrCreateCache(FIRST_CACHE);
        PageMemoryEx mem = (PageMemoryEx)shared.cacheContext(first).dataRegion().pageMemory();
        int pageToTrack = ((TrackingPageIO)TrackingPageIO.VERSIONS.latest()).countOfPageToTrack(mem.pageSize());
        PartitionAllocationMap map = new PartitionAllocationMap();
        map.put(new GroupPartitionId(first, 0), new PagesAllocationRange(pageToTrack - 10, pageToTrack + 10));
        GridCacheDatabaseSharedManager dbMgr = (GridCacheDatabaseSharedManager)shared.database();
        dbMgr.checkpointReadLock();
        try {
            long pageId;
            while (PageIdUtils.pageIndex((long)(pageId = mem.allocatePage(first, 0, (byte)1))) < 3) {
            }
        }
        finally {
            dbMgr.checkpointReadUnlock();
        }
        FullPageIdIncrementalSnapshotIterable iter = new FullPageIdIncrementalSnapshotIterable(shared, Collections.singletonMap(first, 1L), Collections.singletonMap(first, 0L), map);
        FullPageId next = iter.next(new FullPageId(PageIdUtils.pageId((int)0, (byte)1, (int)3), first));
        FullPageIdIncrementalSnapshotIterableTest.assertEquals((int)(pageToTrack - 10), (int)PageIdUtils.pageIndex((long)next.pageId()));
        this.testConsistencyOfContainsAndNextMethods(iter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCaseWhenTrackedPageBetweenCounters() throws Exception {
        IgniteEx ignite = this.startGrid(0);
        ignite.cluster().active(true);
        GridCacheSharedContext shared = ignite.context().cache().context();
        GridCacheDatabaseSharedManager db = this.getDbMgr((GridCacheSharedContext<Object, Object>)ignite.context().cache().context());
        TrackingPageIO io = (TrackingPageIO)TrackingPageIO.VERSIONS.latest();
        PartitionAllocationMap map = new PartitionAllocationMap();
        int first = CU.cacheId((String)FIRST_CACHE);
        IgniteCache cache1 = ignite.getOrCreateCache(FIRST_CACHE);
        map.put(new GroupPartitionId(first, 0), new PagesAllocationRange(101, 110));
        long trackingPageId = PageIdUtils.pageId((int)0, (byte)1, (int)1);
        PageMemoryEx mem = (PageMemoryEx)shared.cacheContext(first).dataRegion().pageMemory();
        db.checkpointReadLock();
        try {
            long pageId = mem.allocatePage(first, 0, (byte)1);
            FullPageIdIncrementalSnapshotIterableTest.assertTrue((pageId > trackingPageId ? 1 : 0) != 0);
            long page = mem.acquirePage(first, trackingPageId);
            try {
                long pointer = mem.writeLock(first, trackingPageId, page);
                try {
                    io.initNewPage(pointer, trackingPageId, mem.pageSize(), null);
                    io.markChanged(mem.pageBuffer(pointer), PageIdUtils.pageId((int)0, (byte)1, (int)102), 1L, 0L, mem.pageSize());
                }
                finally {
                    mem.writeUnlock(first, trackingPageId, page, null, true);
                }
            }
            finally {
                mem.releasePage(first, trackingPageId, page);
            }
        }
        finally {
            db.checkpointReadUnlock();
        }
        FullPageIdIncrementalSnapshotIterable iter = new FullPageIdIncrementalSnapshotIterable(shared, Collections.singletonMap(first, 1L), Collections.singletonMap(first, 0L), map);
        FullPageId next = iter.next(new FullPageId(PageIdUtils.pageId((int)0, (byte)1, (int)3), first));
        FullPageIdIncrementalSnapshotIterableTest.assertEquals((int)101, (int)PageIdUtils.pageIndex((long)next.pageId()));
        this.testConsistencyOfContainsAndNextMethods(iter);
    }

    @Test
    public void testContains() throws Exception {
        int first = CU.cacheId((String)FIRST_CACHE);
        IgniteEx ex = this.startGrid(0);
        ex.active(true);
        PartitionAllocationMap map = new PartitionAllocationMap();
        int part = 0;
        map.put(new GroupPartitionId(first, part), new PagesAllocationRange(100, 110));
        FullPageIdIncrementalSnapshotIterable iter = new FullPageIdIncrementalSnapshotIterable(ex.context().cache().context(), Collections.singletonMap(first, 1L), Collections.singletonMap(first, 0L), map);
        FullPageIdIncrementalSnapshotIterableTest.assertTrue((boolean)iter.contains(new FullPageId(PageIdUtils.pageId((int)part, (byte)1, (int)0), first)));
        FullPageIdIncrementalSnapshotIterableTest.assertTrue((boolean)iter.contains(new FullPageId(PageIdUtils.pageId((int)part, (byte)1, (int)100), first)));
        FullPageIdIncrementalSnapshotIterableTest.assertFalse((boolean)iter.contains(new FullPageId(PageIdUtils.pageId((int)part, (byte)1, (int)111), first)));
    }

    @Test
    public void testPagesWrittenTracker() {
        TreeSet<FullPageId> fullPageIds = this.generatePageList();
        System.err.println("size=" + fullPageIds.size());
        TestPageIdIterable iterable = new TestPageIdIterable(fullPageIds);
        for (int i = 0; i < 10; ++i) {
            System.err.println("iter=" + i);
            ArrayList<FullPageId> history = new ArrayList<FullPageId>(fullPageIds);
            Collections.shuffle(history);
            PagesWrittenTracker tracker = new PagesWrittenTracker((PageIdIterable)iterable, log, null);
            for (FullPageId fullPageId : history) {
                tracker.add(fullPageId);
            }
            FullPageIdIncrementalSnapshotIterableTest.assertTrue((boolean)tracker.isComplete());
        }
    }

    @Test
    public void testConsistencyOfContainsAndNextMethodsWhenEmptyPartitionsAmongNotEmpty() throws Exception {
        int grpId = CU.cacheId((String)FIRST_CACHE);
        IgniteEx ex = this.startGrid(0);
        ex.cluster().active(true);
        PartitionAllocationMap map = new PartitionAllocationMap();
        map.put(new GroupPartitionId(grpId, 0), new PagesAllocationRange(100, 110));
        map.put(new GroupPartitionId(grpId, 1), new PagesAllocationRange(0, 0));
        map.put(new GroupPartitionId(grpId, 2), new PagesAllocationRange(100, 110));
        FullPageIdIncrementalSnapshotIterable iter = new FullPageIdIncrementalSnapshotIterable(ex.context().cache().context(), Collections.singletonMap(grpId, 1L), Collections.singletonMap(grpId, 0L), map);
        FullPageIdIncrementalSnapshotIterableTest.assertEquals((Object)iter.next(new FullPageId(PageIdUtils.pageId((int)0, (byte)1, (int)110), grpId)), (Object)new FullPageId(PageIdUtils.pageId((int)2, (byte)1, (int)0), grpId));
        FullPageIdIncrementalSnapshotIterableTest.assertFalse((boolean)iter.contains(new FullPageId(PageIdUtils.pageId((int)1, (byte)1, (int)0), grpId)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProgress() throws Exception {
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        IgniteEx ignite = this.startGrid(0);
        ignite.cluster().active(true);
        GridCacheSharedContext shared = ignite.context().cache().context();
        this.getDbMgr((GridCacheSharedContext<Object, Object>)shared).enableCheckpoints(false).get();
        HashSet<FullPageId> allIds = new HashSet<FullPageId>();
        HashMap<Integer, Long> snapshotIdMap = new HashMap<Integer, Long>();
        HashMap<Integer, Long> nextSnapshotIdMap = new HashMap<Integer, Long>();
        PartitionAllocationMap map = this.allocatePagesAndGetPartitionAllocationMap(ignite, (GridCacheSharedContext<Object, Object>)shared, snapshotIdMap, nextSnapshotIdMap, allIds);
        FullPageIdIncrementalSnapshotIterable incrementalIterable = new FullPageIdIncrementalSnapshotIterable(shared, nextSnapshotIdMap, snapshotIdMap, map);
        this.doCheckpoint(this.getDbMgr((GridCacheSharedContext<Object, Object>)shared));
        this.getDbMgr((GridCacheSharedContext<Object, Object>)shared).checkpointReadLock();
        try {
            this.completeSavingAllocatedIndex((GridCacheSharedContext<Object, Object>)shared, this.memory((GridCacheSharedContext<Object, Object>)shared));
            this.testSetNextSnapshotId(this.getSnapshotMgr((GridCacheSharedContext<Object, Object>)shared), 2L, shared.cacheContexts());
            for (FullPageId id : allIds) {
                if (!(rand.nextDouble() < 0.5)) continue;
                this.markDirty((PageSupport)this.memory((GridCacheSharedContext<Object, Object>)shared), id);
            }
            for (Integer cacheId0 : snapshotIdMap.keySet()) {
                snapshotIdMap.put(cacheId0, 1L);
                nextSnapshotIdMap.put(cacheId0, 2L);
            }
            PagesWrittenTracker tracker = new PagesWrittenTracker((PageIdIterable)incrementalIterable, log, null);
            tracker.reportCheckpointWrittenPages(0, 0);
            this.iterateOverAndCheckProgress(map, (PageIdIterable)incrementalIterable, tracker);
            PagesWrittenTracker tracker2 = new PagesWrittenTracker((PageIdIterable)incrementalIterable, log, null);
            tracker2.reportCheckpointWrittenPages(0, 0);
            FullPageIdIterable fullIterable = new FullPageIdIterable(shared, nextSnapshotIdMap, snapshotIdMap, map);
            this.iterateOverAndCheckProgress(map, (PageIdIterable)fullIterable, tracker2);
        }
        finally {
            this.getDbMgr((GridCacheSharedContext<Object, Object>)shared).checkpointReadUnlock();
        }
    }

    private void testConsistencyOfContainsAndNextMethods(FullPageIdIncrementalSnapshotIterable iter) {
        HashSet<FullPageId> allPageIds = new HashSet<FullPageId>();
        for (FullPageId fullPageId : iter) {
            FullPageIdIncrementalSnapshotIterableTest.assertTrue((String)"Duplicates in iterable!", (boolean)allPageIds.add(fullPageId));
            FullPageIdIncrementalSnapshotIterableTest.assertTrue((boolean)iter.contains(fullPageId));
        }
        for (Integer cacheId : this.grpIds) {
            for (int i = 0; i < 32; ++i) {
                for (int j = 0; j < 1000; ++j) {
                    long pageId = PageIdUtils.pageId((int)i, (byte)1, (int)j);
                    FullPageId fullPageId = new FullPageId(pageId, cacheId.intValue());
                    FullPageIdIncrementalSnapshotIterableTest.assertEquals((boolean)iter.contains(fullPageId), (boolean)allPageIds.contains(fullPageId));
                }
            }
            for (int j = 0; j < 1000; ++j) {
                long pageId = PageIdUtils.pageId((int)65535, (byte)2, (int)j);
                FullPageId fullPageId = new FullPageId(pageId, cacheId.intValue());
                FullPageIdIncrementalSnapshotIterableTest.assertEquals((boolean)iter.contains(fullPageId), (boolean)allPageIds.contains(fullPageId));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private PartitionAllocationMap allocatePagesAndGetPartitionAllocationMap(IgniteEx ignite, GridCacheSharedContext<Object, Object> shared, Map<Integer, Long> snapshotIdMap, Map<Integer, Long> nextSnapshotTagMap, Set<FullPageId> allIds) throws IgniteCheckedException {
        PartitionAllocationMap map = new PartitionAllocationMap();
        this.getDbMgr(shared).checkpointReadLock();
        try {
            long totalMemory = ignite.configuration().getDataStorageConfiguration().getDefaultDataRegionConfiguration().getMaxSize();
            long pagesToAllocate = this.calculateAllocatingPagesNumber(totalMemory, this.grpIds.size(), 10);
            for (Integer cacheId : this.grpIds) {
                this.allocatePagesForCache(this.memory(shared), allIds, cacheId, 10, pagesToAllocate);
            }
            for (GridCacheContext cacheCtx : shared.cacheContexts()) {
                snapshotIdMap.put(cacheCtx.cacheId(), 0L);
                nextSnapshotTagMap.put(cacheCtx.cacheId(), 1L);
                if (!cacheCtx.dataRegion().config().isPersistenceEnabled()) continue;
                FullPageIdIncrementalSnapshotIterableTest.updateAllocatedPages(map, cacheCtx, (PageMemoryEx)cacheCtx.dataRegion().pageMemory(), shared.pageStore());
            }
        }
        finally {
            map.prepareForSnapshot();
            this.getDbMgr(shared).checkpointReadUnlock();
        }
        return map;
    }

    private void completeSavingAllocatedIndex(GridCacheSharedContext<Object, Object> shared, PageMemoryEx mem) throws IgniteCheckedException {
        SnapshotCreateFuture createFut = new SnapshotCreateFuture(1, IgniteUuid.randomUuid(), true, UUID.randomUUID(), new GridFutureAdapter(), new GridFutureAdapter(), this.getSnapshotMgr(shared), shared, new SnapshotConfiguration(), new SnapshotMetricsMXBeanImpl(new File(U.defaultWorkDirectory())), false);
        for (Integer cacheId : this.grpIds) {
            for (int part = 0; part < 10; ++part) {
                FullPageIdIncrementalSnapshotIterableTest.setCandidateAllocatedIndex(mem, this.getStoreMgr(shared), cacheId, part);
                createFut.completeSavingAllocatedIndex(mem, shared.wal(), cacheId.intValue(), part);
            }
        }
    }

    private FilePageStoreManager getStoreMgr(GridCacheSharedContext<Object, Object> shared) {
        return (FilePageStoreManager)shared.pageStore();
    }

    private void doCheckpoint(GridCacheDatabaseSharedManager dbMgr) throws IgniteCheckedException {
        dbMgr.enableCheckpoints(true).get();
        dbMgr.waitForCheckpoint("");
        dbMgr.enableCheckpoints(false).get();
    }

    @NotNull
    private FullPageIdIncrementalSnapshotIterable getFullPageIdIterable(GridCacheSharedContext sharedCtx, IgnitePageStoreManager storeMgr, PageMemoryEx mem, Collection<GridCacheContext> cacheCtxs) throws IgniteCheckedException {
        HashMap<Integer, Long> snapshotIdMap = new HashMap<Integer, Long>();
        HashMap<Integer, Long> nextSnapshotTagMap = new HashMap<Integer, Long>();
        PartitionAllocationMap map = new PartitionAllocationMap();
        for (GridCacheContext cacheCtx : cacheCtxs) {
            snapshotIdMap.put(cacheCtx.cacheId(), 1L);
            nextSnapshotTagMap.put(cacheCtx.cacheId(), 3L);
            if (!cacheCtx.dataRegion().config().isPersistenceEnabled()) continue;
            FullPageIdIncrementalSnapshotIterableTest.updateAllocatedPages(map, cacheCtx, mem, storeMgr);
        }
        return new FullPageIdIncrementalSnapshotIterable(sharedCtx, nextSnapshotTagMap, snapshotIdMap, map);
    }

    private void markDirty(PageSupport mem, Collection<FullPageId> markedPages, FullPageId id) throws IgniteCheckedException {
        markedPages.add(id);
        this.markDirty(mem, id);
    }

    private void markDirty(PageSupport mem, FullPageId id) throws IgniteCheckedException {
        long page = mem.acquirePage(id.groupId(), id.pageId());
        mem.writeLock(id.groupId(), id.pageId(), page);
        mem.writeUnlock(id.groupId(), id.pageId(), page, null, true);
        mem.releasePage(id.groupId(), id.pageId(), page);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setCandidateAllocatedIndex(PageMemoryEx pageMem, FilePageStoreManager storeMgr, int cacheId, int part) throws IgniteCheckedException {
        long pageId = pageMem.partitionMetaPageId(cacheId, part);
        long pageApsPtr = pageMem.acquirePage(cacheId, pageId);
        try {
            long pageAddr = pageMem.writeLock(cacheId, pageId, pageApsPtr);
            try {
                ((PageMetaIO)PageMetaIO.VERSIONS.latest()).setCandidatePageCount(pageAddr, storeMgr.pages(cacheId, part));
            }
            finally {
                pageMem.writeUnlock(cacheId, pageId, pageApsPtr, null, true);
            }
        }
        finally {
            pageMem.releasePage(cacheId, pageId, pageApsPtr);
        }
    }

    private void testSetNextSnapshotId(GridCacheSnapshotManager snapshotMgr, long nextSnapshotId, Collection<GridCacheContext> cacheCtxs) {
        ConcurrentMap nextSnapshotIdsForCache = (ConcurrentMap)GridTestUtils.getFieldValue((Object)snapshotMgr, (String[])new String[]{"nextSnapshotTagForCacheGrp"});
        ConcurrentMap lastSuccessfulSnapshotIdsForCache = (ConcurrentMap)GridTestUtils.getFieldValue((Object)snapshotMgr, (String[])new String[]{"lastSuccessfulSnapshotTagForCacheGrp"});
        for (GridCacheContext ctx : cacheCtxs) {
            nextSnapshotIdsForCache.put(ctx.cacheId(), nextSnapshotId);
            lastSuccessfulSnapshotIdsForCache.put(ctx.cacheId(), 0L);
        }
    }

    private void allocatePagesForCache(PageMemoryEx pageMem, Set<FullPageId> allocatedPages, int grpId, int partitions, long pagesToAllocate) throws IgniteCheckedException {
        long metaPageId = PageMemory.META_PAGE_ID;
        this.initAndRelease(pageMem, grpId, metaPageId, pageMem.acquirePage(grpId, metaPageId));
        allocatedPages.add(new FullPageId(metaPageId, grpId));
        for (int part = 0; part < partitions; ++part) {
            long superPageId = pageMem.partitionMetaPageId(grpId, part);
            this.initAndRelease(pageMem, grpId, superPageId, pageMem.acquirePage(grpId, superPageId));
            allocatedPages.add(new FullPageId(superPageId, grpId));
            for (long i = 0L; i < pagesToAllocate; ++i) {
                long pageId = this.allocatePage(pageMem, grpId, part);
                allocatedPages.add(new FullPageId(pageId, grpId));
            }
        }
    }

    private long calculateAllocatingPagesNumber(long totalPageMemory, int caches, int partitionsPerCache) {
        double overhead = 2.5;
        int pageSize = 4096;
        long memoryToAllocatePerPartition = (long)((double)(totalPageMemory / (long)caches / (long)partitionsPerCache) / 2.5);
        long pagesToAllocatePerPartition = memoryToAllocatePerPartition / (long)pageSize;
        long canTrackWinOnePage = ((TrackingPageIO)TrackingPageIO.VERSIONS.latest()).countOfPageToTrack(pageSize);
        long trackingPages = pagesToAllocatePerPartition / canTrackWinOnePage + 1L;
        return pagesToAllocatePerPartition - trackingPages;
    }

    private long allocatePage(PageMemoryEx pageMem, int cacheId, int part) throws IgniteCheckedException {
        long pageId = pageMem.allocatePage(cacheId, part, (byte)1);
        this.initAndRelease(pageMem, cacheId, pageId, pageMem.acquirePage(cacheId, pageId));
        return pageId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAndRelease(PageMemoryEx ex, int grpId, long pageId, long page) {
        try {
            long pageAddr = ex.writeLock(grpId, pageId, page);
            pageMetaIO.initNewPage(pageAddr, pageId, ex.pageSize(), null);
            ex.writeUnlock(grpId, pageId, page, null, true);
        }
        finally {
            ex.releasePage(grpId, pageId, page);
        }
    }

    private void deleteWorkFiles() throws Exception {
        this.cleanPersistenceDir();
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"snapshot", (boolean)false));
    }

    static void updateAllocatedPages(PartitionAllocationMap map, GridCacheContext ctx, PageMemoryEx pageMem, IgnitePageStoreManager storeMgr) throws IgniteCheckedException {
        FullPageIdIncrementalSnapshotIterableTest.addPartition(map, pageMem, ctx.cacheId(), 65535, storeMgr.pages(ctx.cacheId(), 65535));
        GridDhtPartitionMap partMap = ctx.topology().localPartitionMap();
        int partCnt = ctx.affinity().partitions();
        for (int part = 0; part < partCnt; ++part) {
            if (!partMap.containsKey(Integer.valueOf(part)) || partMap.get(Integer.valueOf(part)) != GridDhtPartitionState.OWNING) continue;
            FullPageIdIncrementalSnapshotIterableTest.addPartition(map, pageMem, ctx.cacheId(), part, storeMgr.pages(ctx.cacheId(), part));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addPartition(PartitionAllocationMap map, PageMemoryEx pageMem, int cacheId, int partition, int pages) throws IgniteCheckedException {
        if (pages <= 1) {
            return;
        }
        long superPageId = FullPageIdIncrementalSnapshotIterableTest.getSuperPage(pageMem, cacheId, partition);
        long superPage = pageMem.acquirePage(cacheId, superPageId);
        try {
            long pageAddr = pageMem.writeLock(cacheId, superPageId, superPage);
            try {
                assert (PageIO.getPageId((long)pageAddr) != 0L);
                int lastAllocatedIdx = metaIO.getLastAllocatedPageCount(pageAddr);
                map.put(new GroupPartitionId(cacheId, partition), new PagesAllocationRange(lastAllocatedIdx, pages));
                metaIO.setCandidatePageCount(pageAddr, pages);
            }
            finally {
                pageMem.writeUnlock(cacheId, superPageId, superPage, null, true);
            }
        }
        finally {
            pageMem.releasePage(cacheId, superPageId, superPage);
        }
    }

    private static long getSuperPage(PageMemoryEx pageMem, int cacheId, int part) {
        return part == 65535 ? PageMemory.META_PAGE_ID : pageMem.partitionMetaPageId(cacheId, part);
    }

    private TreeSet<FullPageId> generatePageList() {
        TreeSet<FullPageId> res = new TreeSet<FullPageId>((Comparator<FullPageId>)new SnapshotCreateFuture.FullPageIdComparator());
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int grpCnt = random.nextInt(0, 20);
        for (int i = 0; i < grpCnt; ++i) {
            int grpId = random.nextInt(10, Integer.MAX_VALUE);
            int partCnt = (int)Math.pow(2.0, random.nextInt(0, 10));
            for (int part = 0; part < partCnt; ++part) {
                int pageCnt = random.nextInt(1, 1000);
                int sizeBefore = res.size();
                while (pageCnt >= res.size() - sizeBefore) {
                    int idx = random.nextInt(0, pageCnt * 10);
                    res.add(new FullPageId(PageIdUtils.pageId((int)part, (byte)1, (int)idx), grpId));
                }
            }
        }
        return res;
    }

    private void iterateOverAndCheckProgress(PartitionAllocationMap map, PageIdIterable iterable, PagesWrittenTracker tracker) {
        int prevReported = 0;
        double prevProgress = 0.0;
        int nextCalled = 0;
        PageIdIterable.CountingIterator iter = iterable.iterator();
        while (iter.hasNext()) {
            FullPageId next = (FullPageId)iter.next();
            ++nextCalled;
            assert (map.containsKey(PartitionAllocationMap.createCachePartId((FullPageId)next)));
            int curCnt = iter.currentInternalCount();
            int totCnt = iter.totalInternalCount();
            tracker.reportWrittenSnapshotPages(curCnt, totCnt);
            double curProgress = tracker.progress();
            assert (curProgress >= prevProgress);
            if (log.isTraceEnabled()) {
                log.trace("nextCalled=" + nextCalled + "; Iterated over " + curCnt + " from " + totCnt + " -> " + curProgress);
            }
            assert (totCnt > 0);
            assert (curCnt >= prevReported);
            prevReported = curCnt;
            assert (curCnt <= totCnt) : " cur " + curCnt + " tot " + totCnt;
        }
        double progress = tracker.progress();
        assert (progress > 0.99) : "Progress " + progress;
    }

    private GridCacheSnapshotManager getSnapshotMgr(GridCacheSharedContext<Object, Object> shared) {
        return (GridCacheSnapshotManager)shared.snapshot();
    }

    private PageMemoryEx memory(GridCacheSharedContext<Object, Object> shared) throws IgniteCheckedException {
        return (PageMemoryEx)this.getDbMgr(shared).dataRegion(null).pageMemory();
    }

    private GridCacheDatabaseSharedManager getDbMgr(GridCacheSharedContext<Object, Object> shared) {
        return (GridCacheDatabaseSharedManager)shared.database();
    }

    static class TestPageIdIterable
    implements PageIdIterable {
        private final TreeSet<FullPageId> fullPageId;

        TestPageIdIterable(TreeSet<FullPageId> fullPageId) {
            this.fullPageId = fullPageId;
        }

        public boolean contains(@NotNull FullPageId fullId) {
            return this.fullPageId.contains(fullId);
        }

        @Nullable
        public FullPageId next(@Nullable FullPageId fullId) {
            if (fullId == null) {
                return this.fullPageId.first();
            }
            return this.fullPageId.higher(fullId);
        }

        public Set<FullPageId> corruptedTrackingPages() {
            return Collections.emptySet();
        }

        public boolean isEmpty() {
            return this.fullPageId.isEmpty();
        }

        public int getTotalPageCnt() {
            return this.fullPageId.size();
        }

        @NotNull
        public PageIdIterable.CountingIterator<FullPageId> iterator() {
            return new PageIdIterable.CountingIterator<FullPageId>(){
                private final Iterator<FullPageId> iter;
                {
                    this.iter = fullPageId.iterator();
                }

                public int currentInternalCount() {
                    return 0;
                }

                public int totalInternalCount() {
                    return 0;
                }

                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                public FullPageId next() {
                    return this.iter.next();
                }
            };
        }
    }
}

