/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.ListeningTestLogger;
import org.apache.ignite.testframework.LogListener;
import org.apache.ignite.testframework.junits.SystemPropertiesRule;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.processors.cache.database.snapshot.BrokenTrackingPageLogger;
import org.gridgain.grid.persistentstore.GridSnapshot;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TestRule;

public class BrokenTrackingPageLogTest
extends GridCommonAbstractTest {
    @ClassRule
    public static final TestRule classRule = new SystemPropertiesRule();
    private static ListeningTestLogger testLog;
    private static final String LOG_PREFIX;

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        testLog = new ListeningTestLogger(false, log);
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
        testLog.clearListeners();
        super.afterTest();
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setGridLogger((IgniteLogger)testLog).setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true))).setCacheConfiguration(this.cacheConfigs()).setPluginConfigurations(new PluginConfiguration[]{new GridGainConfiguration().setSnapshotConfiguration(new SnapshotConfiguration().setPointInTimeRecoveryEnabled(true))});
    }

    @Test
    @WithSystemProperty(key="IGNITE_BROKEN_TRACKING_PAGE_LOG_BATCH_SIZE", value="0")
    public void testOnlyOneLogMessage() throws Exception {
        LogListener logLsnr = LogListener.matches(logStr -> logStr.contains(LOG_PREFIX) && logStr.contains("IGNITE_BROKEN_TRACKING_PAGE_LOG_BATCH_SIZE")).times(1).build();
        this.emulatedBrokenTrackingPages(logLsnr, true);
        BrokenTrackingPageLogTest.assertTrue((boolean)logLsnr.check());
    }

    @Test
    @WithSystemProperty(key="IGNITE_BROKEN_TRACKING_PAGE_LOG_BATCH_SIZE", value="5")
    public void testBatchLog() throws Exception {
        int partitions = Stream.of(this.cacheConfigs()).map(CacheConfiguration::getAffinity).mapToInt(AffinityFunction::partitions).sum();
        LogListener logLsnr = LogListener.matches(logStr -> logStr.contains(LOG_PREFIX) && !logStr.contains("IGNITE_BROKEN_TRACKING_PAGE_LOG_BATCH_SIZE")).times(partitions / 5).build();
        this.emulatedBrokenTrackingPages(logLsnr, true);
        BrokenTrackingPageLogTest.assertTrue((boolean)logLsnr.check());
    }

    @Test
    @WithSystemProperty(key="IGNITE_BROKEN_TRACKING_PAGE_LOG_BATCH_SIZE", value="0")
    public void testNoLogMessage() throws Exception {
        LogListener logLsnr = LogListener.matches((String)LOG_PREFIX).times(0).build();
        this.emulatedBrokenTrackingPages(logLsnr, false);
        BrokenTrackingPageLogTest.assertTrue((boolean)logLsnr.check());
    }

    private CacheConfiguration[] cacheConfigs() {
        return new CacheConfiguration[]{new CacheConfiguration("default").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 10))};
    }

    private void emulatedBrokenTrackingPages(LogListener logLsnr, boolean brake) throws Exception {
        assert (Objects.nonNull(logLsnr));
        IgniteEx crd = this.startGrid();
        crd.cluster().active(true);
        this.awaitPartitionMapExchange();
        IgniteCache[] caches = (IgniteCache[])Stream.of(this.cacheConfigs()).map(CacheConfiguration::getName).map(arg_0 -> ((IgniteEx)crd).cache(arg_0)).toArray(IgniteCache[]::new);
        this.fillCache(1000, caches);
        this.createSnapshot((Ignite)crd, true);
        this.fillCache(1000, caches);
        this.createSnapshot((Ignite)crd, false);
        testLog.registerListener(logLsnr);
        if (brake) {
            ((Map)GridTestUtils.getFieldValue((Object)crd.context().cache().context().snapshot(), (String[])new String[]{"nextSnapshotTagForCacheGrp"})).clear();
        }
        this.fillCache(1000, caches);
    }

    private void createSnapshot(Ignite node, boolean full) {
        assert (Objects.nonNull(node));
        GridSnapshot snapshot = ((GridGain)node.plugin("GridGain")).snapshot();
        SnapshotFuture snapshotFut = full ? snapshot.createFullSnapshot(null, "FULL SNAP") : snapshot.createSnapshot(null, "INC SNAP");
        snapshotFut.get();
    }

    private void fillCache(int cnt, IgniteCache<Object, Object> ... caches) {
        assert (Objects.nonNull(caches));
        for (IgniteCache<Object, Object> cache : caches) {
            for (long i = 0L; i < (long)cnt; ++i) {
                cache.put((Object)i, (Object)("name_" + i));
            }
        }
    }

    static {
        LOG_PREFIX = (String)GridTestUtils.getFieldValue(BrokenTrackingPageLogger.class, (String[])new String[]{"LOG_PREFIX"});
    }
}

