/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.recovery;

import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.ignite.Ignite;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.processors.cache.database.GridSnapshotEx;
import org.gridgain.grid.internal.processors.cache.database.RecoveryParams;
import org.gridgain.grid.internal.processors.cache.database.recovery.GridPointInTimeRecoveryAbstractTest;
import org.gridgain.grid.internal.processors.cache.database.snapshot.sftp.InmemorySftpServerRule;
import org.gridgain.grid.persistentstore.MoveSnapshotParams;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotInfo;
import org.gridgain.grid.persistentstore.SnapshotPath;
import org.junit.Rule;
import org.junit.Test;

public class GridPointInTimeRecoverySharedSftpFolderTest
extends GridPointInTimeRecoveryAbstractTest {
    private int walSegmentSize = 0x4000000;
    @Rule
    public InmemorySftpServerRule server = new InmemorySftpServerRule().addUser("user", "password");

    @Override
    protected CacheConfiguration[] prepareCachesConfiguration() {
        return new CacheConfiguration[]{new CacheConfiguration().setName("default").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32))};
    }

    @Override
    protected IgniteConfiguration getConfiguration(String name) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(name);
        cfg.getDataStorageConfiguration().setWalSegmentSize(this.walSegmentSize);
        return cfg;
    }

    @Override
    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.walSegmentSize = 0x4000000;
    }

    @Test
    public void testRecoveryFromSecondSnapshot() throws Exception {
        IgniteEx ig0 = this.startGrids(1);
        ig0.cluster().active(true);
        GridPointInTimeRecoveryAbstractTest.TestContext test = new GridPointInTimeRecoveryAbstractTest.TestContext((Ignite)ig0, "default");
        test.loadByTime(1000L);
        GridGain gg0 = (GridGain)ig0.plugin("GridGain");
        GridSnapshotEx snp = (GridSnapshotEx)gg0.snapshot();
        GridPointInTimeRecoverySharedSftpFolderTest.assertNotNull((Object)snp);
        SnapshotFuture full = snp.createFullSnapshot(null, null);
        full.get();
        test.loadByTime(1000L);
        GridPointInTimeRecoveryAbstractTest.RecoveryPoint p = test.savePoint();
        test.loadByTime(1000L);
        SnapshotFuture full2 = snp.createFullSnapshot(null, null);
        full2.get();
        List infos = snp.list();
        GridPointInTimeRecoverySharedSftpFolderTest.assertEquals((int)3, (int)infos.size());
        infos.sort(SnapshotIdComparator.INSTANCE);
        SnapshotPath sharedFolder = SnapshotPath.sftp().uri(new URI("sftp://user:password@127.0.0.1:" + this.server.getPort() + "/folder")).build();
        this.moveTheChainOfSnapshots(((SnapshotInfo)infos.get(1)).snapshotId(), sharedFolder, snp);
        SnapshotFuture recoveryFut = snp.recoveryTo(new RecoveryParams().time(p.time).message("Recovery from shared folder (without restart).").optionalSearchPaths(Collections.singleton(sharedFolder)));
        recoveryFut.get();
        test.checkPoint(p, G.allGrids());
    }

    protected void moveTheChainOfSnapshots(long id, SnapshotPath sharedFolder, GridSnapshotEx snp) {
        snp.move(new MoveSnapshotParams().snapshotId(id).destinationPath(sharedFolder)).get();
    }

    @Override
    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"shared", (boolean)false));
    }

    protected void afterTestsStopped() throws Exception {
        super.afterTestsStopped();
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"shared", (boolean)false));
    }

    protected static class SnapshotIdComparator
    implements Comparator<SnapshotInfo> {
        static final SnapshotIdComparator INSTANCE = new SnapshotIdComparator();

        protected SnapshotIdComparator() {
        }

        @Override
        public int compare(SnapshotInfo o1, SnapshotInfo o2) {
            return Long.compare(o1.snapshotId(), o2.snapshotId());
        }
    }
}

