/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.recovery;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.transactions.Transaction;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.GridGainImpl;
import org.gridgain.grid.internal.processors.cache.database.GridSnapshotEx;
import org.gridgain.grid.internal.processors.cache.database.recovery.GridPointInTimeRecoveryAbstractTest;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotInfo;
import org.junit.Assert;
import org.junit.Test;

public class GridPointInTimeRecoverySharedFolderTest
extends GridPointInTimeRecoveryAbstractTest {
    private int walSegmentSize = 0x4000000;

    @Override
    protected CacheConfiguration[] prepareCachesConfiguration() {
        return new CacheConfiguration[]{new CacheConfiguration().setName("default").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32))};
    }

    @Override
    protected IgniteConfiguration getConfiguration(String name) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(name);
        cfg.getDataStorageConfiguration().setWalSegmentSize(this.walSegmentSize);
        return cfg;
    }

    @Override
    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.walSegmentSize = 0x4000000;
    }

    protected long getTestTimeout() {
        return super.getTestTimeout() * 2L;
    }

    @Test
    public void testRecoveryFromFirstSnapshot() throws Exception {
        this.consistentIdPrefix = "OLD";
        IgniteEx ig0 = this.startGrids(4);
        ig0.cluster().active(true);
        GridPointInTimeRecoveryAbstractTest.TestContext test = new GridPointInTimeRecoveryAbstractTest.TestContext((Ignite)ig0, "default");
        test.loadByTime(5000L);
        GridPointInTimeRecoveryAbstractTest.RecoveryPoint p = test.savePoint();
        test.loadByTime(2000L);
        GridGain gg0 = (GridGain)ig0.plugin("GridGain");
        GridSnapshotEx snp = (GridSnapshotEx)gg0.snapshot();
        GridPointInTimeRecoverySharedFolderTest.assertNotNull((Object)snp);
        SnapshotFuture full = snp.createFullSnapshot(null, null);
        full.get();
        List infos = snp.list();
        GridPointInTimeRecoverySharedFolderTest.assertEquals((int)2, (int)infos.size());
        long activationSnapshotId = Collections.min(infos, SnapshotIdComparator.INSTANCE).snapshotId();
        File sharedFolder = this.createSharedFolder();
        this.moveSnapshot(activationSnapshotId, sharedFolder, snp);
        SnapshotFuture recoveryFut = snp.recoveryTo(p.time, Collections.singleton(sharedFolder), null, "Recovery from shared folder (first snapshot).");
        recoveryFut.get();
        this.awaitPartitionMapExchange();
        this.waitForRebalancing();
        test.checkPoint(p, G.allGrids());
    }

    @Test
    public void testRecoveryFromSecondSnapshot() throws Exception {
        IgniteEx ig0 = this.startGrids(4);
        ig0.cluster().active(true);
        GridPointInTimeRecoveryAbstractTest.TestContext test = new GridPointInTimeRecoveryAbstractTest.TestContext((Ignite)ig0, "default");
        test.loadByTime(5000L);
        GridGain gg0 = (GridGain)ig0.plugin("GridGain");
        GridSnapshotEx snp = (GridSnapshotEx)gg0.snapshot();
        GridPointInTimeRecoverySharedFolderTest.assertNotNull((Object)snp);
        SnapshotFuture full = snp.createFullSnapshot(null, null);
        full.get();
        test.loadByTime(5000L);
        GridPointInTimeRecoveryAbstractTest.RecoveryPoint p = test.savePoint();
        test.loadByTime(2000L);
        SnapshotFuture full2 = snp.createFullSnapshot(null, null);
        full2.get();
        List infos = snp.list();
        GridPointInTimeRecoverySharedFolderTest.assertEquals((int)3, (int)infos.size());
        infos.sort(SnapshotIdComparator.INSTANCE);
        File sharedFolder = this.createSharedFolder();
        this.moveTheChainOfSnapshots(((SnapshotInfo)infos.get(1)).snapshotId(), sharedFolder, snp);
        SnapshotFuture recoveryFut = snp.recoveryTo(p.time, Collections.singleton(sharedFolder), null, "Recovery from shared folder (without restart).");
        recoveryFut.get();
        test.checkPoint(p, G.allGrids());
    }

    @Test
    public void testRecoveryOnCleanGridWithSameTopology() throws Exception {
        this.testRecoveryOnCleanGrid(4);
    }

    @Test
    public void testRecoveryOnCleanGridWithBiggerTopology() throws Exception {
        this.testRecoveryOnCleanGrid(5);
    }

    @Test
    public void testRecoveryOnCleanGridWithSmallerTopology() throws Exception {
        this.testRecoveryOnCleanGrid(3);
    }

    @Test
    public void testCannotMoveLatestSnapshot() throws Exception {
        IgniteEx ig0 = this.startGrids(4);
        ig0.cluster().active(true);
        GridPointInTimeRecoveryAbstractTest.TestContext test = new GridPointInTimeRecoveryAbstractTest.TestContext((Ignite)ig0, "default");
        test.loadByTime(5000L);
        GridGain gg0 = (GridGain)ig0.plugin("GridGain");
        GridSnapshotEx snp = (GridSnapshotEx)gg0.snapshot();
        GridPointInTimeRecoverySharedFolderTest.assertNotNull((Object)snp);
        SnapshotFuture full = snp.createFullSnapshot(null, null);
        full.get();
        File sharedFolder = this.createSharedFolder();
        try {
            this.moveSnapshot(full.snapshotOperation().snapshotId(), sharedFolder, snp);
        }
        catch (Throwable h) {
            U.log((IgniteLogger)log, (Object)"Expected exception", (Object)h);
            return;
        }
        GridPointInTimeRecoverySharedFolderTest.fail((String)"Attempt to move latest snapshot should fail.");
    }

    public void ttestDeleteSnapshotInTheMiddle() throws Exception {
        IgniteEx ig0 = this.startGrids(4);
        ig0.cluster().active(true);
        GridPointInTimeRecoveryAbstractTest.TestContext test = new GridPointInTimeRecoveryAbstractTest.TestContext((Ignite)ig0, "default");
        test.loadByTime(5000L);
        GridGain gg0 = (GridGain)ig0.plugin("GridGain");
        GridSnapshotEx snp = (GridSnapshotEx)gg0.snapshot();
        GridPointInTimeRecoverySharedFolderTest.assertNotNull((Object)snp);
        SnapshotFuture full = snp.createFullSnapshot(null, null);
        full.get();
        test.loadByTime(5000L);
        GridPointInTimeRecoveryAbstractTest.RecoveryPoint p = test.savePoint();
        test.loadByTime(2000L);
        SnapshotFuture full2 = snp.createFullSnapshot(null, null);
        full2.get();
        final List infos = snp.list();
        GridPointInTimeRecoverySharedFolderTest.assertEquals((int)3, (int)infos.size());
        infos.sort(SnapshotIdComparator.INSTANCE);
        File sharedFolder = this.createSharedFolder();
        this.moveSnapshot(((SnapshotInfo)infos.get(0)).snapshotId(), sharedFolder, snp);
        this.moveSnapshot(((SnapshotInfo)infos.get(1)).snapshotId(), sharedFolder, snp);
        File[] snapshotFolders = sharedFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.contains(Long.toString(((SnapshotInfo)infos.get(1)).snapshotId()));
            }
        });
        GridPointInTimeRecoverySharedFolderTest.assertNotNull((Object)snapshotFolders);
        GridPointInTimeRecoverySharedFolderTest.assertEquals((int)1, (int)snapshotFolders.length);
        U.delete((File)snapshotFolders[0]);
        try {
            SnapshotFuture recoveryFut = snp.recoveryTo(p.time, Collections.singleton(sharedFolder), null, "Negative test (Delete snapshot it the middle).");
            recoveryFut.get();
        }
        catch (Throwable h) {
            U.log((IgniteLogger)log, (Object)"Expected exception", (Object)h);
            return;
        }
        GridPointInTimeRecoverySharedFolderTest.fail((String)"Recovery to point in WAL of deleted snapshot should fail.");
    }

    @Test
    public void testRecoveryFromFirstSnapshotOnOneNode() throws Exception {
        IgniteEx ig0 = this.startGrids(4);
        ig0.cluster().active(true);
        GridPointInTimeRecoveryAbstractTest.TestContext test = new GridPointInTimeRecoveryAbstractTest.TestContext((Ignite)ig0, "default");
        test.loadByTime(5000L);
        GridPointInTimeRecoveryAbstractTest.RecoveryPoint p = test.savePoint();
        test.loadByTime(100L);
        GridGainImpl gg0 = (GridGainImpl)ig0.plugin("GridGain");
        GridSnapshotEx snp = (GridSnapshotEx)gg0.snapshot();
        snp.createFullSnapshot(null, null).get();
        List infos = snp.list();
        GridPointInTimeRecoverySharedFolderTest.assertEquals((int)2, (int)infos.size());
        long activationSnapshotId = Collections.min(infos, SnapshotIdComparator.INSTANCE).snapshotId();
        File sharedFolder = this.createSharedFolder();
        this.moveSnapshot(activationSnapshotId, sharedFolder, snp);
        this.stopAllGrids();
        IgniteEx ig = this.startGrid(4);
        ig.cluster().active(true);
        gg0 = (GridGainImpl)ig.plugin("GridGain");
        snp = (GridSnapshotEx)gg0.snapshot();
        int iter = 5;
        while (iter-- > 0) {
            snp.recoveryTo(p.time, Collections.singleton(sharedFolder), null, "Recovery from shared folder (first snapshot).").get();
            this.awaitPartitionMapExchange();
            this.waitForRebalancing();
            test.checkPoint(p, G.allGrids());
        }
    }

    private void testRecoveryOnCleanGrid(int newTopSize) throws Exception {
        this.consistentIdPrefix = "OLD";
        IgniteEx ig0 = this.startGrids(4);
        ig0.cluster().active(true);
        GridPointInTimeRecoveryAbstractTest.TestContext test = new GridPointInTimeRecoveryAbstractTest.TestContext((Ignite)ig0, "default");
        test.loadByTime(5000L);
        GridGain gg0 = (GridGain)ig0.plugin("GridGain");
        GridSnapshotEx snp = (GridSnapshotEx)gg0.snapshot();
        GridPointInTimeRecoverySharedFolderTest.assertNotNull((Object)snp);
        SnapshotFuture full = snp.createFullSnapshot(null, null);
        full.get();
        test.loadByTime(5000L);
        GridPointInTimeRecoveryAbstractTest.RecoveryPoint p = test.savePoint();
        test.loadByTime(2000L);
        SnapshotFuture inc = snp.createSnapshot(null, null);
        inc.get();
        snp.createFullSnapshot(null, null).get();
        List infos = snp.list();
        GridPointInTimeRecoverySharedFolderTest.assertEquals((int)4, (int)infos.size());
        infos.sort(SnapshotIdComparator.INSTANCE);
        File sharedFolder = this.createSharedFolder();
        this.moveTheChainOfSnapshots(((SnapshotInfo)infos.get(1)).snapshotId(), sharedFolder, snp);
        this.stopAllGrids();
        this.deleteWorkFiles();
        this.consistentIdPrefix = "NEW";
        ig0 = this.startGrids(newTopSize);
        ig0.cluster().active(true);
        gg0 = (GridGain)ig0.plugin("GridGain");
        snp = (GridSnapshotEx)gg0.snapshot();
        GridPointInTimeRecoverySharedFolderTest.assertNotNull((Object)snp);
        SnapshotFuture recoveryFut = snp.recoveryTo(p.time, Collections.singleton(sharedFolder), null, "Recovery from shared folder (clean grid).");
        recoveryFut.get();
        this.awaitPartitionMapExchange(true, true, null, true);
        test.checkPoint(p, G.allGrids());
    }

    @Test
    public void testRecoveryOnHalfTopologyGracefulStop() throws Exception {
        this.consistentIdPrefix = "OLD";
        IgniteEx ig0 = this.startGrids(4);
        ig0.cluster().active(true);
        GridGain gg0 = (GridGain)ig0.plugin("GridGain");
        GridSnapshotEx snp0 = (GridSnapshotEx)gg0.snapshot();
        GridPointInTimeRecoverySharedFolderTest.assertNotNull((Object)snp0);
        GridPointInTimeRecoveryAbstractTest.TestContext test = new GridPointInTimeRecoveryAbstractTest.TestContext((Ignite)ig0, "default");
        test.loadByTime(5000L);
        SnapshotFuture full1 = snp0.createFullSnapshot(null, null);
        full1.get();
        test.loadByTime(10000L);
        GridPointInTimeRecoveryAbstractTest.RecoveryPoint recoveryPtr1 = test.savePoint();
        test.removeByTime(5000L);
        SnapshotFuture full2 = snp0.createFullSnapshot(null, null);
        full2.get();
        File sharedFolder = this.createSharedFolder();
        this.moveSnapshot(full1.snapshotOperation().snapshotId(), sharedFolder, snp0);
        ig0.cluster().active(false);
        this.stopAllGrids(false);
        this.consistentIdPrefix = "NEW";
        this.deleteWorkFiles();
        int newGrid = 2;
        IgniteEx ig1 = this.startGrids(newGrid);
        ig1.cluster().active(true);
        GridGain gg1 = (GridGain)ig1.plugin("GridGain");
        GridSnapshotEx snp1 = (GridSnapshotEx)gg1.snapshot();
        GridPointInTimeRecoverySharedFolderTest.assertNotNull((Object)snp1);
        SnapshotFuture recoveryFut = snp1.recoveryTo(recoveryPtr1.time, Collections.singleton(sharedFolder), null, "Recovery from shared folder.");
        recoveryFut.get();
        test.checkPoint(recoveryPtr1, (Ignite)this.grid(0));
        test.checkPoint(recoveryPtr1, (Ignite)this.grid(1));
        this.awaitPartitionMapExchange();
    }

    @Test
    public void testRecoveryWithoutWalApplying() throws Exception {
        this.consistentIdPrefix = "OLD";
        IgniteEx ig0 = this.startGrids(4);
        ig0.cluster().active(true);
        GridGain gg0 = (GridGain)ig0.plugin("GridGain");
        GridSnapshotEx snp0 = (GridSnapshotEx)gg0.snapshot();
        GridPointInTimeRecoverySharedFolderTest.assertNotNull((Object)snp0);
        GridPointInTimeRecoveryAbstractTest.TestContext test = new GridPointInTimeRecoveryAbstractTest.TestContext((Ignite)ig0, "default");
        test.loadByTime(5000L);
        SnapshotFuture full1 = snp0.createFullSnapshot(null, null);
        full1.get();
        GridPointInTimeRecoveryAbstractTest.RecoveryPoint recoveryPtr1 = test.savePoint();
        test.loadByTime(5000L);
        SnapshotFuture full2 = snp0.createFullSnapshot(null, null);
        full2.get();
        File sharedFolder = this.createSharedFolder();
        this.moveSnapshot(full1.snapshotOperation().snapshotId(), sharedFolder, snp0);
        ig0.cluster().active(false);
        this.stopAllGrids(false);
        this.consistentIdPrefix = "NEW";
        this.deleteWorkFiles();
        IgniteEx ig1 = this.startGrids(4);
        ig1.cluster().active(true);
        GridGain gg1 = (GridGain)ig1.plugin("GridGain");
        GridSnapshotEx snp1 = (GridSnapshotEx)gg1.snapshot();
        GridPointInTimeRecoverySharedFolderTest.assertNotNull((Object)snp1);
        SnapshotFuture recoveryFut = snp1.recoveryTo(recoveryPtr1.time, Collections.singleton(sharedFolder), null, "Recovery from shared folder.");
        recoveryFut.get();
        for (int i = 0; i < 4; ++i) {
            test.checkPoint(recoveryPtr1, (Ignite)this.grid(i));
        }
        this.awaitPartitionMapExchange();
    }

    @Test
    public void testMoveRetainsReservedWalSegments() throws Exception {
        this.walSegmentSize = 524288;
        IgniteEx ig0 = this.startGrids(4);
        ig0.cluster().active(true);
        GridGain gg0 = (GridGain)ig0.plugin("GridGain");
        GridSnapshotEx snp0 = (GridSnapshotEx)gg0.snapshot();
        GridPointInTimeRecoverySharedFolderTest.assertNotNull((Object)snp0);
        SnapshotFuture full1 = snp0.createFullSnapshot(null, null);
        full1.get();
        GridPointInTimeRecoveryAbstractTest.TestContext test = new GridPointInTimeRecoveryAbstractTest.TestContext((Ignite)ig0, "default");
        test.loadByTime(15000L);
        SnapshotFuture full2 = snp0.createFullSnapshot(null, null);
        full2.get();
        Thread.sleep(5000L);
        ig0.context().cache().context().wal().reserve((WALPointer)new FileWALPointer(0L, 0, 0));
        String nodeFolderName = ig0.context().pdsFolderResolver().resolveFolders().folderName();
        File dbDir = new File(U.defaultWorkDirectory(), this.storePath());
        File walDir = new File(new File(dbDir, "wal"), nodeFolderName);
        File walArchiveDir = new File(new File(dbDir, "archive"), nodeFolderName);
        File[] walArchiveSegments = walArchiveDir.listFiles();
        GridPointInTimeRecoverySharedFolderTest.assertNotNull((Object)walArchiveSegments);
        File sharedFolder = this.createSharedFolder();
        this.moveSnapshot(full1.snapshotOperation().snapshotId(), sharedFolder, snp0);
        File[] walArchiveSegmentsAfterMove = walArchiveDir.listFiles();
        GridPointInTimeRecoverySharedFolderTest.assertNotNull((Object)walArchiveSegmentsAfterMove);
        GridPointInTimeRecoverySharedFolderTest.assertTrue((walArchiveSegmentsAfterMove.length >= walArchiveSegments.length ? 1 : 0) != 0);
    }

    @Test
    public void testIncrementalSnapshot() throws Exception {
        this.consistentIdPrefix = "OLD";
        IgniteEx ig0 = this.startGrids(4);
        ig0.cluster().active(true);
        GridGain gg0 = (GridGain)ig0.plugin("GridGain");
        GridSnapshotEx snp0 = (GridSnapshotEx)gg0.snapshot();
        GridPointInTimeRecoverySharedFolderTest.assertNotNull((Object)snp0);
        GridPointInTimeRecoveryAbstractTest.TestContext test = new GridPointInTimeRecoveryAbstractTest.TestContext((Ignite)ig0, "default");
        test.loadByTime(10000L);
        SnapshotFuture full1 = snp0.createFullSnapshot(null, null);
        full1.get();
        test.removeByTime(1000L);
        GridPointInTimeRecoveryAbstractTest.RecoveryPoint recoveryPtr1 = test.savePoint();
        ArrayList<GridPointInTimeRecoveryAbstractTest.RecoveryPoint> incPtrs = new ArrayList<GridPointInTimeRecoveryAbstractTest.RecoveryPoint>();
        for (int i = 0; i < 4; ++i) {
            test.removeByTime(1000L);
            SnapshotFuture incr1 = snp0.createSnapshot(null, null);
            incr1.get();
            test.loadByTime(5000L);
            incPtrs.add(test.savePoint());
        }
        snp0.createFullSnapshot(null, null).get();
        File sharedFolder = this.createSharedFolder();
        this.moveTheChainOfSnapshots(full1.snapshotOperation().snapshotId(), sharedFolder, snp0);
        this.stopAllGrids(false);
        this.consistentIdPrefix = "NEW";
        this.deleteWorkFiles();
        int newGrid = 1;
        IgniteEx ig1 = this.startGrids(newGrid);
        ig1.cluster().active(true);
        GridGain gg1 = (GridGain)ig1.plugin("GridGain");
        GridSnapshotEx snp1 = (GridSnapshotEx)gg1.snapshot();
        GridPointInTimeRecoverySharedFolderTest.assertNotNull((Object)snp1);
        SnapshotFuture recoveryFut = snp1.recoveryTo(recoveryPtr1.time, Collections.singleton(sharedFolder), null, "Recovery from shared folder to " + recoveryPtr1.time + ".");
        recoveryFut.get();
        test.checkPoint(recoveryPtr1, (Ignite)this.grid(0));
        for (GridPointInTimeRecoveryAbstractTest.RecoveryPoint incPtr : incPtrs) {
            SnapshotFuture recoveryFut2 = snp1.recoveryTo(incPtr.time, Collections.singleton(sharedFolder), null, "Recovery from shared folder to " + incPtr.time + " after increment snapshot.");
            recoveryFut2.get();
            test.checkPoint(incPtr, (Ignite)this.grid(0));
        }
    }

    @Test
    public void testDoubleKeyPutInTransactionForTheSamePartition() throws Exception {
        IgniteEx ig0 = this.startGrids(4);
        ig0.cluster().active(true);
        GridGain gg0 = (GridGain)ig0.plugin("GridGain");
        GridSnapshotEx snp0 = (GridSnapshotEx)gg0.snapshot();
        GridPointInTimeRecoverySharedFolderTest.assertNotNull((Object)snp0);
        SnapshotFuture full1 = snp0.createFullSnapshot(null, null);
        full1.get();
        IgniteCache cache = ig0.cache("default").withAllowAtomicOpsInTx();
        int keys = 32;
        for (int i = 0; i < 32; ++i) {
            try (Transaction tx = ig0.transactions().txStart();){
                cache.put((Object)i, (Object)1);
                cache.put((Object)(i + 32), (Object)1);
                tx.commit();
                continue;
            }
        }
        Thread.sleep(1000L);
        long time = U.currentTimeMillis();
        Thread.sleep(1000L);
        for (int i = 0; i < 32; ++i) {
            try (Transaction tx = ig0.transactions().txStart();){
                cache.put((Object)i, (Object)2);
                cache.put((Object)(i + 32), (Object)2);
                tx.commit();
                continue;
            }
        }
        SnapshotFuture full2 = snp0.createFullSnapshot(null, null);
        full2.get();
        List infos = snp0.list();
        GridPointInTimeRecoverySharedFolderTest.assertEquals((int)3, (int)infos.size());
        File sharedFolder = this.createSharedFolder();
        this.moveTheChainOfSnapshots(full1.snapshotOperation().snapshotId(), sharedFolder, snp0);
        SnapshotFuture recoveryFut = snp0.recoveryTo(time, Collections.singleton(sharedFolder), null, "Recovery from shared folder.");
        recoveryFut.get();
        cache = ig0.cache("default");
        this.awaitPartitionMapExchange();
        this.waitForRebalancing();
        for (int i = 0; i < 32; ++i) {
            Integer val1 = (Integer)cache.get((Object)i);
            Integer val2 = (Integer)cache.get((Object)(i + 32));
            Assert.assertEquals((long)1L, (long)val1.intValue());
            Assert.assertEquals((long)1L, (long)val2.intValue());
        }
    }

    protected void moveTheChainOfSnapshots(long id, File sharedFolder, GridSnapshotEx snp) {
        snp.forceMoveSnapshot(id, sharedFolder, null).get();
    }

    protected void moveSnapshot(long snapshotId, File sharedFolder, GridSnapshotEx snp) {
        snp.moveSnapshot(snapshotId, sharedFolder, null).get();
    }

    @Override
    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"shared", (boolean)false));
    }

    protected void afterTestsStopped() throws Exception {
        super.afterTestsStopped();
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"shared", (boolean)false));
    }

    protected static class SnapshotIdComparator
    implements Comparator<SnapshotInfo> {
        static final SnapshotIdComparator INSTANCE = new SnapshotIdComparator();

        protected SnapshotIdComparator() {
        }

        @Override
        public int compare(SnapshotInfo o1, SnapshotInfo o2) {
            return Long.compare(o1.snapshotId(), o2.snapshotId());
        }
    }
}

