/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.recovery;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.ignite.Ignite;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.internal.processors.cache.database.GridSnapshotEx;
import org.gridgain.grid.internal.processors.cache.database.messages.SnapshotProgressMessage;
import org.gridgain.grid.internal.processors.cache.database.recovery.GridPointInTimeRecoveryAbstractTest;
import org.gridgain.grid.internal.processors.cache.database.recovery.GridPointInTimeRecoverySharedFolderTest;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.junit.Test;

public class GridPointInTimeRecoverySharedFolderProgressTest
extends GridPointInTimeRecoveryAbstractTest {
    private int walSegmentSize;

    @Override
    protected CacheConfiguration[] prepareCachesConfiguration() {
        return new CacheConfiguration[]{new CacheConfiguration().setName("default").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32))};
    }

    @Override
    protected IgniteConfiguration getConfiguration(String name) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(name);
        cfg.getDataStorageConfiguration().setWalSegmentSize(this.walSegmentSize);
        GridGainConfiguration ggCfg = (GridGainConfiguration)cfg.getPluginConfigurations()[0];
        ggCfg.getSnapshotConfiguration().setSnapshotProgressThrottlingInterval(-1L);
        return cfg;
    }

    @Override
    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"shared", (boolean)false));
    }

    protected void afterTestsStopped() throws Exception {
        super.afterTestsStopped();
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"shared", (boolean)false));
    }

    @Override
    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.walSegmentSize = 0x4000000;
    }

    @Test
    public void testRecoveryTrackProgress() throws Exception {
        this.consistentIdPrefix = "OLD";
        IgniteEx ig0 = this.startGrids(4);
        ig0.cluster().active(true);
        GridPointInTimeRecoveryAbstractTest.TestContext test = new GridPointInTimeRecoveryAbstractTest.TestContext((Ignite)ig0, "default");
        test.loadByTime(5000L);
        GridPointInTimeRecoveryAbstractTest.RecoveryPoint p = test.savePoint();
        test.loadByTime(2000L);
        GridGain gg0 = (GridGain)ig0.plugin("GridGain");
        GridSnapshotEx snp = (GridSnapshotEx)gg0.snapshot();
        GridPointInTimeRecoverySharedFolderProgressTest.assertNotNull((Object)snp);
        SnapshotFuture full = snp.createFullSnapshot(null, null);
        full.get();
        File sharedFolder = this.createSharedFolder();
        List infos = snp.list();
        GridPointInTimeRecoverySharedFolderProgressTest.assertEquals((int)2, (int)infos.size());
        long activationSnapshotId = Collections.min(infos, GridPointInTimeRecoverySharedFolderTest.SnapshotIdComparator.INSTANCE).snapshotId();
        snp.moveSnapshot(activationSnapshotId, sharedFolder, null).get();
        List<SnapshotProgressMessage> messages = Collections.synchronizedList(new ArrayList());
        this.sniffProgressMessages(messages);
        SnapshotFuture recoveryFut = snp.recoveryTo(p.time, Collections.singleton(sharedFolder), null, "Recovery from shared folder (first snapshot).");
        recoveryFut.get();
        this.awaitPartitionMapExchange();
        this.waitForRebalancing();
        test.checkPoint(p, G.allGrids());
        Map<Long, List<SnapshotProgressMessage>> messageMap = messages.stream().collect(Collectors.groupingBy(SnapshotProgressMessage::getTotal));
        long phase4messages = messageMap.get(3L).size();
        messageMap.forEach(new BiConsumer<Long, List<SnapshotProgressMessage>>(){

            @Override
            public void accept(Long total, List<SnapshotProgressMessage> messages) {
                GridPointInTimeRecoverySharedFolderProgressTest.assertTrue((boolean)(messages.size() <= 101));
                final HashSet progressValues = new HashSet();
                messages.forEach(new Consumer<SnapshotProgressMessage>(){

                    @Override
                    public void accept(SnapshotProgressMessage message) {
                        GridPointInTimeRecoverySharedFolderProgressTest.assertTrue((boolean)((double)message.getProcessed() / (double)message.getTotal() <= 1.0));
                        GridPointInTimeRecoverySharedFolderProgressTest.assertTrue((boolean)((double)message.getProcessed() / (double)message.getTotal() >= 0.0));
                        progressValues.add(message.getProcessed());
                    }
                });
                if (total != 3L) {
                    GridPointInTimeRecoverySharedFolderProgressTest.assertEquals((int)messages.size(), (int)progressValues.size());
                } else {
                    GridPointInTimeRecoverySharedFolderProgressTest.assertEquals((int)messages.size(), (int)(progressValues.size() * 4));
                }
            }
        });
        GridPointInTimeRecoverySharedFolderProgressTest.assertEquals((long)12L, (long)phase4messages);
        GridPointInTimeRecoverySharedFolderProgressTest.assertEquals((long)5L, (long)messageMap.size());
    }
}

