/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.recovery;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.failure.FailureHandler;
import org.apache.ignite.failure.StopNodeFailureHandler;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.managers.discovery.CustomMessageWrapper;
import org.apache.ignite.internal.managers.discovery.DiscoveryCustomMessage;
import org.apache.ignite.internal.processors.cache.persistence.file.AsyncFileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIODecorator;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cluster.ChangeGlobalStateFinishMessage;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.DiscoverySpiCustomMessage;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryAbstractMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryCustomEventMessage;
import org.apache.ignite.testframework.GridStringLogger;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.apache.ignite.testframework.junits.logger.GridTestLog4jLogger;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.processors.cache.database.GridSnapshotEx;
import org.gridgain.grid.internal.processors.cache.database.messages.StartSnapshotOperationDiscoveryMessage;
import org.gridgain.grid.internal.processors.cache.database.recovery.GridPointInTimeRecoveryAbstractTest;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.junit.Test;

public class GridPointInTimeRecoveryNodeLeftTest
extends GridPointInTimeRecoveryAbstractTest {
    private static final AtomicBoolean SLOW_READS_ENABLED = new AtomicBoolean(true);
    private static final GridConcurrentHashSet<String> DONT_SLOW_THREAD_NAME_SUBSTRINGS = new GridConcurrentHashSet();
    private FailureHandler failureHnd;
    private TcpDiscoverySpi tcpSpecialSpi;
    private GridStringLogger imLog;
    private static final String SPECIAL_ERROR_MESSAGE = "SPECIAL.ERROR";

    @Override
    protected void beforeTest() throws Exception {
        super.beforeTest();
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"shared", (boolean)false));
        SLOW_READS_ENABLED.set(true);
        DONT_SLOW_THREAD_NAME_SUBSTRINGS.clear();
    }

    @Override
    protected void afterTest() throws Exception {
        super.afterTest();
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"shared", (boolean)false));
    }

    @Override
    protected IgniteConfiguration getConfiguration(String name) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(name);
        cfg.getDataStorageConfiguration().setFileIOFactory((FileIOFactory)new SlowWalReadFileIOFactory()).setWalRecordIteratorBufferSize(8192);
        TcpDiscoveryIpFinder ipFinder = ((TcpDiscoverySpi)cfg.getDiscoverySpi()).getIpFinder();
        if (this.failureHnd != null) {
            cfg.setFailureHandler(this.failureHnd);
        }
        if (this.tcpSpecialSpi != null) {
            this.tcpSpecialSpi.setIpFinder(ipFinder);
            cfg.setDiscoverySpi((DiscoverySpi)this.tcpSpecialSpi);
        }
        if (this.imLog != null) {
            cfg.setGridLogger((IgniteLogger)this.imLog);
        }
        return cfg;
    }

    @Override
    protected CacheConfiguration[] prepareCachesConfiguration() {
        CacheConfiguration ccfg = new CacheConfiguration("default");
        ccfg.setCacheMode(CacheMode.PARTITIONED);
        ccfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32));
        ccfg.setBackups(2);
        return new CacheConfiguration[]{ccfg};
    }

    @Test
    @WithSystemProperty(key="IGNITE_DUMP_THREADS_ON_FAILURE", value="false")
    public void testNodeFailuresDuringActivation() throws Exception {
        this.imLog = new GridStringLogger(false, (IgniteLogger)new GridTestLog4jLogger());
        this.imLog.logLength(0x100000);
        this.failureHnd = new StopNodeFailureHandler();
        IgniteEx ignite = this.startGrid(0);
        this.tcpSpecialSpi = new TcpDiscoverySpi(){

            protected void startMessageProcess(TcpDiscoveryAbstractMessage msg) {
                block4: {
                    if (msg instanceof TcpDiscoveryCustomEventMessage) {
                        try {
                            DiscoverySpiCustomMessage customMsgWrapper = ((TcpDiscoveryCustomEventMessage)msg).message(this.marshaller(), U.resolveClassLoader((IgniteConfiguration)this.ignite().configuration()));
                            DiscoveryCustomMessage customMsg = ((CustomMessageWrapper)customMsgWrapper).delegate();
                            if (customMsg instanceof ChangeGlobalStateFinishMessage) {
                                throw new AssertionError((Object)GridPointInTimeRecoveryNodeLeftTest.SPECIAL_ERROR_MESSAGE);
                            }
                        }
                        catch (Throwable th) {
                            if (!th.getMessage().contains(GridPointInTimeRecoveryNodeLeftTest.SPECIAL_ERROR_MESSAGE)) break block4;
                            throw (AssertionError)((Object)th);
                        }
                    }
                }
            }
        };
        this.startGrid(1);
        this.tcpSpecialSpi = null;
        this.startGrid(2);
        this.tcpSpecialSpi = new TcpDiscoverySpi(){

            protected void startMessageProcess(TcpDiscoveryAbstractMessage msg) {
                block4: {
                    if (msg instanceof TcpDiscoveryCustomEventMessage) {
                        try {
                            DiscoverySpiCustomMessage customMsgWrapper = ((TcpDiscoveryCustomEventMessage)msg).message(this.marshaller(), U.resolveClassLoader((IgniteConfiguration)this.ignite().configuration()));
                            DiscoveryCustomMessage customMsg = ((CustomMessageWrapper)customMsgWrapper).delegate();
                            if (customMsg instanceof StartSnapshotOperationDiscoveryMessage) {
                                throw new AssertionError((Object)GridPointInTimeRecoveryNodeLeftTest.SPECIAL_ERROR_MESSAGE);
                            }
                        }
                        catch (Throwable th) {
                            if (!th.getMessage().contains(GridPointInTimeRecoveryNodeLeftTest.SPECIAL_ERROR_MESSAGE)) break block4;
                            throw (AssertionError)((Object)th);
                        }
                    }
                }
            }
        };
        this.startGrid(3);
        ignite.cluster().active(true);
        String logStr = this.imLog.toString();
        GridPointInTimeRecoveryNodeLeftTest.assertFalse((logStr.contains("NullPointerException") && logStr.contains("SnapshotOperationFuture.onNodeLeft") ? 1 : 0) != 0);
    }

    @Test
    public void testCrdLeft() throws Exception {
        this.testNodeLeft(0, true);
    }

    @Test
    public void testNonCrdLeft() throws Exception {
        this.testNodeLeft(2, true);
    }

    @Test
    public void testCrdLeftSharedFolder() throws Exception {
        this.testNodeLeftSharedFolder(0, true);
    }

    @Test
    public void testNonCrdLeftSharedFolder() throws Exception {
        this.testNodeLeftSharedFolder(2, true);
    }

    private void testNodeLeft(int leftNodeIdx, boolean shouldFail) throws Exception {
        this.startGrids(4);
        IgniteEx igClient = this.startClient(4);
        SLOW_READS_ENABLED.set(false);
        igClient.cluster().active(true);
        SLOW_READS_ENABLED.set(true);
        GridPointInTimeRecoveryAbstractTest.TestContext test = new GridPointInTimeRecoveryAbstractTest.TestContext((Ignite)igClient, "default");
        test.loadByTime(10000L);
        GridPointInTimeRecoveryAbstractTest.RecoveryPoint pnt = test.savePoint();
        test.removeByTime(1000L);
        GridGain gg = (GridGain)igClient.plugin("GridGain");
        GridSnapshotEx snp = (GridSnapshotEx)gg.snapshot();
        GridPointInTimeRecoveryNodeLeftTest.assertNotNull((Object)snp);
        SnapshotFuture recoveryFut = snp.recoveryTo(pnt.time, pnt.msg);
        U.warn((IgniteLogger)log, (Object)"Recovery called");
        Thread.sleep(10000L);
        this.stopGrid(leftNodeIdx, true);
        DONT_SLOW_THREAD_NAME_SUBSTRINGS.add((Object)this.getTestIgniteInstanceName(leftNodeIdx));
        DONT_SLOW_THREAD_NAME_SUBSTRINGS.add((Object)this.getTestIgniteInstanceName(3));
        Thread.sleep(5000L);
        SLOW_READS_ENABLED.set(false);
        boolean failed = false;
        try {
            recoveryFut.get();
        }
        catch (Throwable t) {
            failed = true;
        }
        GridPointInTimeRecoveryNodeLeftTest.assertEquals((boolean)shouldFail, (boolean)failed);
        if (shouldFail) {
            snp.recoveryTo(pnt.time, pnt.msg).get();
        }
        test.checkPoint(pnt, G.allGrids());
    }

    private void testNodeLeftSharedFolder(int leftNodeIdx, boolean shouldFail) throws Exception {
        this.startGrids(4);
        IgniteEx igClient = this.startClient(4);
        SLOW_READS_ENABLED.set(false);
        igClient.cluster().active(true);
        SLOW_READS_ENABLED.set(true);
        GridPointInTimeRecoveryAbstractTest.TestContext test = new GridPointInTimeRecoveryAbstractTest.TestContext((Ignite)igClient, "default");
        GridGain gg = (GridGain)igClient.plugin("GridGain");
        GridSnapshotEx snp = (GridSnapshotEx)gg.snapshot();
        GridPointInTimeRecoveryNodeLeftTest.assertNotNull((Object)snp);
        while (snp.list().isEmpty()) {
        }
        SnapshotFuture full1 = snp.createFullSnapshot(null, null);
        full1.get();
        test.loadByTime(10000L);
        GridPointInTimeRecoveryAbstractTest.RecoveryPoint pnt = test.savePoint();
        test.removeByTime(1000L);
        SnapshotFuture full2 = snp.createFullSnapshot(null, null);
        full2.get();
        File sharedFolder = this.createSharedFolder();
        snp.moveSnapshot(full1.snapshotOperation().snapshotId(), sharedFolder, null).get();
        SnapshotFuture recoveryFut = snp.recoveryTo(pnt.time, Collections.singleton(sharedFolder), null, pnt.msg);
        U.warn((IgniteLogger)log, (Object)"Recovery called");
        Thread.sleep(10000L);
        this.stopGrid(leftNodeIdx, true);
        DONT_SLOW_THREAD_NAME_SUBSTRINGS.add((Object)this.getTestIgniteInstanceName(leftNodeIdx));
        DONT_SLOW_THREAD_NAME_SUBSTRINGS.add((Object)this.getTestIgniteInstanceName(3));
        Thread.sleep(5000L);
        SLOW_READS_ENABLED.set(false);
        boolean failed = false;
        try {
            recoveryFut.get();
        }
        catch (Throwable t) {
            failed = true;
        }
        GridPointInTimeRecoveryNodeLeftTest.assertEquals((boolean)shouldFail, (boolean)failed);
        if (shouldFail) {
            snp.recoveryTo(pnt.time, Collections.singleton(sharedFolder), null, pnt.msg).get();
        }
        test.checkPoint(pnt, G.allGrids());
    }

    private static class SlowWalReadFileIOFactory
    implements FileIOFactory {
        private static final long serialVersionUID = 0L;
        private final FileIOFactory delegateFactory = new AsyncFileIOFactory();

        private SlowWalReadFileIOFactory() {
        }

        public FileIO create(File file) throws IOException {
            return this.create(file, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
        }

        public FileIO create(File file, OpenOption ... openOption) throws IOException {
            FileIO delegate = this.delegateFactory.create(file, openOption);
            final AtomicInteger hits = new AtomicInteger(0);
            final boolean slowRead = file.getName().contains(".wal");
            return new FileIODecorator(delegate){

                public int read(ByteBuffer destBuf) throws IOException {
                    if (hits.get() > 20 && slowRead) {
                        this.parkForAWhile(SLOW_READS_ENABLED);
                    }
                    hits.incrementAndGet();
                    return super.read(destBuf);
                }

                public int read(ByteBuffer destBuf, long position) throws IOException {
                    if (hits.get() > 20 && slowRead) {
                        this.parkForAWhile(SLOW_READS_ENABLED);
                    }
                    hits.incrementAndGet();
                    return super.read(destBuf, position);
                }

                public int read(byte[] buf, int off, int len) throws IOException {
                    if (hits.get() > 20 && slowRead) {
                        this.parkForAWhile(SLOW_READS_ENABLED);
                    }
                    hits.incrementAndGet();
                    return super.read(buf, off, len);
                }

                private void parkForAWhile(AtomicBoolean slowReadsEnabled) {
                    for (int i = 0; i < 100; ++i) {
                        boolean unstoppableThread = false;
                        for (String s : DONT_SLOW_THREAD_NAME_SUBSTRINGS) {
                            if (!Thread.currentThread().getName().contains(s)) continue;
                            unstoppableThread = true;
                        }
                        if (unstoppableThread || !slowReadsEnabled.get()) continue;
                        LockSupport.parkNanos(50000000L);
                    }
                }
            };
        }
    }
}

