/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.recovery;

import java.io.Serializable;
import java.util.HashSet;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.processors.cache.database.GridSnapshotEx;
import org.gridgain.grid.internal.processors.cache.database.recovery.GridPointInTimeRecoveryAbstractTest;
import org.junit.Test;

public class GridPointInTimeRecoveryMemoryConsumptionTest
extends GridPointInTimeRecoveryAbstractTest {
    @Override
    protected IgniteConfiguration getConfiguration(String name) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(name);
        cfg.getDataStorageConfiguration().getDefaultDataRegionConfiguration().setPersistenceEnabled(true).setMaxSize(0x3200000L).setInitialSize(0x3200000L);
        return cfg;
    }

    @Override
    protected CacheConfiguration[] prepareCachesConfiguration() {
        return new CacheConfiguration[]{new CacheConfiguration().setName("default")};
    }

    @Test
    @WithSystemProperty(key="IGNITE_PDS_CHECKPOINT_TEST_SKIP_SYNC", value="true")
    public void testUpdatesNotFittingIntoMemoryRegion() throws Exception {
        int entryCount = 100000;
        IgniteEx ignite = this.startGrid(0);
        ignite.cluster().active(true);
        IgniteCache cache = ignite.cache("default");
        try (IgniteDataStreamer streamer = ignite.dataStreamer("default");){
            for (int k = 0; k < entryCount; ++k) {
                if (k % 10000 == 0) {
                    System.out.println("k = " + k);
                }
                streamer.addData((Object)k, (Object)new TestValue());
            }
        }
        U.sleep((long)1000L);
        long pointInTime = System.currentTimeMillis();
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        ((GridSnapshotEx)gg.snapshot()).recoveryTo(pointInTime, null).get();
        GridPointInTimeRecoveryMemoryConsumptionTest.assertEquals((int)entryCount, (int)cache.size(new CachePeekMode[]{CachePeekMode.ALL}));
        HashSet<Integer> keys = new HashSet<Integer>();
        for (int k = 0; k < entryCount; ++k) {
            keys.add(k);
            if (k == 0 || k % 9999 != 0) continue;
            GridPointInTimeRecoveryMemoryConsumptionTest.assertTrue((String)("k=" + k + " size=" + keys.size()), (boolean)cache.containsKeys(keys));
            keys.clear();
        }
    }

    public static class TestValue
    implements Serializable {
        private byte[] payload = new byte[1024];
    }
}

