/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.recovery;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.managers.discovery.ConsistentIdMapper;
import org.apache.ignite.internal.pagemem.wal.WALIterator;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.pagemem.wal.record.TxRecord;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.cluster.BaselineTopology;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.apache.ignite.transactions.TransactionState;
import org.gridgain.grid.internal.processors.cache.database.recovery.PITRFuture;
import org.gridgain.grid.internal.processors.cache.database.recovery.TxStateRequest;
import org.gridgain.grid.internal.processors.cache.database.recovery.TxStateResponse;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

public class GridPointInTimeRecoveryFutureTest
extends GridCommonAbstractTest {
    private static final TcpDiscoveryIpFinder ipFinder = new TcpDiscoveryVmIpFinder(true);

    protected IgniteConfiguration getConfiguration(String name) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(name);
        cfg.setDiscoverySpi((DiscoverySpi)new TcpDiscoverySpi().setIpFinder(ipFinder));
        return cfg;
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stopAllGrids();
        this.deleteWorkFiles();
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
        this.deleteWorkFiles();
    }

    private void deleteWorkFiles() throws Exception {
        this.cleanPersistenceDir();
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"snapshot", (boolean)false));
    }

    @Test
    public void testScanFuture() throws Exception {
        IgniteEx ig1 = this.startGrid(0);
        IgniteEx ig2 = this.startGrid(1);
        ig1.active(true);
        long time = System.currentTimeMillis();
        PITRFuture f1 = this.createFut(time, ig1);
        PITRFuture f2 = this.createFut(time, ig2);
        this.addListener(ig1, f1);
        this.addListener(ig2, f2);
        BaselineTopology blt = ig1.context().state().clusterState().baselineTopology();
        Short consId1 = (Short)blt.consistentIdMapping().get(ig1.context().discovery().consistentId());
        Short consId2 = (Short)blt.consistentIdMapping().get(ig2.context().discovery().consistentId());
        HashMap<Short, List<Short>> nodes = new HashMap<Short, List<Short>>();
        nodes.put(consId1, Collections.singletonList(consId2));
        GridCacheVersion txVer1 = new GridCacheVersion(2, 0, 1L);
        GridCacheVersion txVer2 = new GridCacheVersion(2, 0, 2L);
        GridCacheVersion txVer3 = new GridCacheVersion(2, 0, 3L);
        GridCacheVersion txVer4 = new GridCacheVersion(2, 0, 4L);
        GridCacheVersion txVer5 = new GridCacheVersion(2, 0, 5L);
        GridCacheVersion txVer6 = new GridCacheVersion(2, 0, 6L);
        GridCacheVersion txVer7 = new GridCacheVersion(2, 0, 7L);
        FileWALPointer fakePos = new FileWALPointer(0L, 0, 0);
        ArrayList<WALRecord> recsOnNode1 = new ArrayList<WALRecord>();
        TxRecord tx1_1_p = new TxRecord(TransactionState.PREPARED, txVer1, null, nodes, time - 10L);
        tx1_1_p.position((WALPointer)fakePos);
        TxRecord tx1_2_p = new TxRecord(TransactionState.PREPARED, txVer2, null, nodes, time - 9L);
        tx1_2_p.position((WALPointer)fakePos);
        TxRecord tx1_3_p = new TxRecord(TransactionState.PREPARED, txVer3, null, nodes, time - 8L);
        TxRecord tx1_3_c = new TxRecord(TransactionState.COMMITTED, txVer3, null, nodes, time - 7L);
        tx1_3_p.position((WALPointer)fakePos);
        tx1_3_c.position((WALPointer)fakePos);
        TxRecord tx1_4_p = new TxRecord(TransactionState.PREPARED, txVer4, null, nodes, time - 6L);
        TxRecord tx1_4_r = new TxRecord(TransactionState.ROLLED_BACK, txVer4, null, nodes, time - 5L);
        tx1_4_p.position((WALPointer)fakePos);
        tx1_4_r.position((WALPointer)fakePos);
        TxRecord tx1_5_p = new TxRecord(TransactionState.PREPARED, txVer5, null, nodes, time - 8L);
        TxRecord tx1_5_c = new TxRecord(TransactionState.COMMITTED, txVer5, null, nodes, time + 8L);
        tx1_5_p.position((WALPointer)fakePos);
        tx1_5_c.position((WALPointer)fakePos);
        TxRecord tx1_6_p = new TxRecord(TransactionState.PREPARED, txVer6, null, nodes, time - 7L);
        TxRecord tx1_6_r = new TxRecord(TransactionState.ROLLED_BACK, txVer6, null, nodes, time + 7L);
        tx1_6_p.position((WALPointer)fakePos);
        tx1_6_r.position((WALPointer)fakePos);
        TxRecord tx1_7_p = new TxRecord(TransactionState.PREPARED, txVer7, null, nodes, time - 5L);
        TxRecord tx1_7_c = new TxRecord(TransactionState.COMMITTED, txVer7, null, nodes, time + 5L);
        tx1_7_p.position((WALPointer)fakePos);
        tx1_7_c.position((WALPointer)fakePos);
        recsOnNode1.add((WALRecord)tx1_1_p);
        recsOnNode1.add((WALRecord)tx1_2_p);
        recsOnNode1.add((WALRecord)tx1_3_p);
        recsOnNode1.add((WALRecord)tx1_3_c);
        recsOnNode1.add((WALRecord)tx1_4_p);
        recsOnNode1.add((WALRecord)tx1_4_r);
        recsOnNode1.add((WALRecord)tx1_5_p);
        recsOnNode1.add((WALRecord)tx1_6_p);
        recsOnNode1.add((WALRecord)tx1_7_p);
        recsOnNode1.add((WALRecord)tx1_7_c);
        recsOnNode1.add((WALRecord)tx1_6_r);
        recsOnNode1.add((WALRecord)tx1_5_c);
        ArrayList<WALRecord> recsOnNode2 = new ArrayList<WALRecord>();
        TxRecord tx2_2_p = new TxRecord(TransactionState.PREPARED, txVer2, null, nodes, time - 9L);
        tx2_2_p.position((WALPointer)fakePos);
        TxRecord tx2_3_p = new TxRecord(TransactionState.PREPARED, txVer3, null, nodes, time - 8L);
        tx2_3_p.position((WALPointer)fakePos);
        TxRecord tx2_4_p = new TxRecord(TransactionState.PREPARED, txVer4, null, nodes, time - 6L);
        tx2_4_p.position((WALPointer)fakePos);
        TxRecord tx2_5_p = new TxRecord(TransactionState.PREPARED, txVer5, null, nodes, time - 5L);
        tx2_5_p.position((WALPointer)fakePos);
        TxRecord tx2_7_p = new TxRecord(TransactionState.PREPARED, txVer7, null, nodes, time - 6L);
        TxRecord tx2_7_c = new TxRecord(TransactionState.COMMITTED, txVer7, null, nodes, time + 6L);
        tx2_7_p.position((WALPointer)fakePos);
        tx2_7_c.position((WALPointer)fakePos);
        recsOnNode2.add((WALRecord)tx2_2_p);
        recsOnNode2.add((WALRecord)tx2_3_p);
        recsOnNode2.add((WALRecord)tx2_4_p);
        recsOnNode2.add((WALRecord)tx2_5_p);
        recsOnNode2.add((WALRecord)tx2_7_p);
        recsOnNode2.add((WALRecord)tx2_7_c);
        FileWALPointer p = new FileWALPointer(0L, 0, 0);
        IgniteInternalFuture asyncScan1 = this.scanAsync(f1, (WALPointer)p, recsOnNode1);
        IgniteInternalFuture asyncScan2 = this.scanAsync(f2, (WALPointer)p, recsOnNode2);
        asyncScan1.get();
        asyncScan2.get();
        Set toRollBack1 = ((PITRFuture.Result)f1.get()).getSkipTxs();
        System.err.println(toRollBack1.toString());
        GridPointInTimeRecoveryFutureTest.assertEquals((int)6, (int)toRollBack1.size());
        GridPointInTimeRecoveryFutureTest.assertTrue((boolean)toRollBack1.contains(txVer1));
        GridPointInTimeRecoveryFutureTest.assertTrue((boolean)toRollBack1.contains(txVer2));
        GridPointInTimeRecoveryFutureTest.assertTrue((boolean)toRollBack1.contains(txVer3));
        GridPointInTimeRecoveryFutureTest.assertTrue((boolean)toRollBack1.contains(txVer4));
        GridPointInTimeRecoveryFutureTest.assertTrue((boolean)toRollBack1.contains(txVer5));
        GridPointInTimeRecoveryFutureTest.assertTrue((boolean)toRollBack1.contains(txVer6));
        Set toRollBack2 = ((PITRFuture.Result)f2.get()).getSkipTxs();
        System.err.println(toRollBack2.toString());
        GridPointInTimeRecoveryFutureTest.assertEquals((int)6, (int)toRollBack2.size());
        toRollBack2.contains(txVer2);
        toRollBack2.contains(txVer3);
        toRollBack2.contains(txVer4);
        toRollBack2.contains(txVer5);
    }

    @Test
    public void testPreparedAndMissPrepared() throws Exception {
        IgniteEx ig1 = this.startGrid(0);
        IgniteEx ig2 = this.startGrid(1);
        ig1.active(true);
        BaselineTopology blt = ig1.context().state().clusterState().baselineTopology();
        Short consId1 = (Short)blt.consistentIdMapping().get(ig1.context().discovery().consistentId());
        Short consId2 = (Short)blt.consistentIdMapping().get(ig2.context().discovery().consistentId());
        HashMap<Short, Collection<Short>> nodes = new HashMap<Short, Collection<Short>>();
        nodes.put(consId1, Collections.singletonList(consId2));
        long time = System.currentTimeMillis();
        FileWALPointer p = new FileWALPointer(0L, 0, 0);
        PITRFuture f1 = this.createFut(time, ig1);
        PITRFuture f2 = this.createFut(time, ig2);
        this.addListener(ig1, f1);
        this.addListener(ig2, f2);
        TxRec.nextTxVer();
        TxRec tx = new TxRec(null, null, null, nodes, 0L);
        WalLogger.logRec(new WALRecord[]{tx.txState(TransactionState.PREPARED).time(time - 1L), null});
        T2<List<WALRecord>, List<WALRecord>> tup = WalLogger.recordPerNode();
        IgniteInternalFuture asyncScan1 = this.scanAsync(f1, (WALPointer)p, (List)tup.get1());
        IgniteInternalFuture asyncScan2 = this.scanAsync(f2, (WALPointer)p, (List)tup.get2());
        asyncScan1.get();
        asyncScan2.get();
        Set toRollBack1 = ((PITRFuture.Result)f1.get()).getSkipTxs();
        GridPointInTimeRecoveryFutureTest.assertEquals((int)1, (int)toRollBack1.size());
        GridPointInTimeRecoveryFutureTest.assertTrue((boolean)toRollBack1.contains(tx.nearXidVersion()));
        Set toRollBack2 = ((PITRFuture.Result)f2.get()).getSkipTxs();
        GridPointInTimeRecoveryFutureTest.assertEquals((int)1, (int)toRollBack2.size());
    }

    @Test
    public void testPreparedAndPrepared() throws Exception {
        IgniteEx ig1 = this.startGrid(0);
        IgniteEx ig2 = this.startGrid(1);
        ig1.active(true);
        BaselineTopology blt = ig1.context().state().clusterState().baselineTopology();
        Short consId1 = (Short)blt.consistentIdMapping().get(ig1.context().discovery().consistentId());
        Short consId2 = (Short)blt.consistentIdMapping().get(ig2.context().discovery().consistentId());
        HashMap<Short, Collection<Short>> nodes = new HashMap<Short, Collection<Short>>();
        nodes.put(consId1, Collections.singletonList(consId2));
        long time = System.currentTimeMillis();
        FileWALPointer p = new FileWALPointer(0L, 0, 0);
        PITRFuture f1 = this.createFut(time, ig1);
        PITRFuture f2 = this.createFut(time, ig2);
        this.addListener(ig1, f1);
        this.addListener(ig2, f2);
        TxRec.nextTxVer();
        TxRec tx = new TxRec(null, null, null, nodes, 0L);
        WalLogger.logRec(new WALRecord[]{tx.txState(TransactionState.PREPARED).time(time - 1L), tx.txState(TransactionState.PREPARED).time(time - 1L)});
        T2<List<WALRecord>, List<WALRecord>> tup = WalLogger.recordPerNode();
        IgniteInternalFuture asyncScan1 = this.scanAsync(f1, (WALPointer)p, (List)tup.get1());
        IgniteInternalFuture asyncScan2 = this.scanAsync(f2, (WALPointer)p, (List)tup.get2());
        asyncScan1.get();
        asyncScan2.get();
        Set toRollBack1 = ((PITRFuture.Result)f1.get()).getSkipTxs();
        GridPointInTimeRecoveryFutureTest.assertEquals((int)1, (int)toRollBack1.size());
        GridPointInTimeRecoveryFutureTest.assertTrue((boolean)toRollBack1.contains(tx.nearXidVersion()));
        Set toRollBack2 = ((PITRFuture.Result)f2.get()).getSkipTxs();
        GridPointInTimeRecoveryFutureTest.assertEquals((int)1, (int)toRollBack2.size());
        GridPointInTimeRecoveryFutureTest.assertTrue((boolean)toRollBack2.contains(tx.nearXidVersion()));
    }

    @Test
    public void testPreparedCommitedAndPrepared() throws Exception {
        IgniteEx ig1 = this.startGrid(0);
        IgniteEx ig2 = this.startGrid(1);
        ig1.active(true);
        BaselineTopology blt = ig1.context().state().clusterState().baselineTopology();
        Short consId1 = (Short)blt.consistentIdMapping().get(ig1.context().discovery().consistentId());
        Short consId2 = (Short)blt.consistentIdMapping().get(ig2.context().discovery().consistentId());
        HashMap<Short, Collection<Short>> nodes = new HashMap<Short, Collection<Short>>();
        nodes.put(consId1, Collections.singletonList(consId2));
        long time = System.currentTimeMillis();
        FileWALPointer p = new FileWALPointer(0L, 0, 0);
        PITRFuture f1 = this.createFut(time, ig1);
        PITRFuture f2 = this.createFut(time, ig2);
        this.addListener(ig1, f1);
        this.addListener(ig2, f2);
        TxRec.nextTxVer();
        TxRec tx = new TxRec(null, null, null, nodes, 0L);
        WalLogger.logRec(new WALRecord[]{tx.txState(TransactionState.PREPARED).time(time - 2L), tx.txState(TransactionState.PREPARED).time(time - 2L)});
        WalLogger.logRec(new WALRecord[]{tx.txState(TransactionState.COMMITTED).time(time - 1L), null});
        T2<List<WALRecord>, List<WALRecord>> tup = WalLogger.recordPerNode();
        IgniteInternalFuture asyncScan1 = this.scanAsync(f1, (WALPointer)p, (List)tup.get1());
        IgniteInternalFuture asyncScan2 = this.scanAsync(f2, (WALPointer)p, (List)tup.get2());
        asyncScan1.get();
        asyncScan2.get();
        Set toRollBack1 = ((PITRFuture.Result)f1.get()).getSkipTxs();
        GridPointInTimeRecoveryFutureTest.assertEquals((int)1, (int)toRollBack1.size());
        GridPointInTimeRecoveryFutureTest.assertTrue((boolean)toRollBack1.contains(tx.nearXidVersion()));
        Set toRollBack2 = ((PITRFuture.Result)f2.get()).getSkipTxs();
        GridPointInTimeRecoveryFutureTest.assertEquals((int)1, (int)toRollBack2.size());
        GridPointInTimeRecoveryFutureTest.assertTrue((boolean)toRollBack2.contains(tx.nearXidVersion()));
    }

    @Test
    public void testPreparedRollBackAndPrepared() throws Exception {
        IgniteEx ig1 = this.startGrid(0);
        IgniteEx ig2 = this.startGrid(1);
        ig1.active(true);
        BaselineTopology blt = ig1.context().state().clusterState().baselineTopology();
        Short consId1 = (Short)blt.consistentIdMapping().get(ig1.context().discovery().consistentId());
        Short consId2 = (Short)blt.consistentIdMapping().get(ig2.context().discovery().consistentId());
        HashMap<Short, Collection<Short>> nodes = new HashMap<Short, Collection<Short>>();
        nodes.put(consId1, Collections.singletonList(consId2));
        long time = System.currentTimeMillis();
        FileWALPointer p = new FileWALPointer(0L, 0, 0);
        PITRFuture f1 = this.createFut(time, ig1);
        PITRFuture f2 = this.createFut(time, ig2);
        this.addListener(ig1, f1);
        this.addListener(ig2, f2);
        TxRec.nextTxVer();
        TxRec tx = new TxRec(null, null, null, nodes, 0L);
        WalLogger.logRec(new WALRecord[]{tx.txState(TransactionState.PREPARED).time(time - 2L), tx.txState(TransactionState.PREPARED).time(time - 2L)});
        WalLogger.logRec(new WALRecord[]{tx.txState(TransactionState.ROLLED_BACK).time(time - 1L), null});
        T2<List<WALRecord>, List<WALRecord>> tup = WalLogger.recordPerNode();
        IgniteInternalFuture asyncScan1 = this.scanAsync(f1, (WALPointer)p, (List)tup.get1());
        IgniteInternalFuture asyncScan2 = this.scanAsync(f2, (WALPointer)p, (List)tup.get2());
        asyncScan1.get();
        asyncScan2.get();
        Set toRollBack1 = ((PITRFuture.Result)f1.get()).getSkipTxs();
        GridPointInTimeRecoveryFutureTest.assertEquals((int)1, (int)toRollBack1.size());
        GridPointInTimeRecoveryFutureTest.assertTrue((boolean)toRollBack1.contains(tx.nearXidVersion()));
        Set toRollBack2 = ((PITRFuture.Result)f2.get()).getSkipTxs();
        GridPointInTimeRecoveryFutureTest.assertEquals((int)1, (int)toRollBack2.size());
        GridPointInTimeRecoveryFutureTest.assertTrue((boolean)toRollBack2.contains(tx.nearXidVersion()));
    }

    @Test
    public void testPreparedCommitedAfterTimeReachedAndPrepared() throws Exception {
        IgniteEx ig1 = this.startGrid(0);
        IgniteEx ig2 = this.startGrid(1);
        ig1.active(true);
        BaselineTopology blt = ig1.context().state().clusterState().baselineTopology();
        Short consId1 = (Short)blt.consistentIdMapping().get(ig1.context().discovery().consistentId());
        Short consId2 = (Short)blt.consistentIdMapping().get(ig2.context().discovery().consistentId());
        HashMap<Short, Collection<Short>> nodes = new HashMap<Short, Collection<Short>>();
        nodes.put(consId1, Collections.singletonList(consId2));
        long time = System.currentTimeMillis();
        FileWALPointer p = new FileWALPointer(0L, 0, 0);
        PITRFuture f1 = this.createFut(time, ig1);
        PITRFuture f2 = this.createFut(time, ig2);
        this.addListener(ig1, f1);
        this.addListener(ig2, f2);
        TxRec.nextTxVer();
        TxRec tx = new TxRec(null, null, null, nodes, 0L);
        WalLogger.logRec(new WALRecord[]{tx.txState(TransactionState.PREPARED).time(time - 2L), tx.txState(TransactionState.PREPARED).time(time - 2L)});
        WalLogger.logRec(new WALRecord[]{tx.txState(TransactionState.COMMITTED).time(time + 2L), null});
        T2<List<WALRecord>, List<WALRecord>> tup = WalLogger.recordPerNode();
        IgniteInternalFuture asyncScan1 = this.scanAsync(f1, (WALPointer)p, (List)tup.get1());
        IgniteInternalFuture asyncScan2 = this.scanAsync(f2, (WALPointer)p, (List)tup.get2());
        asyncScan1.get();
        asyncScan2.get();
        Set toRollBack1 = ((PITRFuture.Result)f1.get()).getSkipTxs();
        GridPointInTimeRecoveryFutureTest.assertEquals((int)1, (int)toRollBack1.size());
        GridPointInTimeRecoveryFutureTest.assertTrue((boolean)toRollBack1.contains(tx.nearXidVersion()));
        Set toRollBack2 = ((PITRFuture.Result)f2.get()).getSkipTxs();
        GridPointInTimeRecoveryFutureTest.assertEquals((int)1, (int)toRollBack2.size());
        GridPointInTimeRecoveryFutureTest.assertTrue((boolean)toRollBack2.contains(tx.nearXidVersion()));
    }

    @Test
    public void testPreparedRollBackedAfterTimeReachedAndPrepared() throws Exception {
        IgniteEx ig1 = this.startGrid(0);
        IgniteEx ig2 = this.startGrid(1);
        ig1.active(true);
        BaselineTopology blt = ig1.context().state().clusterState().baselineTopology();
        Short consId1 = (Short)blt.consistentIdMapping().get(ig1.context().discovery().consistentId());
        Short consId2 = (Short)blt.consistentIdMapping().get(ig2.context().discovery().consistentId());
        HashMap<Short, Collection<Short>> nodes = new HashMap<Short, Collection<Short>>();
        nodes.put(consId1, Collections.singletonList(consId2));
        long time = System.currentTimeMillis();
        FileWALPointer p = new FileWALPointer(0L, 0, 0);
        PITRFuture f1 = this.createFut(time, ig1);
        PITRFuture f2 = this.createFut(time, ig2);
        this.addListener(ig1, f1);
        this.addListener(ig2, f2);
        TxRec.nextTxVer();
        TxRec tx = new TxRec(null, null, null, nodes, 0L);
        WalLogger.logRec(new WALRecord[]{tx.txState(TransactionState.PREPARED).time(time - 2L), tx.txState(TransactionState.PREPARED).time(time - 2L)});
        WalLogger.logRec(new WALRecord[]{tx.txState(TransactionState.ROLLED_BACK).time(time + 2L), null});
        T2<List<WALRecord>, List<WALRecord>> tup = WalLogger.recordPerNode();
        IgniteInternalFuture asyncScan1 = this.scanAsync(f1, (WALPointer)p, (List)tup.get1());
        IgniteInternalFuture asyncScan2 = this.scanAsync(f2, (WALPointer)p, (List)tup.get2());
        asyncScan1.get();
        asyncScan2.get();
        Set toRollBack1 = ((PITRFuture.Result)f1.get()).getSkipTxs();
        GridPointInTimeRecoveryFutureTest.assertEquals((int)1, (int)toRollBack1.size());
        GridPointInTimeRecoveryFutureTest.assertTrue((boolean)toRollBack1.contains(tx.nearXidVersion()));
        Set toRollBack2 = ((PITRFuture.Result)f2.get()).getSkipTxs();
        GridPointInTimeRecoveryFutureTest.assertEquals((int)1, (int)toRollBack2.size());
        GridPointInTimeRecoveryFutureTest.assertTrue((boolean)toRollBack2.contains(tx.nearXidVersion()));
    }

    private void addListener(IgniteEx ig, final PITRFuture f) {
        final ConsistentIdMapper mapper = new ConsistentIdMapper(ig.context().discovery());
        ig.context().cache().context().gridIO().addMessageListener(GridTopic.TOPIC_SNAPSHOT, new GridMessageListener(){

            public void onMessage(UUID nodeId, Object msg, byte plc) {
                Short constId = mapper.mapToCompactId(AffinityTopologyVersion.NONE, nodeId);
                if (msg instanceof TxStateRequest) {
                    f.processRequest((Object)constId, (TxStateRequest)msg);
                } else if (msg instanceof TxStateResponse) {
                    f.processResponse((Object)constId, (TxStateResponse)msg);
                }
            }
        });
    }

    private IgniteInternalFuture scanAsync(final PITRFuture f, WALPointer p, final List<WALRecord> fakeRecords) {
        return GridTestUtils.runAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                try (FakeIterator it = new FakeIterator(fakeRecords);){
                    f.scan((WALIterator)it);
                }
                catch (IgniteCheckedException e) {
                    throw new IgniteException((Throwable)e);
                }
            }
        });
    }

    private PITRFuture createFut(long time, IgniteEx ig) {
        return null;
    }

    private static class FakeIterator
    implements WALIterator {
        private final Iterator<WALRecord> it;

        private FakeIterator(Collection<WALRecord> records) {
            this.it = records.iterator();
        }

        public boolean hasNextX() throws IgniteCheckedException {
            return this.it.hasNext();
        }

        public IgniteBiTuple<WALPointer, WALRecord> nextX() throws IgniteCheckedException {
            WALRecord r = this.it.next();
            return new T2((Object)r.position(), (Object)r);
        }

        public void removeX() throws IgniteCheckedException {
        }

        public void close() throws IgniteCheckedException {
        }

        public boolean isClosed() {
            return false;
        }

        @NotNull
        public Iterator<IgniteBiTuple<WALPointer, WALRecord>> iterator() {
            return null;
        }

        public boolean hasNext() {
            return this.it.hasNext();
        }

        public IgniteBiTuple<WALPointer, WALRecord> next() {
            WALRecord r = this.it.next();
            return new T2((Object)r.position(), (Object)r);
        }

        public void remove() {
        }

        public Optional<WALPointer> lastRead() {
            return Optional.empty();
        }
    }

    private static class TxRec
    extends TxRecord {
        private static WALPointer pointer = new FileWALPointer(0L, 0, 0);
        private static GridCacheVersion ver = new GridCacheVersion(0, 0, 0L);

        TxRec(TransactionState state, GridCacheVersion nearXidVer, GridCacheVersion writeVer, @Nullable Map<Short, Collection<Short>> participatingNodes, long timestamp) {
            super(state, ver, writeVer, participatingNodes, timestamp);
            this.position(pointer);
        }

        private TxRec txState(TransactionState state) {
            return new TxRec(state, this.nearXidVersion(), this.writeVersion(), this.participatingNodes(), this.timestamp());
        }

        private TxRec time(long time) {
            return new TxRec(this.state(), this.nearXidVersion(), this.writeVersion(), this.participatingNodes(), time);
        }

        public static void nextTxVer() {
            ver = new GridCacheVersion(0, (long)(ver.nodeOrder() + 1), 0, 0);
        }
    }

    static class WalLogger {
        private static List<WALRecord>[] recs = new List[]{new ArrayList(), new ArrayList()};

        WalLogger() {
        }

        public static void logRec(WALRecord ... records) {
            for (int i = 0; i < records.length; ++i) {
                List<WALRecord> list = recs[i];
                WALRecord rec = records[i];
                if (rec == null) continue;
                list.add(rec);
            }
        }

        public static T2<List<WALRecord>, List<WALRecord>> recordPerNode() {
            return new T2(recs[0], recs[1]);
        }

        public static void reset() {
            recs = new List[]{new ArrayList(), new ArrayList()};
        }
    }
}

