/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.recovery;

import org.apache.ignite.IgniteCache;
import org.apache.ignite.internal.IgniteEx;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.processors.cache.database.GridSnapshotEx;
import org.gridgain.grid.internal.processors.cache.database.recovery.GridPointInTimeRecoveryAtomicTest;
import org.junit.Test;

public class GridBaselineBranchingHistoryResetOnPointInTimeRecoveryTest
extends GridPointInTimeRecoveryAtomicTest {
    private static final int KEYS_NUMBER = 100;

    @Override
    @Test
    public void test() throws Exception {
        IgniteEx ig = this.startGrids(4);
        ig.cluster().active(true);
        GridGain gg = (GridGain)ig.plugin("GridGain");
        IgniteCache cache = ig.cache("default");
        this.loadData((IgniteCache<Integer, Integer>)cache, 1);
        Thread.sleep(300L);
        long pointToRecovery = System.currentTimeMillis();
        Thread.sleep(300L);
        this.loadData((IgniteCache<Integer, Integer>)cache, 2);
        this.stopGrid(3);
        GridSnapshotEx rec = (GridSnapshotEx)gg.snapshot();
        rec.recoveryTo(pointToRecovery, null).get();
        this.checkData((IgniteCache<Integer, Integer>)cache, 1);
        try {
            this.startGrid(3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.checkData((IgniteCache<Integer, Integer>)cache, 1);
    }

    private void loadData(IgniteCache<Integer, Integer> cache, int multiplier) {
        for (int i = 0; i < 100; ++i) {
            cache.put((Object)i, (Object)(i * multiplier));
        }
    }

    private void checkData(IgniteCache<Integer, Integer> cache, int multiplier) {
        for (int i = 0; i < 100; ++i) {
            GridBaselineBranchingHistoryResetOnPointInTimeRecoveryTest.assertEquals((int)(i * multiplier), (int)((Integer)cache.get((Object)i)));
        }
    }
}

