/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.persistentstore.RestoreSnapshotParams;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.junit.Test;

@WithSystemProperty(key="GG_EXCHANGELESS_SNAPSHOT_CREATION", value="true")
public class TestExchangelessSnapshotWithPartitionsWithoutPages
extends GridCommonAbstractTest {
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setConsistentId((Serializable)((Object)igniteInstanceName)).setPluginConfigurations(new PluginConfiguration[]{new GridGainConfiguration().setSnapshotConfiguration(new SnapshotConfiguration().setSnapshotsPath(this.snapshotsDir().getPath()))}).setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true)));
    }

    private File snapshotsDir() throws IgniteCheckedException {
        return U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"snapshots", (boolean)false);
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
        U.delete((File)this.snapshotsDir());
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
        U.delete((File)this.snapshotsDir());
        super.afterTest();
    }

    @Test
    public void testSnapshotWithPartitionsWithoutPages() throws Exception {
        IgniteEx ignite = this.startGrids(2);
        ignite.cluster().state(ClusterState.ACTIVE);
        int entriesCount = 500;
        IgniteCache cache = ignite.getOrCreateCache(new CacheConfiguration("default").setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 1000)));
        IgniteInternalFuture fillCacheFut = GridTestUtils.runAsync((Runnable)new Runnable((Ignite)ignite){
            final /* synthetic */ Ignite val$ignite;
            {
                this.val$ignite = ignite;
            }

            @Override
            public void run() {
                try (IgniteDataStreamer ldr = this.val$ignite.dataStreamer("default");){
                    ldr.allowOverwrite(true);
                    HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
                    for (int i = 0; i < 500; ++i) {
                        map.put(i, i);
                    }
                    ldr.addData(map);
                }
            }
        });
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        SnapshotFuture snapshotFuture = gg.snapshot().createFullSnapshot(null, null);
        snapshotFuture.get();
        fillCacheFut.get();
        gg.snapshot().restore(new RestoreSnapshotParams().snapshotId(snapshotFuture.snapshotOperation().snapshotId())).get();
    }
}

